<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatMapQueryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Object to hold criteria used to generate one or more seat maps.
 * @subpackage Structs
 */
class SeatMapQueryType extends AbstractStructBase
{
    /**
     * The FlightInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\FlightInfo[]
     */
    public $FlightInfo;
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - documentation: One or more unique aircraft equipment types to generate a seat map for.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Equipment;
    /**
     * The BookingReferenceID
     * Meta information extracted from the WSDL
     * - documentation: Booking reference (PNR) information if the seat map is being generated by PNR. Note that travelers with associated PNR(s) are defined here.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $BookingReferenceID;
    /**
     * The CabinClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\CabinClass[]
     */
    public $CabinClass;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - documentation: An extensible list of seat features to be included in the seat map. Select an item from the list or use the Other_ list value and enter a seat feature in the @extension attribute that is known to trading partners.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Features;
    /**
     * The SpecificSeatInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\SpecificSeatInfo[]
     */
    public $SpecificSeatInfo;
    /**
     * The SeatDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SeatDetails
     */
    public $SeatDetails;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: An extensible list of seat status types to be included in the seat map. Select an existing value from the list or use "Other_" and the @extension attribute to add a new value known between trading partners.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Status;
    /**
     * The Traveler
     * Meta information extracted from the WSDL
     * - documentation: Details about travelers not associated with a booking reference (PNR.)
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Traveler;
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - documentation: Zones to be included or excluded from the seat map(s).
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Zone;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The SmokingAllowed
     * Meta information extracted from the WSDL
     * - documentation: false | Indicates smoking is allowed when true and is not allowed when false.
     * - use: optional
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The TotalReqSeatQty
     * Meta information extracted from the WSDL
     * - documentation: The calculated number of required seats, e.g.: 0 for Infant On Lap, 1 for Normal Passenger and 2 for Oversized Passenger. This may be used to determine if two seats need to be together.
     * - use: optional
     * @var int
     */
    public $TotalReqSeatQty;
    /**
     * The ChangeInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this is a seat re-accommodation request. In this scenario, two instances of DetailedInfo should be used, one for the original equipment and one for the changed equipment.
     * - use: optional
     * @var bool
     */
    public $ChangeInd;
    /**
     * Constructor method for SeatMapQueryType
     * @uses SeatMapQueryType::setFlightInfo()
     * @uses SeatMapQueryType::setEquipment()
     * @uses SeatMapQueryType::setBookingReferenceID()
     * @uses SeatMapQueryType::setCabinClass()
     * @uses SeatMapQueryType::setFeatures()
     * @uses SeatMapQueryType::setSpecificSeatInfo()
     * @uses SeatMapQueryType::setSeatDetails()
     * @uses SeatMapQueryType::setStatus()
     * @uses SeatMapQueryType::setTraveler()
     * @uses SeatMapQueryType::setZone()
     * @uses SeatMapQueryType::setTPA_Extensions()
     * @uses SeatMapQueryType::setSmokingAllowed()
     * @uses SeatMapQueryType::setTotalReqSeatQty()
     * @uses SeatMapQueryType::setChangeInd()
     * @param \StructType\FlightInfo[] $flightInfo
     * @param mixed[] $equipment
     * @param mixed[] $bookingReferenceID
     * @param \StructType\CabinClass[] $cabinClass
     * @param mixed[] $features
     * @param \StructType\SpecificSeatInfo[] $specificSeatInfo
     * @param \StructType\SeatDetails $seatDetails
     * @param mixed[] $status
     * @param mixed[] $traveler
     * @param mixed[] $zone
     * @param mixed $tPA_Extensions
     * @param bool $smokingAllowed
     * @param int $totalReqSeatQty
     * @param bool $changeInd
     */
    public function __construct(array $flightInfo = array(), array $equipment = array(), array $bookingReferenceID = array(), array $cabinClass = array(), array $features = array(), array $specificSeatInfo = array(), \StructType\SeatDetails $seatDetails = null, array $status = array(), array $traveler = array(), array $zone = array(), $tPA_Extensions = null, $smokingAllowed = null, $totalReqSeatQty = null, $changeInd = null)
    {
        $this
            ->setFlightInfo($flightInfo)
            ->setEquipment($equipment)
            ->setBookingReferenceID($bookingReferenceID)
            ->setCabinClass($cabinClass)
            ->setFeatures($features)
            ->setSpecificSeatInfo($specificSeatInfo)
            ->setSeatDetails($seatDetails)
            ->setStatus($status)
            ->setTraveler($traveler)
            ->setZone($zone)
            ->setTPA_Extensions($tPA_Extensions)
            ->setSmokingAllowed($smokingAllowed)
            ->setTotalReqSeatQty($totalReqSeatQty)
            ->setChangeInd($changeInd);
    }
    /**
     * Get FlightInfo value
     * @return \StructType\FlightInfo[]|null
     */
    public function getFlightInfo()
    {
        return $this->FlightInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightInfoForArrayConstraintsFromSetFlightInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeFlightInfoItem) {
            // validation for constraint: itemType
            if (!$seatMapQueryTypeFlightInfoItem instanceof \StructType\FlightInfo) {
                $invalidValues[] = is_object($seatMapQueryTypeFlightInfoItem) ? get_class($seatMapQueryTypeFlightInfoItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeFlightInfoItem), var_export($seatMapQueryTypeFlightInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightInfo property can only contain items of type \StructType\FlightInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightInfo[] $flightInfo
     * @return \StructType\SeatMapQueryType
     */
    public function setFlightInfo(array $flightInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($flightInfoArrayErrorMessage = self::validateFlightInfoForArrayConstraintsFromSetFlightInfo($flightInfo))) {
            throw new \InvalidArgumentException($flightInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($flightInfo) && count($flightInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($flightInfo)), __LINE__);
        }
        $this->FlightInfo = $flightInfo;
        return $this;
    }
    /**
     * Add item to FlightInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightInfo $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToFlightInfo(\StructType\FlightInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightInfo) {
            throw new \InvalidArgumentException(sprintf('The FlightInfo property can only contain items of type \StructType\FlightInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FlightInfo) && count($this->FlightInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FlightInfo)), __LINE__);
        }
        $this->FlightInfo[] = $item;
        return $this;
    }
    /**
     * Get Equipment value
     * @return mixed[]|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipmentForArrayConstraintsFromSetEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeEquipmentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatMapQueryTypeEquipmentItem) ? get_class($seatMapQueryTypeEquipmentItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeEquipmentItem), var_export($seatMapQueryTypeEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Equipment property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Equipment value
     * @throws \InvalidArgumentException
     * @param mixed[] $equipment
     * @return \StructType\SeatMapQueryType
     */
    public function setEquipment(array $equipment = array())
    {
        // validation for constraint: array
        if ('' !== ($equipmentArrayErrorMessage = self::validateEquipmentForArrayConstraintsFromSetEquipment($equipment))) {
            throw new \InvalidArgumentException($equipmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($equipment) && count($equipment) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($equipment)), __LINE__);
        }
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Add item to Equipment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToEquipment($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Equipment property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Equipment) && count($this->Equipment) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Equipment)), __LINE__);
        }
        $this->Equipment[] = $item;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return mixed[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingReferenceID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingReferenceID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingReferenceIDForArrayConstraintsFromSetBookingReferenceID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatMapQueryTypeBookingReferenceIDItem) ? get_class($seatMapQueryTypeBookingReferenceIDItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeBookingReferenceIDItem), var_export($seatMapQueryTypeBookingReferenceIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingReferenceID property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param mixed[] $bookingReferenceID
     * @return \StructType\SeatMapQueryType
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingReferenceIDArrayErrorMessage = self::validateBookingReferenceIDForArrayConstraintsFromSetBookingReferenceID($bookingReferenceID))) {
            throw new \InvalidArgumentException($bookingReferenceIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($bookingReferenceID) && count($bookingReferenceID) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToBookingReferenceID($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->BookingReferenceID) && count($this->BookingReferenceID) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->BookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get CabinClass value
     * @return \StructType\CabinClass[]|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinClassForArrayConstraintsFromSetCabinClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeCabinClassItem) {
            // validation for constraint: itemType
            if (!$seatMapQueryTypeCabinClassItem instanceof \StructType\CabinClass) {
                $invalidValues[] = is_object($seatMapQueryTypeCabinClassItem) ? get_class($seatMapQueryTypeCabinClassItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeCabinClassItem), var_export($seatMapQueryTypeCabinClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinClass property can only contain items of type \StructType\CabinClass, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass[] $cabinClass
     * @return \StructType\SeatMapQueryType
     */
    public function setCabinClass(array $cabinClass = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinClassArrayErrorMessage = self::validateCabinClassForArrayConstraintsFromSetCabinClass($cabinClass))) {
            throw new \InvalidArgumentException($cabinClassArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($cabinClass) && count($cabinClass) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($cabinClass)), __LINE__);
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Add item to CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToCabinClass(\StructType\CabinClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinClass) {
            throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of type \StructType\CabinClass, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CabinClass) && count($this->CabinClass) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CabinClass)), __LINE__);
        }
        $this->CabinClass[] = $item;
        return $this;
    }
    /**
     * Get Features value
     * @return mixed[]|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * This method is responsible for validating the values passed to the setFeatures method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeatures method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeaturesForArrayConstraintsFromSetFeatures(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeFeaturesItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatMapQueryTypeFeaturesItem) ? get_class($seatMapQueryTypeFeaturesItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeFeaturesItem), var_export($seatMapQueryTypeFeaturesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Features property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Features value
     * @throws \InvalidArgumentException
     * @param mixed[] $features
     * @return \StructType\SeatMapQueryType
     */
    public function setFeatures(array $features = array())
    {
        // validation for constraint: array
        if ('' !== ($featuresArrayErrorMessage = self::validateFeaturesForArrayConstraintsFromSetFeatures($features))) {
            throw new \InvalidArgumentException($featuresArrayErrorMessage, __LINE__);
        }
        $this->Features = $features;
        return $this;
    }
    /**
     * Add item to Features value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToFeatures($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Features property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Features[] = $item;
        return $this;
    }
    /**
     * Get SpecificSeatInfo value
     * @return \StructType\SpecificSeatInfo[]|null
     */
    public function getSpecificSeatInfo()
    {
        return $this->SpecificSeatInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecificSeatInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecificSeatInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecificSeatInfoForArrayConstraintsFromSetSpecificSeatInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeSpecificSeatInfoItem) {
            // validation for constraint: itemType
            if (!$seatMapQueryTypeSpecificSeatInfoItem instanceof \StructType\SpecificSeatInfo) {
                $invalidValues[] = is_object($seatMapQueryTypeSpecificSeatInfoItem) ? get_class($seatMapQueryTypeSpecificSeatInfoItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeSpecificSeatInfoItem), var_export($seatMapQueryTypeSpecificSeatInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecificSeatInfo property can only contain items of type \StructType\SpecificSeatInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecificSeatInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecificSeatInfo[] $specificSeatInfo
     * @return \StructType\SeatMapQueryType
     */
    public function setSpecificSeatInfo(array $specificSeatInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($specificSeatInfoArrayErrorMessage = self::validateSpecificSeatInfoForArrayConstraintsFromSetSpecificSeatInfo($specificSeatInfo))) {
            throw new \InvalidArgumentException($specificSeatInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($specificSeatInfo) && count($specificSeatInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($specificSeatInfo)), __LINE__);
        }
        $this->SpecificSeatInfo = $specificSeatInfo;
        return $this;
    }
    /**
     * Add item to SpecificSeatInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecificSeatInfo $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToSpecificSeatInfo(\StructType\SpecificSeatInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecificSeatInfo) {
            throw new \InvalidArgumentException(sprintf('The SpecificSeatInfo property can only contain items of type \StructType\SpecificSeatInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->SpecificSeatInfo) && count($this->SpecificSeatInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->SpecificSeatInfo)), __LINE__);
        }
        $this->SpecificSeatInfo[] = $item;
        return $this;
    }
    /**
     * Get SeatDetails value
     * @return \StructType\SeatDetails|null
     */
    public function getSeatDetails()
    {
        return $this->SeatDetails;
    }
    /**
     * Set SeatDetails value
     * @param \StructType\SeatDetails $seatDetails
     * @return \StructType\SeatMapQueryType
     */
    public function setSeatDetails(\StructType\SeatDetails $seatDetails = null)
    {
        $this->SeatDetails = $seatDetails;
        return $this;
    }
    /**
     * Get Status value
     * @return mixed[]|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusForArrayConstraintsFromSetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeStatusItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatMapQueryTypeStatusItem) ? get_class($seatMapQueryTypeStatusItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeStatusItem), var_export($seatMapQueryTypeStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Status property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Status value
     * @throws \InvalidArgumentException
     * @param mixed[] $status
     * @return \StructType\SeatMapQueryType
     */
    public function setStatus(array $status = array())
    {
        // validation for constraint: array
        if ('' !== ($statusArrayErrorMessage = self::validateStatusForArrayConstraintsFromSetStatus($status))) {
            throw new \InvalidArgumentException($statusArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($status) && count($status) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Add item to Status value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToStatus($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Status property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Status) && count($this->Status) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Status)), __LINE__);
        }
        $this->Status[] = $item;
        return $this;
    }
    /**
     * Get Traveler value
     * @return mixed[]|null
     */
    public function getTraveler()
    {
        return $this->Traveler;
    }
    /**
     * This method is responsible for validating the values passed to the setTraveler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTraveler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerForArrayConstraintsFromSetTraveler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeTravelerItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatMapQueryTypeTravelerItem) ? get_class($seatMapQueryTypeTravelerItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeTravelerItem), var_export($seatMapQueryTypeTravelerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Traveler property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Traveler value
     * @throws \InvalidArgumentException
     * @param mixed[] $traveler
     * @return \StructType\SeatMapQueryType
     */
    public function setTraveler(array $traveler = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerArrayErrorMessage = self::validateTravelerForArrayConstraintsFromSetTraveler($traveler))) {
            throw new \InvalidArgumentException($travelerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($traveler) && count($traveler) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($traveler)), __LINE__);
        }
        $this->Traveler = $traveler;
        return $this;
    }
    /**
     * Add item to Traveler value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToTraveler($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Traveler property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Traveler) && count($this->Traveler) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Traveler)), __LINE__);
        }
        $this->Traveler[] = $item;
        return $this;
    }
    /**
     * Get Zone value
     * @return mixed[]|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * This method is responsible for validating the values passed to the setZone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZoneForArrayConstraintsFromSetZone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatMapQueryTypeZoneItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatMapQueryTypeZoneItem) ? get_class($seatMapQueryTypeZoneItem) : sprintf('%s(%s)', gettype($seatMapQueryTypeZoneItem), var_export($seatMapQueryTypeZoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Zone property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Zone value
     * @throws \InvalidArgumentException
     * @param mixed[] $zone
     * @return \StructType\SeatMapQueryType
     */
    public function setZone(array $zone = array())
    {
        // validation for constraint: array
        if ('' !== ($zoneArrayErrorMessage = self::validateZoneForArrayConstraintsFromSetZone($zone))) {
            throw new \InvalidArgumentException($zoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($zone) && count($zone) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Add item to Zone value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatMapQueryType
     */
    public function addToZone($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Zone property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Zone) && count($this->Zone) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Zone)), __LINE__);
        }
        $this->Zone[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\SeatMapQueryType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\SeatMapQueryType
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get TotalReqSeatQty value
     * @return int|null
     */
    public function getTotalReqSeatQty()
    {
        return $this->TotalReqSeatQty;
    }
    /**
     * Set TotalReqSeatQty value
     * @param int $totalReqSeatQty
     * @return \StructType\SeatMapQueryType
     */
    public function setTotalReqSeatQty($totalReqSeatQty = null)
    {
        // validation for constraint: int
        if (!is_null($totalReqSeatQty) && !(is_int($totalReqSeatQty) || ctype_digit($totalReqSeatQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalReqSeatQty, true), gettype($totalReqSeatQty)), __LINE__);
        }
        $this->TotalReqSeatQty = $totalReqSeatQty;
        return $this;
    }
    /**
     * Get ChangeInd value
     * @return bool|null
     */
    public function getChangeInd()
    {
        return $this->ChangeInd;
    }
    /**
     * Set ChangeInd value
     * @param bool $changeInd
     * @return \StructType\SeatMapQueryType
     */
    public function setChangeInd($changeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($changeInd) && !is_bool($changeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($changeInd, true), gettype($changeInd)), __LINE__);
        }
        $this->ChangeInd = $changeInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatMapQueryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
