<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the row details in a seat map.
 * @subpackage Structs
 */
class SeatDetailsType extends AbstractStructBase
{
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - documentation: Summary seat information.
     * - minOccurs: 0
     * @var mixed
     */
    public $Summary;
    /**
     * The Amenity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Amenity[]
     */
    public $Amenity;
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - documentation: The seat availability. Select an item from the list or select the "Other_" value and enter a value known to trading partners in the @extension attribute.
     * - minOccurs: 0
     * @var mixed
     */
    public $Availability;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Seat description.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - documentation: An extensible list of seat features. Select an existing value from the list or select the "Other_" value and enter a value known to trading partners in the @extension attribute.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Features;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - documentation: Remarks about the seat.
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Service[]
     */
    public $Service;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: An extensible list of seat status types. Select an existing value from the list or use "Other_" and the @extension attribute to add a new value known between trading partners.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Status;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The GridNumber
     * Meta information extracted from the WSDL
     * - documentation: The grid number associated with the seat.
     * - use: optional
     * @var int
     */
    public $GridNumber;
    /**
     * The ColumnNumber
     * Meta information extracted from the WSDL
     * - documentation: The column number associated with the seat.
     * - use: optional
     * @var int
     */
    public $ColumnNumber;
    /**
     * The BlockedInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the seat is blocked.
     * - use: optional
     * @var bool
     */
    public $BlockedInd;
    /**
     * The BufferInd
     * Meta information extracted from the WSDL
     * - documentation: If true, ths seat is buffered.
     * - use: optional
     * @var bool
     */
    public $BufferInd;
    /**
     * The PremiumInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is a premium seat that may be subjected to additional fees.
     * - use: optional
     * @var bool
     */
    public $PremiumInd;
    /**
     * The PremiumCode
     * Meta information extracted from the WSDL
     * - documentation: The type or level of premium seat.
     * - use: optional
     * @var string
     */
    public $PremiumCode;
    /**
     * The BulkheadInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is in a bulkhead row.
     * - use: optional
     * @var bool
     */
    public $BulkheadInd;
    /**
     * The ExitRowInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is in an exit row.
     * - use: optional
     * @var bool
     */
    public $ExitRowInd;
    /**
     * The GalleyInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is near a gally.
     * - use: optional
     * @var bool
     */
    public $GalleyInd;
    /**
     * The PlaneSection
     * Meta information extracted from the WSDL
     * - documentation: The section of the plane the seat is located in.
     * - use: optional
     * @var string
     */
    public $PlaneSection;
    /**
     * The ColumnSpan
     * Meta information extracted from the WSDL
     * - documentation: The number of columns the seat spans.
     * - use: optional
     * @var int
     */
    public $ColumnSpan;
    /**
     * The RowSpan
     * Meta information extracted from the WSDL
     * - documentation: The number of rows the seat spans.
     * - use: optional
     * @var int
     */
    public $RowSpan;
    /**
     * Constructor method for SeatDetailsType
     * @uses SeatDetailsType::setSummary()
     * @uses SeatDetailsType::setAmenity()
     * @uses SeatDetailsType::setAvailability()
     * @uses SeatDetailsType::setDescription()
     * @uses SeatDetailsType::setFeatures()
     * @uses SeatDetailsType::setRemarks()
     * @uses SeatDetailsType::setService()
     * @uses SeatDetailsType::setStatus()
     * @uses SeatDetailsType::setTPA_Extensions()
     * @uses SeatDetailsType::setGridNumber()
     * @uses SeatDetailsType::setColumnNumber()
     * @uses SeatDetailsType::setBlockedInd()
     * @uses SeatDetailsType::setBufferInd()
     * @uses SeatDetailsType::setPremiumInd()
     * @uses SeatDetailsType::setPremiumCode()
     * @uses SeatDetailsType::setBulkheadInd()
     * @uses SeatDetailsType::setExitRowInd()
     * @uses SeatDetailsType::setGalleyInd()
     * @uses SeatDetailsType::setPlaneSection()
     * @uses SeatDetailsType::setColumnSpan()
     * @uses SeatDetailsType::setRowSpan()
     * @param mixed $summary
     * @param \StructType\Amenity[] $amenity
     * @param mixed $availability
     * @param mixed[] $description
     * @param mixed[] $features
     * @param string $remarks
     * @param \StructType\Service[] $service
     * @param mixed[] $status
     * @param mixed $tPA_Extensions
     * @param int $gridNumber
     * @param int $columnNumber
     * @param bool $blockedInd
     * @param bool $bufferInd
     * @param bool $premiumInd
     * @param string $premiumCode
     * @param bool $bulkheadInd
     * @param bool $exitRowInd
     * @param bool $galleyInd
     * @param string $planeSection
     * @param int $columnSpan
     * @param int $rowSpan
     */
    public function __construct($summary = null, array $amenity = array(), $availability = null, array $description = array(), array $features = array(), $remarks = null, array $service = array(), array $status = array(), $tPA_Extensions = null, $gridNumber = null, $columnNumber = null, $blockedInd = null, $bufferInd = null, $premiumInd = null, $premiumCode = null, $bulkheadInd = null, $exitRowInd = null, $galleyInd = null, $planeSection = null, $columnSpan = null, $rowSpan = null)
    {
        $this
            ->setSummary($summary)
            ->setAmenity($amenity)
            ->setAvailability($availability)
            ->setDescription($description)
            ->setFeatures($features)
            ->setRemarks($remarks)
            ->setService($service)
            ->setStatus($status)
            ->setTPA_Extensions($tPA_Extensions)
            ->setGridNumber($gridNumber)
            ->setColumnNumber($columnNumber)
            ->setBlockedInd($blockedInd)
            ->setBufferInd($bufferInd)
            ->setPremiumInd($premiumInd)
            ->setPremiumCode($premiumCode)
            ->setBulkheadInd($bulkheadInd)
            ->setExitRowInd($exitRowInd)
            ->setGalleyInd($galleyInd)
            ->setPlaneSection($planeSection)
            ->setColumnSpan($columnSpan)
            ->setRowSpan($rowSpan);
    }
    /**
     * Get Summary value
     * @return mixed|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param mixed $summary
     * @return \StructType\SeatDetailsType
     */
    public function setSummary($summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get Amenity value
     * @return \StructType\Amenity[]|null
     */
    public function getAmenity()
    {
        return $this->Amenity;
    }
    /**
     * This method is responsible for validating the values passed to the setAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmenityForArrayConstraintsFromSetAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatDetailsTypeAmenityItem) {
            // validation for constraint: itemType
            if (!$seatDetailsTypeAmenityItem instanceof \StructType\Amenity) {
                $invalidValues[] = is_object($seatDetailsTypeAmenityItem) ? get_class($seatDetailsTypeAmenityItem) : sprintf('%s(%s)', gettype($seatDetailsTypeAmenityItem), var_export($seatDetailsTypeAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Amenity property can only contain items of type \StructType\Amenity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Amenity value
     * @throws \InvalidArgumentException
     * @param \StructType\Amenity[] $amenity
     * @return \StructType\SeatDetailsType
     */
    public function setAmenity(array $amenity = array())
    {
        // validation for constraint: array
        if ('' !== ($amenityArrayErrorMessage = self::validateAmenityForArrayConstraintsFromSetAmenity($amenity))) {
            throw new \InvalidArgumentException($amenityArrayErrorMessage, __LINE__);
        }
        $this->Amenity = $amenity;
        return $this;
    }
    /**
     * Add item to Amenity value
     * @throws \InvalidArgumentException
     * @param \StructType\Amenity $item
     * @return \StructType\SeatDetailsType
     */
    public function addToAmenity(\StructType\Amenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Amenity) {
            throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of type \StructType\Amenity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Amenity[] = $item;
        return $this;
    }
    /**
     * Get Availability value
     * @return mixed|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param mixed $availability
     * @return \StructType\SeatDetailsType
     */
    public function setAvailability($availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatDetailsTypeDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatDetailsTypeDescriptionItem) ? get_class($seatDetailsTypeDescriptionItem) : sprintf('%s(%s)', gettype($seatDetailsTypeDescriptionItem), var_export($seatDetailsTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\SeatDetailsType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($description) && count($description) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatDetailsType
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Description) && count($this->Description) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Features value
     * @return mixed[]|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * This method is responsible for validating the values passed to the setFeatures method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeatures method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeaturesForArrayConstraintsFromSetFeatures(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatDetailsTypeFeaturesItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatDetailsTypeFeaturesItem) ? get_class($seatDetailsTypeFeaturesItem) : sprintf('%s(%s)', gettype($seatDetailsTypeFeaturesItem), var_export($seatDetailsTypeFeaturesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Features property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Features value
     * @throws \InvalidArgumentException
     * @param mixed[] $features
     * @return \StructType\SeatDetailsType
     */
    public function setFeatures(array $features = array())
    {
        // validation for constraint: array
        if ('' !== ($featuresArrayErrorMessage = self::validateFeaturesForArrayConstraintsFromSetFeatures($features))) {
            throw new \InvalidArgumentException($featuresArrayErrorMessage, __LINE__);
        }
        $this->Features = $features;
        return $this;
    }
    /**
     * Add item to Features value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatDetailsType
     */
    public function addToFeatures($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Features property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Features[] = $item;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\SeatDetailsType
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\Service[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatDetailsTypeServiceItem) {
            // validation for constraint: itemType
            if (!$seatDetailsTypeServiceItem instanceof \StructType\Service) {
                $invalidValues[] = is_object($seatDetailsTypeServiceItem) ? get_class($seatDetailsTypeServiceItem) : sprintf('%s(%s)', gettype($seatDetailsTypeServiceItem), var_export($seatDetailsTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service[] $service
     * @return \StructType\SeatDetailsType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service $item
     * @return \StructType\SeatDetailsType
     */
    public function addToService(\StructType\Service $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Service) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return mixed[]|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusForArrayConstraintsFromSetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatDetailsTypeStatusItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatDetailsTypeStatusItem) ? get_class($seatDetailsTypeStatusItem) : sprintf('%s(%s)', gettype($seatDetailsTypeStatusItem), var_export($seatDetailsTypeStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Status property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Status value
     * @throws \InvalidArgumentException
     * @param mixed[] $status
     * @return \StructType\SeatDetailsType
     */
    public function setStatus(array $status = array())
    {
        // validation for constraint: array
        if ('' !== ($statusArrayErrorMessage = self::validateStatusForArrayConstraintsFromSetStatus($status))) {
            throw new \InvalidArgumentException($statusArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($status) && count($status) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Add item to Status value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatDetailsType
     */
    public function addToStatus($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Status property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Status) && count($this->Status) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Status)), __LINE__);
        }
        $this->Status[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\SeatDetailsType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get GridNumber value
     * @return int|null
     */
    public function getGridNumber()
    {
        return $this->GridNumber;
    }
    /**
     * Set GridNumber value
     * @param int $gridNumber
     * @return \StructType\SeatDetailsType
     */
    public function setGridNumber($gridNumber = null)
    {
        // validation for constraint: int
        if (!is_null($gridNumber) && !(is_int($gridNumber) || ctype_digit($gridNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gridNumber, true), gettype($gridNumber)), __LINE__);
        }
        $this->GridNumber = $gridNumber;
        return $this;
    }
    /**
     * Get ColumnNumber value
     * @return int|null
     */
    public function getColumnNumber()
    {
        return $this->ColumnNumber;
    }
    /**
     * Set ColumnNumber value
     * @param int $columnNumber
     * @return \StructType\SeatDetailsType
     */
    public function setColumnNumber($columnNumber = null)
    {
        // validation for constraint: int
        if (!is_null($columnNumber) && !(is_int($columnNumber) || ctype_digit($columnNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($columnNumber, true), gettype($columnNumber)), __LINE__);
        }
        $this->ColumnNumber = $columnNumber;
        return $this;
    }
    /**
     * Get BlockedInd value
     * @return bool|null
     */
    public function getBlockedInd()
    {
        return $this->BlockedInd;
    }
    /**
     * Set BlockedInd value
     * @param bool $blockedInd
     * @return \StructType\SeatDetailsType
     */
    public function setBlockedInd($blockedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($blockedInd) && !is_bool($blockedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blockedInd, true), gettype($blockedInd)), __LINE__);
        }
        $this->BlockedInd = $blockedInd;
        return $this;
    }
    /**
     * Get BufferInd value
     * @return bool|null
     */
    public function getBufferInd()
    {
        return $this->BufferInd;
    }
    /**
     * Set BufferInd value
     * @param bool $bufferInd
     * @return \StructType\SeatDetailsType
     */
    public function setBufferInd($bufferInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($bufferInd) && !is_bool($bufferInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bufferInd, true), gettype($bufferInd)), __LINE__);
        }
        $this->BufferInd = $bufferInd;
        return $this;
    }
    /**
     * Get PremiumInd value
     * @return bool|null
     */
    public function getPremiumInd()
    {
        return $this->PremiumInd;
    }
    /**
     * Set PremiumInd value
     * @param bool $premiumInd
     * @return \StructType\SeatDetailsType
     */
    public function setPremiumInd($premiumInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($premiumInd) && !is_bool($premiumInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($premiumInd, true), gettype($premiumInd)), __LINE__);
        }
        $this->PremiumInd = $premiumInd;
        return $this;
    }
    /**
     * Get PremiumCode value
     * @return string|null
     */
    public function getPremiumCode()
    {
        return $this->PremiumCode;
    }
    /**
     * Set PremiumCode value
     * @param string $premiumCode
     * @return \StructType\SeatDetailsType
     */
    public function setPremiumCode($premiumCode = null)
    {
        // validation for constraint: string
        if (!is_null($premiumCode) && !is_string($premiumCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premiumCode, true), gettype($premiumCode)), __LINE__);
        }
        $this->PremiumCode = $premiumCode;
        return $this;
    }
    /**
     * Get BulkheadInd value
     * @return bool|null
     */
    public function getBulkheadInd()
    {
        return $this->BulkheadInd;
    }
    /**
     * Set BulkheadInd value
     * @param bool $bulkheadInd
     * @return \StructType\SeatDetailsType
     */
    public function setBulkheadInd($bulkheadInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($bulkheadInd) && !is_bool($bulkheadInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bulkheadInd, true), gettype($bulkheadInd)), __LINE__);
        }
        $this->BulkheadInd = $bulkheadInd;
        return $this;
    }
    /**
     * Get ExitRowInd value
     * @return bool|null
     */
    public function getExitRowInd()
    {
        return $this->ExitRowInd;
    }
    /**
     * Set ExitRowInd value
     * @param bool $exitRowInd
     * @return \StructType\SeatDetailsType
     */
    public function setExitRowInd($exitRowInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($exitRowInd) && !is_bool($exitRowInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exitRowInd, true), gettype($exitRowInd)), __LINE__);
        }
        $this->ExitRowInd = $exitRowInd;
        return $this;
    }
    /**
     * Get GalleyInd value
     * @return bool|null
     */
    public function getGalleyInd()
    {
        return $this->GalleyInd;
    }
    /**
     * Set GalleyInd value
     * @param bool $galleyInd
     * @return \StructType\SeatDetailsType
     */
    public function setGalleyInd($galleyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($galleyInd) && !is_bool($galleyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($galleyInd, true), gettype($galleyInd)), __LINE__);
        }
        $this->GalleyInd = $galleyInd;
        return $this;
    }
    /**
     * Get PlaneSection value
     * @return string|null
     */
    public function getPlaneSection()
    {
        return $this->PlaneSection;
    }
    /**
     * Set PlaneSection value
     * @param string $planeSection
     * @return \StructType\SeatDetailsType
     */
    public function setPlaneSection($planeSection = null)
    {
        // validation for constraint: string
        if (!is_null($planeSection) && !is_string($planeSection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planeSection, true), gettype($planeSection)), __LINE__);
        }
        $this->PlaneSection = $planeSection;
        return $this;
    }
    /**
     * Get ColumnSpan value
     * @return int|null
     */
    public function getColumnSpan()
    {
        return $this->ColumnSpan;
    }
    /**
     * Set ColumnSpan value
     * @param int $columnSpan
     * @return \StructType\SeatDetailsType
     */
    public function setColumnSpan($columnSpan = null)
    {
        // validation for constraint: int
        if (!is_null($columnSpan) && !(is_int($columnSpan) || ctype_digit($columnSpan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($columnSpan, true), gettype($columnSpan)), __LINE__);
        }
        $this->ColumnSpan = $columnSpan;
        return $this;
    }
    /**
     * Get RowSpan value
     * @return int|null
     */
    public function getRowSpan()
    {
        return $this->RowSpan;
    }
    /**
     * Set RowSpan value
     * @param int $rowSpan
     * @return \StructType\SeatDetailsType
     */
    public function setRowSpan($rowSpan = null)
    {
        // validation for constraint: int
        if (!is_null($rowSpan) && !(is_int($rowSpan) || ctype_digit($rowSpan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowSpan, true), gettype($rowSpan)), __LINE__);
        }
        $this->RowSpan = $rowSpan;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
