<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SailingInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information pertaining to the selected sailing.
 * @subpackage Structs
 */
class SailingInfoType extends AbstractStructBase
{
    /**
     * The SelectedSailing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SelectedSailing
     */
    public $SelectedSailing;
    /**
     * The InclusivePackageOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InclusivePackageOption
     */
    public $InclusivePackageOption;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $Currency;
    /**
     * Constructor method for SailingInfoType
     * @uses SailingInfoType::setSelectedSailing()
     * @uses SailingInfoType::setInclusivePackageOption()
     * @uses SailingInfoType::setCurrency()
     * @param \StructType\SelectedSailing $selectedSailing
     * @param \StructType\InclusivePackageOption $inclusivePackageOption
     * @param \StructType\Currency $currency
     */
    public function __construct(\StructType\SelectedSailing $selectedSailing = null, \StructType\InclusivePackageOption $inclusivePackageOption = null, \StructType\Currency $currency = null)
    {
        $this
            ->setSelectedSailing($selectedSailing)
            ->setInclusivePackageOption($inclusivePackageOption)
            ->setCurrency($currency);
    }
    /**
     * Get SelectedSailing value
     * @return \StructType\SelectedSailing|null
     */
    public function getSelectedSailing()
    {
        return $this->SelectedSailing;
    }
    /**
     * Set SelectedSailing value
     * @param \StructType\SelectedSailing $selectedSailing
     * @return \StructType\SailingInfoType
     */
    public function setSelectedSailing(\StructType\SelectedSailing $selectedSailing = null)
    {
        $this->SelectedSailing = $selectedSailing;
        return $this;
    }
    /**
     * Get InclusivePackageOption value
     * @return \StructType\InclusivePackageOption|null
     */
    public function getInclusivePackageOption()
    {
        return $this->InclusivePackageOption;
    }
    /**
     * Set InclusivePackageOption value
     * @param \StructType\InclusivePackageOption $inclusivePackageOption
     * @return \StructType\SailingInfoType
     */
    public function setInclusivePackageOption(\StructType\InclusivePackageOption $inclusivePackageOption = null)
    {
        $this->InclusivePackageOption = $inclusivePackageOption;
        return $this;
    }
    /**
     * Get Currency value
     * @return \StructType\Currency|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param \StructType\Currency $currency
     * @return \StructType\SailingInfoType
     */
    public function setCurrency(\StructType\Currency $currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SailingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
