<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Information regarding restrictions governing use of the fare. | Information for individual airline applied rules.
 * @subpackage Structs
 */
class RuleInfo extends RuleInfoType
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the applied rule.
     * - use: required
     * @var string
     */
    public $Name;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: The version of the rule.
     * - use: optional
     * @var int
     */
    public $Version;
    /**
     * The TripType
     * Meta information extracted from the WSDL
     * - documentation: To specify if the trip is one way or roundtrip.
     * - use: optional
     * @var string
     */
    public $TripType;
    /**
     * The MoneySaverInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the fare rule being requested is for all airline fares for the specified city pair. If false, it is not.
     * - use: optional
     * @var bool
     */
    public $MoneySaverInd;
    /**
     * Constructor method for RuleInfo
     * @uses RuleInfo::setName()
     * @uses RuleInfo::setVersion()
     * @uses RuleInfo::setTripType()
     * @uses RuleInfo::setMoneySaverInd()
     * @param string $name
     * @param int $version
     * @param string $tripType
     * @param bool $moneySaverInd
     */
    public function __construct($name = null, $version = null, $tripType = null, $moneySaverInd = null)
    {
        $this
            ->setName($name)
            ->setVersion($version)
            ->setTripType($tripType)
            ->setMoneySaverInd($moneySaverInd);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\RuleInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param int $version
     * @return \StructType\RuleInfo
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TripType value
     * @return string|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @uses \EnumType\AirTripType::valueIsValid()
     * @uses \EnumType\AirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripType
     * @return \StructType\RuleInfo
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTripType::valueIsValid($tripType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTripType', is_array($tripType) ? implode(', ', $tripType) : var_export($tripType, true), implode(', ', \EnumType\AirTripType::getValidValues())), __LINE__);
        }
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get MoneySaverInd value
     * @return bool|null
     */
    public function getMoneySaverInd()
    {
        return $this->MoneySaverInd;
    }
    /**
     * Set MoneySaverInd value
     * @param bool $moneySaverInd
     * @return \StructType\RuleInfo
     */
    public function setMoneySaverInd($moneySaverInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($moneySaverInd) && !is_bool($moneySaverInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moneySaverInd, true), gettype($moneySaverInd)), __LINE__);
        }
        $this->MoneySaverInd = $moneySaverInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RuleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
