<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RowDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the row details in a seat map.
 * @subpackage Structs
 */
class RowDetailType extends AbstractStructBase
{
    /**
     * The Characteristics
     * Meta information extracted from the WSDL
     * - documentation: Row characteristics.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Characteristics;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Row description.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The SeatInfo
     * Meta information extracted from the WSDL
     * - documentation: Summary and detailed seat information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SeatInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The OperableInd
     * Meta information extracted from the WSDL
     * - documentation: if true, the row is operable.
     * - use: optional
     * @var bool
     */
    public $OperableInd;
    /**
     * The PlaneSection
     * Meta information extracted from the WSDL
     * - documentation: The section of the plane the row is located in.
     * - use: optional
     * @var string
     */
    public $PlaneSection;
    /**
     * The GridNumber
     * Meta information extracted from the WSDL
     * - documentation: The grid number associated with the row.
     * - use: optional
     * @var int
     */
    public $GridNumber;
    /**
     * The BufferInd
     * Meta information extracted from the WSDL
     * - documentation: If true, ths row is buffered.
     * - use: optional
     * @var bool
     */
    public $BufferInd;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Marketing name as defined by an airline for the first, business or economy cabin.
     * - use: optional
     * @var string
     */
    public $CabinType;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: The row number.
     * - use: optional
     * @var int
     */
    public $RowNumber;
    /**
     * Constructor method for RowDetailType
     * @uses RowDetailType::setCharacteristics()
     * @uses RowDetailType::setDescription()
     * @uses RowDetailType::setSeatInfo()
     * @uses RowDetailType::setTPA_Extensions()
     * @uses RowDetailType::setOperableInd()
     * @uses RowDetailType::setPlaneSection()
     * @uses RowDetailType::setGridNumber()
     * @uses RowDetailType::setBufferInd()
     * @uses RowDetailType::setCabinType()
     * @uses RowDetailType::setRowNumber()
     * @param mixed[] $characteristics
     * @param mixed[] $description
     * @param mixed[] $seatInfo
     * @param mixed $tPA_Extensions
     * @param bool $operableInd
     * @param string $planeSection
     * @param int $gridNumber
     * @param bool $bufferInd
     * @param string $cabinType
     * @param int $rowNumber
     */
    public function __construct(array $characteristics = array(), array $description = array(), array $seatInfo = array(), $tPA_Extensions = null, $operableInd = null, $planeSection = null, $gridNumber = null, $bufferInd = null, $cabinType = null, $rowNumber = null)
    {
        $this
            ->setCharacteristics($characteristics)
            ->setDescription($description)
            ->setSeatInfo($seatInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setOperableInd($operableInd)
            ->setPlaneSection($planeSection)
            ->setGridNumber($gridNumber)
            ->setBufferInd($bufferInd)
            ->setCabinType($cabinType)
            ->setRowNumber($rowNumber);
    }
    /**
     * Get Characteristics value
     * @return mixed[]|null
     */
    public function getCharacteristics()
    {
        return $this->Characteristics;
    }
    /**
     * This method is responsible for validating the values passed to the setCharacteristics method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharacteristics method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCharacteristicsForArrayConstraintsFromSetCharacteristics(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rowDetailTypeCharacteristicsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($rowDetailTypeCharacteristicsItem) ? get_class($rowDetailTypeCharacteristicsItem) : sprintf('%s(%s)', gettype($rowDetailTypeCharacteristicsItem), var_export($rowDetailTypeCharacteristicsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Characteristics property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Characteristics value
     * @throws \InvalidArgumentException
     * @param mixed[] $characteristics
     * @return \StructType\RowDetailType
     */
    public function setCharacteristics(array $characteristics = array())
    {
        // validation for constraint: array
        if ('' !== ($characteristicsArrayErrorMessage = self::validateCharacteristicsForArrayConstraintsFromSetCharacteristics($characteristics))) {
            throw new \InvalidArgumentException($characteristicsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($characteristics) && count($characteristics) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($characteristics)), __LINE__);
        }
        $this->Characteristics = $characteristics;
        return $this;
    }
    /**
     * Add item to Characteristics value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RowDetailType
     */
    public function addToCharacteristics($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Characteristics property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Characteristics) && count($this->Characteristics) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Characteristics)), __LINE__);
        }
        $this->Characteristics[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rowDetailTypeDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($rowDetailTypeDescriptionItem) ? get_class($rowDetailTypeDescriptionItem) : sprintf('%s(%s)', gettype($rowDetailTypeDescriptionItem), var_export($rowDetailTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\RowDetailType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($description) && count($description) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RowDetailType
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Description) && count($this->Description) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get SeatInfo value
     * @return mixed[]|null
     */
    public function getSeatInfo()
    {
        return $this->SeatInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatInfoForArrayConstraintsFromSetSeatInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rowDetailTypeSeatInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($rowDetailTypeSeatInfoItem) ? get_class($rowDetailTypeSeatInfoItem) : sprintf('%s(%s)', gettype($rowDetailTypeSeatInfoItem), var_export($rowDetailTypeSeatInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $seatInfo
     * @return \StructType\RowDetailType
     */
    public function setSeatInfo(array $seatInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($seatInfoArrayErrorMessage = self::validateSeatInfoForArrayConstraintsFromSetSeatInfo($seatInfo))) {
            throw new \InvalidArgumentException($seatInfoArrayErrorMessage, __LINE__);
        }
        $this->SeatInfo = $seatInfo;
        return $this;
    }
    /**
     * Add item to SeatInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RowDetailType
     */
    public function addToSeatInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SeatInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatInfo[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RowDetailType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get OperableInd value
     * @return bool|null
     */
    public function getOperableInd()
    {
        return $this->OperableInd;
    }
    /**
     * Set OperableInd value
     * @param bool $operableInd
     * @return \StructType\RowDetailType
     */
    public function setOperableInd($operableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($operableInd) && !is_bool($operableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($operableInd, true), gettype($operableInd)), __LINE__);
        }
        $this->OperableInd = $operableInd;
        return $this;
    }
    /**
     * Get PlaneSection value
     * @return string|null
     */
    public function getPlaneSection()
    {
        return $this->PlaneSection;
    }
    /**
     * Set PlaneSection value
     * @param string $planeSection
     * @return \StructType\RowDetailType
     */
    public function setPlaneSection($planeSection = null)
    {
        // validation for constraint: string
        if (!is_null($planeSection) && !is_string($planeSection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planeSection, true), gettype($planeSection)), __LINE__);
        }
        $this->PlaneSection = $planeSection;
        return $this;
    }
    /**
     * Get GridNumber value
     * @return int|null
     */
    public function getGridNumber()
    {
        return $this->GridNumber;
    }
    /**
     * Set GridNumber value
     * @param int $gridNumber
     * @return \StructType\RowDetailType
     */
    public function setGridNumber($gridNumber = null)
    {
        // validation for constraint: int
        if (!is_null($gridNumber) && !(is_int($gridNumber) || ctype_digit($gridNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gridNumber, true), gettype($gridNumber)), __LINE__);
        }
        $this->GridNumber = $gridNumber;
        return $this;
    }
    /**
     * Get BufferInd value
     * @return bool|null
     */
    public function getBufferInd()
    {
        return $this->BufferInd;
    }
    /**
     * Set BufferInd value
     * @param bool $bufferInd
     * @return \StructType\RowDetailType
     */
    public function setBufferInd($bufferInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($bufferInd) && !is_bool($bufferInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bufferInd, true), gettype($bufferInd)), __LINE__);
        }
        $this->BufferInd = $bufferInd;
        return $this;
    }
    /**
     * Get CabinType value
     * @return string|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \StructType\RowDetailType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($cabinType) ? implode(', ', $cabinType) : var_export($cabinType, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\RowDetailType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RowDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
