<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides details of the room type. | Provides details regarding rooms, usually guest rooms.
 * @subpackage Structs
 */
class RoomTypeType extends AbstractStructBase
{
    /**
     * The RoomDescription
     * Meta information extracted from the WSDL
     * - documentation: Textual information regarding the room.
     * - minOccurs: 0
     * @var mixed
     */
    public $RoomDescription;
    /**
     * The AdditionalDetails
     * Meta information extracted from the WSDL
     * - documentation: A collection of additional details.
     * - minOccurs: 0
     * @var mixed
     */
    public $AdditionalDetails;
    /**
     * The Amenities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Amenities
     */
    public $Amenities;
    /**
     * The Occupancy
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Occupancy[]
     */
    public $Occupancy;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - documentation: The number of rooms that have been combined to create this room type.
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The IsRoom
     * Meta information extracted from the WSDL
     * - documentation: Indicates the room is a sleeping room when true.
     * - use: optional
     * @var bool
     */
    public $IsRoom;
    /**
     * The IsConverted
     * Meta information extracted from the WSDL
     * - documentation: Indicates the room is converted when true.
     * - use: optional
     * @var bool
     */
    public $IsConverted;
    /**
     * The IsAlternate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the room is an alternate room type to the requested room type when true.
     * - use: optional
     * @var bool
     */
    public $IsAlternate;
    /**
     * The ReqdGuaranteeType
     * Meta information extracted from the WSDL
     * - documentation: Denotes the form of guarantee for this room.
     * - use: optional
     * @var string
     */
    public $ReqdGuaranteeType;
    /**
     * Constructor method for RoomTypeType
     * @uses RoomTypeType::setRoomDescription()
     * @uses RoomTypeType::setAdditionalDetails()
     * @uses RoomTypeType::setAmenities()
     * @uses RoomTypeType::setOccupancy()
     * @uses RoomTypeType::setTPA_Extensions()
     * @uses RoomTypeType::setNumberOfUnits()
     * @uses RoomTypeType::setIsRoom()
     * @uses RoomTypeType::setIsConverted()
     * @uses RoomTypeType::setIsAlternate()
     * @uses RoomTypeType::setReqdGuaranteeType()
     * @param mixed $roomDescription
     * @param mixed $additionalDetails
     * @param \StructType\Amenities $amenities
     * @param \StructType\Occupancy[] $occupancy
     * @param mixed $tPA_Extensions
     * @param int $numberOfUnits
     * @param bool $isRoom
     * @param bool $isConverted
     * @param bool $isAlternate
     * @param string $reqdGuaranteeType
     */
    public function __construct($roomDescription = null, $additionalDetails = null, \StructType\Amenities $amenities = null, array $occupancy = array(), $tPA_Extensions = null, $numberOfUnits = null, $isRoom = null, $isConverted = null, $isAlternate = null, $reqdGuaranteeType = null)
    {
        $this
            ->setRoomDescription($roomDescription)
            ->setAdditionalDetails($additionalDetails)
            ->setAmenities($amenities)
            ->setOccupancy($occupancy)
            ->setTPA_Extensions($tPA_Extensions)
            ->setNumberOfUnits($numberOfUnits)
            ->setIsRoom($isRoom)
            ->setIsConverted($isConverted)
            ->setIsAlternate($isAlternate)
            ->setReqdGuaranteeType($reqdGuaranteeType);
    }
    /**
     * Get RoomDescription value
     * @return mixed|null
     */
    public function getRoomDescription()
    {
        return $this->RoomDescription;
    }
    /**
     * Set RoomDescription value
     * @param mixed $roomDescription
     * @return \StructType\RoomTypeType
     */
    public function setRoomDescription($roomDescription = null)
    {
        $this->RoomDescription = $roomDescription;
        return $this;
    }
    /**
     * Get AdditionalDetails value
     * @return mixed|null
     */
    public function getAdditionalDetails()
    {
        return $this->AdditionalDetails;
    }
    /**
     * Set AdditionalDetails value
     * @param mixed $additionalDetails
     * @return \StructType\RoomTypeType
     */
    public function setAdditionalDetails($additionalDetails = null)
    {
        $this->AdditionalDetails = $additionalDetails;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \StructType\Amenities|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \StructType\Amenities $amenities
     * @return \StructType\RoomTypeType
     */
    public function setAmenities(\StructType\Amenities $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return \StructType\Occupancy[]|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * This method is responsible for validating the values passed to the setOccupancy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOccupancy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOccupancyForArrayConstraintsFromSetOccupancy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomTypeTypeOccupancyItem) {
            // validation for constraint: itemType
            if (!$roomTypeTypeOccupancyItem instanceof \StructType\Occupancy) {
                $invalidValues[] = is_object($roomTypeTypeOccupancyItem) ? get_class($roomTypeTypeOccupancyItem) : sprintf('%s(%s)', gettype($roomTypeTypeOccupancyItem), var_export($roomTypeTypeOccupancyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy[] $occupancy
     * @return \StructType\RoomTypeType
     */
    public function setOccupancy(array $occupancy = array())
    {
        // validation for constraint: array
        if ('' !== ($occupancyArrayErrorMessage = self::validateOccupancyForArrayConstraintsFromSetOccupancy($occupancy))) {
            throw new \InvalidArgumentException($occupancyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($occupancy) && count($occupancy) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($occupancy)), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Add item to Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy $item
     * @return \StructType\RoomTypeType
     */
    public function addToOccupancy(\StructType\Occupancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Occupancy) {
            throw new \InvalidArgumentException(sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Occupancy) && count($this->Occupancy) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Occupancy)), __LINE__);
        }
        $this->Occupancy[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RoomTypeType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomTypeType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get IsRoom value
     * @return bool|null
     */
    public function getIsRoom()
    {
        return $this->IsRoom;
    }
    /**
     * Set IsRoom value
     * @param bool $isRoom
     * @return \StructType\RoomTypeType
     */
    public function setIsRoom($isRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoom) && !is_bool($isRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoom, true), gettype($isRoom)), __LINE__);
        }
        $this->IsRoom = $isRoom;
        return $this;
    }
    /**
     * Get IsConverted value
     * @return bool|null
     */
    public function getIsConverted()
    {
        return $this->IsConverted;
    }
    /**
     * Set IsConverted value
     * @param bool $isConverted
     * @return \StructType\RoomTypeType
     */
    public function setIsConverted($isConverted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConverted) && !is_bool($isConverted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConverted, true), gettype($isConverted)), __LINE__);
        }
        $this->IsConverted = $isConverted;
        return $this;
    }
    /**
     * Get IsAlternate value
     * @return bool|null
     */
    public function getIsAlternate()
    {
        return $this->IsAlternate;
    }
    /**
     * Set IsAlternate value
     * @param bool $isAlternate
     * @return \StructType\RoomTypeType
     */
    public function setIsAlternate($isAlternate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternate) && !is_bool($isAlternate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlternate, true), gettype($isAlternate)), __LINE__);
        }
        $this->IsAlternate = $isAlternate;
        return $this;
    }
    /**
     * Get ReqdGuaranteeType value
     * @return string|null
     */
    public function getReqdGuaranteeType()
    {
        return $this->ReqdGuaranteeType;
    }
    /**
     * Set ReqdGuaranteeType value
     * @param string $reqdGuaranteeType
     * @return \StructType\RoomTypeType
     */
    public function setReqdGuaranteeType($reqdGuaranteeType = null)
    {
        // validation for constraint: string
        if (!is_null($reqdGuaranteeType) && !is_string($reqdGuaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reqdGuaranteeType, true), gettype($reqdGuaranteeType)), __LINE__);
        }
        $this->ReqdGuaranteeType = $reqdGuaranteeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomTypeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
