<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeAllocation StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the date range to which rooms are allocated for availability by room type. | This is the number of rooms blocked for a specific room type for specific dates.
 * @subpackage Structs
 */
class RoomTypeAllocation extends AbstractStructBase
{
    /**
     * The RoomTypeAllocByGuest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomTypeAllocByGuest[]
     */
    public $RoomTypeAllocByGuest;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - documentation: The number of rooms allocated as available for the dates specified in the DateTimeSpanGroup.
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The CompRoomQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of complimentary rooms allocated as part of the inventory block. This may be a flat number of rooms or it may be used in conjunction with CompRoomFactor.
     * - use: optional
     * @var int
     */
    public $CompRoomQuantity;
    /**
     * The CompRoomFactor
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate how many rooms need to be sold before a complimentary room is granted (e.g. CompRoomQuantity="1" and CompRoomFactor="100" means 1 complimentary room is granted per 100 rooms sold).
     * - use: optional
     * @var int
     */
    public $CompRoomFactor;
    /**
     * The EndDateIndicator
     * Meta information extracted from the WSDL
     * - documentation: If true, this indicator designates that the room allocation is applied through to the End date in the RoomType DateTimeSpanGroup if it exists or to the End date in the InvBlock DateTimeSpanGroup. This would be used in place of
     * RoomTypeAllocation/Duration and RoomTypeAllocation/End.
     * - use: optional
     * @var bool
     */
    public $EndDateIndicator;
    /**
     * The SellLimit
     * Meta information extracted from the WSDL
     * - documentation: The contracted quantity or ceiling of inventory, which may differ from the NumberOfUnits allocated.
     * - use: optional
     * @var int
     */
    public $SellLimit;
    /**
     * The ProcureBlockCode
     * Meta information extracted from the WSDL
     * - documentation: The block from which to take inventory when NumberOfUnits is depleted. This is used in conjunction with the SellLimit attribute. If this attribute is not present, inventory is taken from general inventory.
     * - use: optional
     * @var string
     */
    public $ProcureBlockCode;
    /**
     * The AllocationID
     * Meta information extracted from the WSDL
     * - documentation: Used to refer to a specific allocation already in the receiving system.
     * - use: optional
     * @var string
     */
    public $AllocationID;
    /**
     * The AllowGeneralInvInd
     * Meta information extracted from the WSDL
     * - documentation: Example: true | If true, the general inventory can also be used in addition to the NumberOfUnits indicated. If false, the group cannot sell more than the NumberOfUnits.
     * @var bool
     */
    public $AllowGeneralInvInd;
    /**
     * Constructor method for RoomTypeAllocation
     * @uses RoomTypeAllocation::setRoomTypeAllocByGuest()
     * @uses RoomTypeAllocation::setNumberOfUnits()
     * @uses RoomTypeAllocation::setCompRoomQuantity()
     * @uses RoomTypeAllocation::setCompRoomFactor()
     * @uses RoomTypeAllocation::setEndDateIndicator()
     * @uses RoomTypeAllocation::setSellLimit()
     * @uses RoomTypeAllocation::setProcureBlockCode()
     * @uses RoomTypeAllocation::setAllocationID()
     * @uses RoomTypeAllocation::setAllowGeneralInvInd()
     * @param \StructType\RoomTypeAllocByGuest[] $roomTypeAllocByGuest
     * @param int $numberOfUnits
     * @param int $compRoomQuantity
     * @param int $compRoomFactor
     * @param bool $endDateIndicator
     * @param int $sellLimit
     * @param string $procureBlockCode
     * @param string $allocationID
     * @param bool $allowGeneralInvInd
     */
    public function __construct(array $roomTypeAllocByGuest = array(), $numberOfUnits = null, $compRoomQuantity = null, $compRoomFactor = null, $endDateIndicator = null, $sellLimit = null, $procureBlockCode = null, $allocationID = null, $allowGeneralInvInd = null)
    {
        $this
            ->setRoomTypeAllocByGuest($roomTypeAllocByGuest)
            ->setNumberOfUnits($numberOfUnits)
            ->setCompRoomQuantity($compRoomQuantity)
            ->setCompRoomFactor($compRoomFactor)
            ->setEndDateIndicator($endDateIndicator)
            ->setSellLimit($sellLimit)
            ->setProcureBlockCode($procureBlockCode)
            ->setAllocationID($allocationID)
            ->setAllowGeneralInvInd($allowGeneralInvInd);
    }
    /**
     * Get RoomTypeAllocByGuest value
     * @return \StructType\RoomTypeAllocByGuest[]|null
     */
    public function getRoomTypeAllocByGuest()
    {
        return $this->RoomTypeAllocByGuest;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomTypeAllocByGuest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomTypeAllocByGuest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomTypeAllocByGuestForArrayConstraintsFromSetRoomTypeAllocByGuest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomTypeAllocationRoomTypeAllocByGuestItem) {
            // validation for constraint: itemType
            if (!$roomTypeAllocationRoomTypeAllocByGuestItem instanceof \StructType\RoomTypeAllocByGuest) {
                $invalidValues[] = is_object($roomTypeAllocationRoomTypeAllocByGuestItem) ? get_class($roomTypeAllocationRoomTypeAllocByGuestItem) : sprintf('%s(%s)', gettype($roomTypeAllocationRoomTypeAllocByGuestItem), var_export($roomTypeAllocationRoomTypeAllocByGuestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomTypeAllocByGuest property can only contain items of type \StructType\RoomTypeAllocByGuest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomTypeAllocByGuest value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeAllocByGuest[] $roomTypeAllocByGuest
     * @return \StructType\RoomTypeAllocation
     */
    public function setRoomTypeAllocByGuest(array $roomTypeAllocByGuest = array())
    {
        // validation for constraint: array
        if ('' !== ($roomTypeAllocByGuestArrayErrorMessage = self::validateRoomTypeAllocByGuestForArrayConstraintsFromSetRoomTypeAllocByGuest($roomTypeAllocByGuest))) {
            throw new \InvalidArgumentException($roomTypeAllocByGuestArrayErrorMessage, __LINE__);
        }
        $this->RoomTypeAllocByGuest = $roomTypeAllocByGuest;
        return $this;
    }
    /**
     * Add item to RoomTypeAllocByGuest value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomTypeAllocByGuest $item
     * @return \StructType\RoomTypeAllocation
     */
    public function addToRoomTypeAllocByGuest(\StructType\RoomTypeAllocByGuest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomTypeAllocByGuest) {
            throw new \InvalidArgumentException(sprintf('The RoomTypeAllocByGuest property can only contain items of type \StructType\RoomTypeAllocByGuest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomTypeAllocByGuest[] = $item;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomTypeAllocation
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get CompRoomQuantity value
     * @return int|null
     */
    public function getCompRoomQuantity()
    {
        return $this->CompRoomQuantity;
    }
    /**
     * Set CompRoomQuantity value
     * @param int $compRoomQuantity
     * @return \StructType\RoomTypeAllocation
     */
    public function setCompRoomQuantity($compRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($compRoomQuantity) && !(is_int($compRoomQuantity) || ctype_digit($compRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compRoomQuantity, true), gettype($compRoomQuantity)), __LINE__);
        }
        $this->CompRoomQuantity = $compRoomQuantity;
        return $this;
    }
    /**
     * Get CompRoomFactor value
     * @return int|null
     */
    public function getCompRoomFactor()
    {
        return $this->CompRoomFactor;
    }
    /**
     * Set CompRoomFactor value
     * @param int $compRoomFactor
     * @return \StructType\RoomTypeAllocation
     */
    public function setCompRoomFactor($compRoomFactor = null)
    {
        // validation for constraint: int
        if (!is_null($compRoomFactor) && !(is_int($compRoomFactor) || ctype_digit($compRoomFactor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compRoomFactor, true), gettype($compRoomFactor)), __LINE__);
        }
        $this->CompRoomFactor = $compRoomFactor;
        return $this;
    }
    /**
     * Get EndDateIndicator value
     * @return bool|null
     */
    public function getEndDateIndicator()
    {
        return $this->EndDateIndicator;
    }
    /**
     * Set EndDateIndicator value
     * @param bool $endDateIndicator
     * @return \StructType\RoomTypeAllocation
     */
    public function setEndDateIndicator($endDateIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($endDateIndicator) && !is_bool($endDateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($endDateIndicator, true), gettype($endDateIndicator)), __LINE__);
        }
        $this->EndDateIndicator = $endDateIndicator;
        return $this;
    }
    /**
     * Get SellLimit value
     * @return int|null
     */
    public function getSellLimit()
    {
        return $this->SellLimit;
    }
    /**
     * Set SellLimit value
     * @param int $sellLimit
     * @return \StructType\RoomTypeAllocation
     */
    public function setSellLimit($sellLimit = null)
    {
        // validation for constraint: int
        if (!is_null($sellLimit) && !(is_int($sellLimit) || ctype_digit($sellLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sellLimit, true), gettype($sellLimit)), __LINE__);
        }
        $this->SellLimit = $sellLimit;
        return $this;
    }
    /**
     * Get ProcureBlockCode value
     * @return string|null
     */
    public function getProcureBlockCode()
    {
        return $this->ProcureBlockCode;
    }
    /**
     * Set ProcureBlockCode value
     * @param string $procureBlockCode
     * @return \StructType\RoomTypeAllocation
     */
    public function setProcureBlockCode($procureBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($procureBlockCode) && !is_string($procureBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procureBlockCode, true), gettype($procureBlockCode)), __LINE__);
        }
        $this->ProcureBlockCode = $procureBlockCode;
        return $this;
    }
    /**
     * Get AllocationID value
     * @return string|null
     */
    public function getAllocationID()
    {
        return $this->AllocationID;
    }
    /**
     * Set AllocationID value
     * @param string $allocationID
     * @return \StructType\RoomTypeAllocation
     */
    public function setAllocationID($allocationID = null)
    {
        // validation for constraint: string
        if (!is_null($allocationID) && !is_string($allocationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationID, true), gettype($allocationID)), __LINE__);
        }
        $this->AllocationID = $allocationID;
        return $this;
    }
    /**
     * Get AllowGeneralInvInd value
     * @return bool|null
     */
    public function getAllowGeneralInvInd()
    {
        return $this->AllowGeneralInvInd;
    }
    /**
     * Set AllowGeneralInvInd value
     * @param bool $allowGeneralInvInd
     * @return \StructType\RoomTypeAllocation
     */
    public function setAllowGeneralInvInd($allowGeneralInvInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowGeneralInvInd) && !is_bool($allowGeneralInvInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowGeneralInvInd, true), gettype($allowGeneralInvInd)), __LINE__);
        }
        $this->AllowGeneralInvInd = $allowGeneralInvInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomTypeAllocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
