<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayLiteType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary version of the RoomStayType, initially created for the Travel Itinerary Message set.
 * @subpackage Structs
 */
class RoomStayLiteType extends AbstractStructBase
{
    /**
     * The RoomTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomTypes
     */
    public $RoomTypes;
    /**
     * The RatePlans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlans
     */
    public $RatePlans;
    /**
     * The RoomRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomRates
     */
    public $RoomRates;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - documentation: Number of guests associated with this reservation.
     * - minOccurs: 0
     * @var mixed
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta information extracted from the WSDL
     * - documentation: Date and time of check-in and check-out.
     * - minOccurs: 0
     * @var mixed
     */
    public $TimeSpan;
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - documentation: The guarantee information associated to the Room Stay. A maximum of 5 occurances are available for use depending on the context.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Guarantee;
    /**
     * The DepositPayment
     * Meta information extracted from the WSDL
     * - documentation: A collection of deposit and/or payments for the Room Stay. A maximum of 5 occurances are available for use depending on the context.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $DepositPayment;
    /**
     * The BasicPropertyInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BasicPropertyInfo
     */
    public $BasicPropertyInfo;
    /**
     * Constructor method for RoomStayLiteType
     * @uses RoomStayLiteType::setRoomTypes()
     * @uses RoomStayLiteType::setRatePlans()
     * @uses RoomStayLiteType::setRoomRates()
     * @uses RoomStayLiteType::setGuestCounts()
     * @uses RoomStayLiteType::setTimeSpan()
     * @uses RoomStayLiteType::setGuarantee()
     * @uses RoomStayLiteType::setDepositPayment()
     * @uses RoomStayLiteType::setBasicPropertyInfo()
     * @param \StructType\RoomTypes $roomTypes
     * @param \StructType\RatePlans $ratePlans
     * @param \StructType\RoomRates $roomRates
     * @param mixed $guestCounts
     * @param mixed $timeSpan
     * @param mixed[] $guarantee
     * @param mixed[] $depositPayment
     * @param \StructType\BasicPropertyInfo $basicPropertyInfo
     */
    public function __construct(\StructType\RoomTypes $roomTypes = null, \StructType\RatePlans $ratePlans = null, \StructType\RoomRates $roomRates = null, $guestCounts = null, $timeSpan = null, array $guarantee = array(), array $depositPayment = array(), \StructType\BasicPropertyInfo $basicPropertyInfo = null)
    {
        $this
            ->setRoomTypes($roomTypes)
            ->setRatePlans($ratePlans)
            ->setRoomRates($roomRates)
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setGuarantee($guarantee)
            ->setDepositPayment($depositPayment)
            ->setBasicPropertyInfo($basicPropertyInfo);
    }
    /**
     * Get RoomTypes value
     * @return \StructType\RoomTypes|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \StructType\RoomTypes $roomTypes
     * @return \StructType\RoomStayLiteType
     */
    public function setRoomTypes(\StructType\RoomTypes $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \StructType\RatePlans|null
     */
    public function getRatePlans()
    {
        return $this->RatePlans;
    }
    /**
     * Set RatePlans value
     * @param \StructType\RatePlans $ratePlans
     * @return \StructType\RoomStayLiteType
     */
    public function setRatePlans(\StructType\RatePlans $ratePlans = null)
    {
        $this->RatePlans = $ratePlans;
        return $this;
    }
    /**
     * Get RoomRates value
     * @return \StructType\RoomRates|null
     */
    public function getRoomRates()
    {
        return $this->RoomRates;
    }
    /**
     * Set RoomRates value
     * @param \StructType\RoomRates $roomRates
     * @return \StructType\RoomStayLiteType
     */
    public function setRoomRates(\StructType\RoomRates $roomRates = null)
    {
        $this->RoomRates = $roomRates;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return mixed|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param mixed $guestCounts
     * @return \StructType\RoomStayLiteType
     */
    public function setGuestCounts($guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return mixed|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param mixed $timeSpan
     * @return \StructType\RoomStayLiteType
     */
    public function setTimeSpan($timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return mixed[]|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * This method is responsible for validating the values passed to the setGuarantee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuarantee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteeForArrayConstraintsFromSetGuarantee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayLiteTypeGuaranteeItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($roomStayLiteTypeGuaranteeItem) ? get_class($roomStayLiteTypeGuaranteeItem) : sprintf('%s(%s)', gettype($roomStayLiteTypeGuaranteeItem), var_export($roomStayLiteTypeGuaranteeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guarantee property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guarantee value
     * @throws \InvalidArgumentException
     * @param mixed[] $guarantee
     * @return \StructType\RoomStayLiteType
     */
    public function setGuarantee(array $guarantee = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteeArrayErrorMessage = self::validateGuaranteeForArrayConstraintsFromSetGuarantee($guarantee))) {
            throw new \InvalidArgumentException($guaranteeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($guarantee) && count($guarantee) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($guarantee)), __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Add item to Guarantee value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RoomStayLiteType
     */
    public function addToGuarantee($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Guarantee property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Guarantee) && count($this->Guarantee) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Guarantee)), __LINE__);
        }
        $this->Guarantee[] = $item;
        return $this;
    }
    /**
     * Get DepositPayment value
     * @return mixed[]|null
     */
    public function getDepositPayment()
    {
        return $this->DepositPayment;
    }
    /**
     * This method is responsible for validating the values passed to the setDepositPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepositPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositPaymentForArrayConstraintsFromSetDepositPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayLiteTypeDepositPaymentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($roomStayLiteTypeDepositPaymentItem) ? get_class($roomStayLiteTypeDepositPaymentItem) : sprintf('%s(%s)', gettype($roomStayLiteTypeDepositPaymentItem), var_export($roomStayLiteTypeDepositPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DepositPayment property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DepositPayment value
     * @throws \InvalidArgumentException
     * @param mixed[] $depositPayment
     * @return \StructType\RoomStayLiteType
     */
    public function setDepositPayment(array $depositPayment = array())
    {
        // validation for constraint: array
        if ('' !== ($depositPaymentArrayErrorMessage = self::validateDepositPaymentForArrayConstraintsFromSetDepositPayment($depositPayment))) {
            throw new \InvalidArgumentException($depositPaymentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($depositPayment) && count($depositPayment) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($depositPayment)), __LINE__);
        }
        $this->DepositPayment = $depositPayment;
        return $this;
    }
    /**
     * Add item to DepositPayment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RoomStayLiteType
     */
    public function addToDepositPayment($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The DepositPayment property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->DepositPayment) && count($this->DepositPayment) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->DepositPayment)), __LINE__);
        }
        $this->DepositPayment[] = $item;
        return $this;
    }
    /**
     * Get BasicPropertyInfo value
     * @return \StructType\BasicPropertyInfo|null
     */
    public function getBasicPropertyInfo()
    {
        return $this->BasicPropertyInfo;
    }
    /**
     * Set BasicPropertyInfo value
     * @param \StructType\BasicPropertyInfo $basicPropertyInfo
     * @return \StructType\RoomStayLiteType
     */
    public function setBasicPropertyInfo(\StructType\BasicPropertyInfo $basicPropertyInfo = null)
    {
        $this->BasicPropertyInfo = $basicPropertyInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStayLiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
