<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayCandidateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the dates when the RoomStayCandidate is applicable when there are multiple room stay requirements within a StayDateRange. | Used to identify available room products.
 * @subpackage Structs
 */
class RoomStayCandidateType extends AbstractStructBase
{
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $GuestCounts;
    /**
     * The RoomAmenity
     * Meta information extracted from the WSDL
     * - documentation: This element is used to pass room attributes. Typical attributes are smoking, non-smoking, wheelchair access, room location (low floor, high floor, close to elevator, etc) and view (garden, pool, ocean, etc.)
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RoomAmenity;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for this room stay candidate.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The RatePlanCandidateRPH
     * Meta information extracted from the WSDL
     * - documentation: Used to refer to the Rate Plan Candidate associated with this room stay.
     * - use: optional
     * @var string
     */
    public $RatePlanCandidateRPH;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the booking code for which availability is requested.
     * - use: optional
     * @var string
     */
    public $BookingCode;
    /**
     * Constructor method for RoomStayCandidateType
     * @uses RoomStayCandidateType::setGuestCounts()
     * @uses RoomStayCandidateType::setRoomAmenity()
     * @uses RoomStayCandidateType::setRPH()
     * @uses RoomStayCandidateType::setRatePlanCandidateRPH()
     * @uses RoomStayCandidateType::setBookingCode()
     * @param mixed $guestCounts
     * @param mixed[] $roomAmenity
     * @param string $rPH
     * @param string $ratePlanCandidateRPH
     * @param string $bookingCode
     */
    public function __construct($guestCounts = null, array $roomAmenity = array(), $rPH = null, $ratePlanCandidateRPH = null, $bookingCode = null)
    {
        $this
            ->setGuestCounts($guestCounts)
            ->setRoomAmenity($roomAmenity)
            ->setRPH($rPH)
            ->setRatePlanCandidateRPH($ratePlanCandidateRPH)
            ->setBookingCode($bookingCode);
    }
    /**
     * Get GuestCounts value
     * @return mixed|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param mixed $guestCounts
     * @return \StructType\RoomStayCandidateType
     */
    public function setGuestCounts($guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get RoomAmenity value
     * @return mixed[]|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomAmenityForArrayConstraintsFromSetRoomAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayCandidateTypeRoomAmenityItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($roomStayCandidateTypeRoomAmenityItem) ? get_class($roomStayCandidateTypeRoomAmenityItem) : sprintf('%s(%s)', gettype($roomStayCandidateTypeRoomAmenityItem), var_export($roomStayCandidateTypeRoomAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomAmenity property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomAmenity value
     * @throws \InvalidArgumentException
     * @param mixed[] $roomAmenity
     * @return \StructType\RoomStayCandidateType
     */
    public function setRoomAmenity(array $roomAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($roomAmenityArrayErrorMessage = self::validateRoomAmenityForArrayConstraintsFromSetRoomAmenity($roomAmenity))) {
            throw new \InvalidArgumentException($roomAmenityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($roomAmenity) && count($roomAmenity) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($roomAmenity)), __LINE__);
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Add item to RoomAmenity value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RoomStayCandidateType
     */
    public function addToRoomAmenity($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RoomAmenity property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RoomAmenity) && count($this->RoomAmenity) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RoomAmenity)), __LINE__);
        }
        $this->RoomAmenity[] = $item;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\RoomStayCandidateType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get RatePlanCandidateRPH value
     * @return string|null
     */
    public function getRatePlanCandidateRPH()
    {
        return $this->RatePlanCandidateRPH;
    }
    /**
     * Set RatePlanCandidateRPH value
     * @param string $ratePlanCandidateRPH
     * @return \StructType\RoomStayCandidateType
     */
    public function setRatePlanCandidateRPH($ratePlanCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCandidateRPH) && !is_string($ratePlanCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCandidateRPH, true), gettype($ratePlanCandidateRPH)), __LINE__);
        }
        $this->RatePlanCandidateRPH = $ratePlanCandidateRPH;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \StructType\RoomStayCandidateType
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCode, true), gettype($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStayCandidateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
