<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStay StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Hotel Service reference placeholders. | A collection of reference place holders. This is a reference placeholder, used as an index for the reservation guests. | Details on the Room Stay including Guest Counts, Time
 * Span of this Room Stay, pointers to Res Guests, guest Memberships, Comments and Special Requests pertaining to this particular Room Stay and finally finacial information related to the Room Stay, including Guarantee, Deposit and Payment and
 * Cancellation Penalties. | Details the success, failure and warnings for the RoomStay.
 * @subpackage Structs
 */
class RoomStay extends RoomStayType
{
    /**
     * The ResGuestRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $ResGuestRPHs;
    /**
     * The Memberships
     * Meta information extracted from the WSDL
     * - documentation: A collection of Membership objects. Memberships provides a list of reward programs which may be credited with points accrued from the guest's activity.
     * - minOccurs: 0
     * @var mixed
     */
    public $Memberships;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: A collection of Comment objects. Comments which apply to the whole Reservation or a particular Room Stay or Service.
     * - minOccurs: 0
     * @var mixed
     */
    public $Comments;
    /**
     * The SpecialRequests
     * Meta information extracted from the WSDL
     * - documentation: The SpecialRequest object indicates special requests for the whole Reservation, or a particular Room Stay or Service.
     * - minOccurs: 0
     * @var mixed
     */
    public $SpecialRequests;
    /**
     * The ServiceRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $ServiceRPHs;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $Reference;
    /**
     * The BookingRules
     * Meta information extracted from the WSDL
     * - documentation: Provides booking rule information for the room stay.
     * - minOccurs: 0
     * @var mixed
     */
    public $BookingRules;
    /**
     * The IndexNumber
     * Meta information extracted from the WSDL
     * - documentation: A unique number (e.g. segment number or index number) used to further identify a booked item within a list of booked items.
     * - use: optional
     * @var int
     */
    public $IndexNumber;
    /**
     * The HotelReservationIDs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $HotelReservationIDs;
    /**
     * The RoomShares
     * Meta information extracted from the WSDL
     * - documentation: Collection of shared rooms for room stay.
     * - minOccurs: 0
     * @var mixed
     */
    public $RoomShares;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: Provides a mechanism for uniquely identifying a room stay (e.g. this would be useful for a modification).
     * - minOccurs: 0
     * @var mixed
     */
    public $UniqueID;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var mixed
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var mixed
     */
    public $Warnings;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var mixed
     */
    public $Errors;
    /**
     * The RoomStay
     * Meta information extracted from the WSDL
     * - documentation: This attribute indicates the change to the reservation.
     * - use: optional
     * @var string
     */
    public $RoomStay;
    /**
     * Constructor method for RoomStay
     * @uses RoomStay::setResGuestRPHs()
     * @uses RoomStay::setMemberships()
     * @uses RoomStay::setComments()
     * @uses RoomStay::setSpecialRequests()
     * @uses RoomStay::setServiceRPHs()
     * @uses RoomStay::setReference()
     * @uses RoomStay::setBookingRules()
     * @uses RoomStay::setIndexNumber()
     * @uses RoomStay::setHotelReservationIDs()
     * @uses RoomStay::setRoomShares()
     * @uses RoomStay::setUniqueID()
     * @uses RoomStay::setSuccess()
     * @uses RoomStay::setWarnings()
     * @uses RoomStay::setErrors()
     * @uses RoomStay::setRoomStay()
     * @param mixed $resGuestRPHs
     * @param mixed $memberships
     * @param mixed $comments
     * @param mixed $specialRequests
     * @param mixed $serviceRPHs
     * @param \StructType\Reference $reference
     * @param mixed $bookingRules
     * @param int $indexNumber
     * @param mixed $hotelReservationIDs
     * @param mixed $roomShares
     * @param mixed $uniqueID
     * @param mixed $success
     * @param mixed $warnings
     * @param mixed $errors
     * @param string $roomStay
     */
    public function __construct($resGuestRPHs = null, $memberships = null, $comments = null, $specialRequests = null, $serviceRPHs = null, \StructType\Reference $reference = null, $bookingRules = null, $indexNumber = null, $hotelReservationIDs = null, $roomShares = null, $uniqueID = null, $success = null, $warnings = null, $errors = null, $roomStay = null)
    {
        $this
            ->setResGuestRPHs($resGuestRPHs)
            ->setMemberships($memberships)
            ->setComments($comments)
            ->setSpecialRequests($specialRequests)
            ->setServiceRPHs($serviceRPHs)
            ->setReference($reference)
            ->setBookingRules($bookingRules)
            ->setIndexNumber($indexNumber)
            ->setHotelReservationIDs($hotelReservationIDs)
            ->setRoomShares($roomShares)
            ->setUniqueID($uniqueID)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setErrors($errors)
            ->setRoomStay($roomStay);
    }
    /**
     * Get ResGuestRPHs value
     * @return mixed|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param mixed $resGuestRPHs
     * @return \StructType\RoomStay
     */
    public function setResGuestRPHs($resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Memberships value
     * @return mixed|null
     */
    public function getMemberships()
    {
        return $this->Memberships;
    }
    /**
     * Set Memberships value
     * @param mixed $memberships
     * @return \StructType\RoomStay
     */
    public function setMemberships($memberships = null)
    {
        $this->Memberships = $memberships;
        return $this;
    }
    /**
     * Get Comments value
     * @return mixed|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param mixed $comments
     * @return \StructType\RoomStay
     */
    public function setComments($comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return mixed|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param mixed $specialRequests
     * @return \StructType\RoomStay
     */
    public function setSpecialRequests($specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return mixed|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param mixed $serviceRPHs
     * @return \StructType\RoomStay
     */
    public function setServiceRPHs($serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\Reference $reference
     * @return \StructType\RoomStay
     */
    public function setReference(\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get BookingRules value
     * @return mixed|null
     */
    public function getBookingRules()
    {
        return $this->BookingRules;
    }
    /**
     * Set BookingRules value
     * @param mixed $bookingRules
     * @return \StructType\RoomStay
     */
    public function setBookingRules($bookingRules = null)
    {
        $this->BookingRules = $bookingRules;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \StructType\RoomStay
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !(is_int($indexNumber) || ctype_digit($indexNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexNumber, true), gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get HotelReservationIDs value
     * @return mixed|null
     */
    public function getHotelReservationIDs()
    {
        return $this->HotelReservationIDs;
    }
    /**
     * Set HotelReservationIDs value
     * @param mixed $hotelReservationIDs
     * @return \StructType\RoomStay
     */
    public function setHotelReservationIDs($hotelReservationIDs = null)
    {
        $this->HotelReservationIDs = $hotelReservationIDs;
        return $this;
    }
    /**
     * Get RoomShares value
     * @return mixed|null
     */
    public function getRoomShares()
    {
        return $this->RoomShares;
    }
    /**
     * Set RoomShares value
     * @param mixed $roomShares
     * @return \StructType\RoomStay
     */
    public function setRoomShares($roomShares = null)
    {
        $this->RoomShares = $roomShares;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return mixed|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param mixed $uniqueID
     * @return \StructType\RoomStay
     */
    public function setUniqueID($uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Success value
     * @return mixed|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $success
     * @return \StructType\RoomStay
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return mixed|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $warnings
     * @return \StructType\RoomStay
     */
    public function setWarnings($warnings = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return mixed|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $errors
     * @return \StructType\RoomStay
     */
    public function setErrors($errors = null)
    {
        // validation for constraint: choice(Success, Warnings, Errors)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get RoomStay value
     * @return string|null
     */
    public function getRoomStay()
    {
        return $this->RoomStay;
    }
    /**
     * Set RoomStay value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roomStay
     * @return \StructType\RoomStay
     */
    public function setRoomStay($roomStay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($roomStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($roomStay) ? implode(', ', $roomStay) : var_export($roomStay, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->RoomStay = $roomStay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
