<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomPriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Gives a total price and prices by traveler type for a room occupancy combination e.g. 2 adults and 2 children
 * @subpackage Structs
 */
class RoomPriceType extends AbstractStructBase
{
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - documentation: A collection of GuestCount by age group.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $GuestCounts;
    /**
     * The ItemPrice
     * Meta information extracted from the WSDL
     * - documentation: Price for a traveler type in the room.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ItemPrice;
    /**
     * The ProfilePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfilePrice
     */
    public $ProfilePrice;
    /**
     * The RoomRPH
     * Meta information extracted from the WSDL
     * - documentation: Used to associate a room price with a specific room.
     * - use: optional
     * @var string
     */
    public $RoomRPH;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: A code to identify a room.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for RoomPriceType
     * @uses RoomPriceType::setGuestCounts()
     * @uses RoomPriceType::setItemPrice()
     * @uses RoomPriceType::setProfilePrice()
     * @uses RoomPriceType::setRoomRPH()
     * @uses RoomPriceType::setCode()
     * @param mixed[] $guestCounts
     * @param mixed[] $itemPrice
     * @param \StructType\ProfilePrice $profilePrice
     * @param string $roomRPH
     * @param string $code
     */
    public function __construct(array $guestCounts = array(), array $itemPrice = array(), \StructType\ProfilePrice $profilePrice = null, $roomRPH = null, $code = null)
    {
        $this
            ->setGuestCounts($guestCounts)
            ->setItemPrice($itemPrice)
            ->setProfilePrice($profilePrice)
            ->setRoomRPH($roomRPH)
            ->setCode($code);
    }
    /**
     * Get GuestCounts value
     * @return mixed[]|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestCounts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestCounts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestCountsForArrayConstraintsFromSetGuestCounts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomPriceTypeGuestCountsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($roomPriceTypeGuestCountsItem) ? get_class($roomPriceTypeGuestCountsItem) : sprintf('%s(%s)', gettype($roomPriceTypeGuestCountsItem), var_export($roomPriceTypeGuestCountsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestCounts property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestCounts value
     * @throws \InvalidArgumentException
     * @param mixed[] $guestCounts
     * @return \StructType\RoomPriceType
     */
    public function setGuestCounts(array $guestCounts = array())
    {
        // validation for constraint: array
        if ('' !== ($guestCountsArrayErrorMessage = self::validateGuestCountsForArrayConstraintsFromSetGuestCounts($guestCounts))) {
            throw new \InvalidArgumentException($guestCountsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($guestCounts) && count($guestCounts) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($guestCounts)), __LINE__);
        }
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Add item to GuestCounts value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RoomPriceType
     */
    public function addToGuestCounts($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The GuestCounts property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->GuestCounts) && count($this->GuestCounts) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->GuestCounts)), __LINE__);
        }
        $this->GuestCounts[] = $item;
        return $this;
    }
    /**
     * Get ItemPrice value
     * @return mixed[]|null
     */
    public function getItemPrice()
    {
        return $this->ItemPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setItemPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemPriceForArrayConstraintsFromSetItemPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomPriceTypeItemPriceItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($roomPriceTypeItemPriceItem) ? get_class($roomPriceTypeItemPriceItem) : sprintf('%s(%s)', gettype($roomPriceTypeItemPriceItem), var_export($roomPriceTypeItemPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemPrice property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemPrice value
     * @throws \InvalidArgumentException
     * @param mixed[] $itemPrice
     * @return \StructType\RoomPriceType
     */
    public function setItemPrice(array $itemPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($itemPriceArrayErrorMessage = self::validateItemPriceForArrayConstraintsFromSetItemPrice($itemPrice))) {
            throw new \InvalidArgumentException($itemPriceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($itemPrice) && count($itemPrice) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($itemPrice)), __LINE__);
        }
        $this->ItemPrice = $itemPrice;
        return $this;
    }
    /**
     * Add item to ItemPrice value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RoomPriceType
     */
    public function addToItemPrice($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ItemPrice property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ItemPrice) && count($this->ItemPrice) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ItemPrice)), __LINE__);
        }
        $this->ItemPrice[] = $item;
        return $this;
    }
    /**
     * Get ProfilePrice value
     * @return \StructType\ProfilePrice|null
     */
    public function getProfilePrice()
    {
        return $this->ProfilePrice;
    }
    /**
     * Set ProfilePrice value
     * @param \StructType\ProfilePrice $profilePrice
     * @return \StructType\RoomPriceType
     */
    public function setProfilePrice(\StructType\ProfilePrice $profilePrice = null)
    {
        $this->ProfilePrice = $profilePrice;
        return $this;
    }
    /**
     * Get RoomRPH value
     * @return string|null
     */
    public function getRoomRPH()
    {
        return $this->RoomRPH;
    }
    /**
     * Set RoomRPH value
     * @param string $roomRPH
     * @return \StructType\RoomPriceType
     */
    public function setRoomRPH($roomRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomRPH) && !is_string($roomRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomRPH, true), gettype($roomRPH)), __LINE__);
        }
        $this->RoomRPH = $roomRPH;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\RoomPriceType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomPriceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
