<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomAmenityPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the customer's level of preference for the associated hotel room amenity. | Indicates preferences for hotel room amenities. | Used for Character Strings, length 0 to 128.
 * - base: xs:string
 * - maxLength: 128
 * - minLength: 0
 * @subpackage Structs
 */
class RoomAmenityPrefType extends AbstractStructBase
{
    /**
     * The RoomAmenity
     * Meta information extracted from the WSDL
     * - documentation: Identifes the types of room amenities offered by the property. Refer to OpenTravel Code List Room Amenity Type (RMA).
     * - use: optional
     * @var string
     */
    public $RoomAmenity;
    /**
     * The ExistsCode
     * Meta information extracted from the WSDL
     * - documentation: This attribute is used to explicitly define whether an amenity or service is offered. Refer to OpenTravel Code list Option Type Code (OTC). This is used in conjunction with RoomAmenity.
     * - use: optional
     * @var string
     */
    public $ExistsCode;
    /**
     * The QualityLevel
     * Meta information extracted from the WSDL
     * - documentation: Used to designate the quality level of the RoomAmenity e.g., premium, deluxe, standard, economy.
     * - use: optional
     * @var string
     */
    public $QualityLevel;
    /**
     * The RoomGender
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RoomGender;
    /**
     * The SharedRoomInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, the room requires or has sharing available. Note: Typically used by Hosteliers.
     * - use: optional
     * @var bool
     */
    public $SharedRoomInd;
    /**
     * Constructor method for RoomAmenityPrefType
     * @uses RoomAmenityPrefType::setRoomAmenity()
     * @uses RoomAmenityPrefType::setExistsCode()
     * @uses RoomAmenityPrefType::setQualityLevel()
     * @uses RoomAmenityPrefType::setRoomGender()
     * @uses RoomAmenityPrefType::setSharedRoomInd()
     * @param string $roomAmenity
     * @param string $existsCode
     * @param string $qualityLevel
     * @param string $roomGender
     * @param bool $sharedRoomInd
     */
    public function __construct($roomAmenity = null, $existsCode = null, $qualityLevel = null, $roomGender = null, $sharedRoomInd = null)
    {
        $this
            ->setRoomAmenity($roomAmenity)
            ->setExistsCode($existsCode)
            ->setQualityLevel($qualityLevel)
            ->setRoomGender($roomGender)
            ->setSharedRoomInd($sharedRoomInd);
    }
    /**
     * Get RoomAmenity value
     * @return string|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * Set RoomAmenity value
     * @param string $roomAmenity
     * @return \StructType\RoomAmenityPrefType
     */
    public function setRoomAmenity($roomAmenity = null)
    {
        // validation for constraint: string
        if (!is_null($roomAmenity) && !is_string($roomAmenity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomAmenity, true), gettype($roomAmenity)), __LINE__);
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \StructType\RoomAmenityPrefType
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existsCode, true), gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get QualityLevel value
     * @return string|null
     */
    public function getQualityLevel()
    {
        return $this->QualityLevel;
    }
    /**
     * Set QualityLevel value
     * @param string $qualityLevel
     * @return \StructType\RoomAmenityPrefType
     */
    public function setQualityLevel($qualityLevel = null)
    {
        // validation for constraint: string
        if (!is_null($qualityLevel) && !is_string($qualityLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualityLevel, true), gettype($qualityLevel)), __LINE__);
        }
        $this->QualityLevel = $qualityLevel;
        return $this;
    }
    /**
     * Get RoomGender value
     * @return string|null
     */
    public function getRoomGender()
    {
        return $this->RoomGender;
    }
    /**
     * Set RoomGender value
     * @param string $roomGender
     * @return \StructType\RoomAmenityPrefType
     */
    public function setRoomGender($roomGender = null)
    {
        // validation for constraint: string
        if (!is_null($roomGender) && !is_string($roomGender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomGender, true), gettype($roomGender)), __LINE__);
        }
        $this->RoomGender = $roomGender;
        return $this;
    }
    /**
     * Get SharedRoomInd value
     * @return bool|null
     */
    public function getSharedRoomInd()
    {
        return $this->SharedRoomInd;
    }
    /**
     * Set SharedRoomInd value
     * @param bool $sharedRoomInd
     * @return \StructType\RoomAmenityPrefType
     */
    public function setSharedRoomInd($sharedRoomInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sharedRoomInd) && !is_bool($sharedRoomInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sharedRoomInd, true), gettype($sharedRoomInd)), __LINE__);
        }
        $this->SharedRoomInd = $sharedRoomInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomAmenityPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
