<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restrictions StructType
 * Meta information extracted from the WSDL
 * - documentation: Advanced purchase and fare penalty indicators. | A collections of restrictions.
 * @subpackage Structs
 */
class Restrictions extends AbstractStructBase
{
    /**
     * The AdvancePurchaseInd
     * Meta information extracted from the WSDL
     * - documentation: If true, include offers that allow advanced purchase with fares.
     * - use: optional
     * @var bool
     */
    public $AdvancePurchaseInd;
    /**
     * The FarePenaltyInd
     * Meta information extracted from the WSDL
     * - documentation: If true, include offers that have fare penalties.
     * - use: optional
     * @var bool
     */
    public $FarePenaltyInd;
    /**
     * The Restriction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Restriction[]
     */
    public $Restriction;
    /**
     * Constructor method for Restrictions
     * @uses Restrictions::setAdvancePurchaseInd()
     * @uses Restrictions::setFarePenaltyInd()
     * @uses Restrictions::setRestriction()
     * @param bool $advancePurchaseInd
     * @param bool $farePenaltyInd
     * @param \StructType\Restriction[] $restriction
     */
    public function __construct($advancePurchaseInd = null, $farePenaltyInd = null, array $restriction = array())
    {
        $this
            ->setAdvancePurchaseInd($advancePurchaseInd)
            ->setFarePenaltyInd($farePenaltyInd)
            ->setRestriction($restriction);
    }
    /**
     * Get AdvancePurchaseInd value
     * @return bool|null
     */
    public function getAdvancePurchaseInd()
    {
        return $this->AdvancePurchaseInd;
    }
    /**
     * Set AdvancePurchaseInd value
     * @param bool $advancePurchaseInd
     * @return \StructType\Restrictions
     */
    public function setAdvancePurchaseInd($advancePurchaseInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($advancePurchaseInd) && !is_bool($advancePurchaseInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advancePurchaseInd, true), gettype($advancePurchaseInd)), __LINE__);
        }
        $this->AdvancePurchaseInd = $advancePurchaseInd;
        return $this;
    }
    /**
     * Get FarePenaltyInd value
     * @return bool|null
     */
    public function getFarePenaltyInd()
    {
        return $this->FarePenaltyInd;
    }
    /**
     * Set FarePenaltyInd value
     * @param bool $farePenaltyInd
     * @return \StructType\Restrictions
     */
    public function setFarePenaltyInd($farePenaltyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($farePenaltyInd) && !is_bool($farePenaltyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($farePenaltyInd, true), gettype($farePenaltyInd)), __LINE__);
        }
        $this->FarePenaltyInd = $farePenaltyInd;
        return $this;
    }
    /**
     * Get Restriction value
     * @return \StructType\Restriction[]|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * This method is responsible for validating the values passed to the setRestriction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestriction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictionForArrayConstraintsFromSetRestriction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restrictionsRestrictionItem) {
            // validation for constraint: itemType
            if (!$restrictionsRestrictionItem instanceof \StructType\Restriction) {
                $invalidValues[] = is_object($restrictionsRestrictionItem) ? get_class($restrictionsRestrictionItem) : sprintf('%s(%s)', gettype($restrictionsRestrictionItem), var_export($restrictionsRestrictionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restriction property can only contain items of type \StructType\Restriction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restriction value
     * @throws \InvalidArgumentException
     * @param \StructType\Restriction[] $restriction
     * @return \StructType\Restrictions
     */
    public function setRestriction(array $restriction = array())
    {
        // validation for constraint: array
        if ('' !== ($restrictionArrayErrorMessage = self::validateRestrictionForArrayConstraintsFromSetRestriction($restriction))) {
            throw new \InvalidArgumentException($restrictionArrayErrorMessage, __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Add item to Restriction value
     * @throws \InvalidArgumentException
     * @param \StructType\Restriction $item
     * @return \StructType\Restrictions
     */
    public function addToRestriction(\StructType\Restriction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restriction) {
            throw new \InvalidArgumentException(sprintf('The Restriction property can only contain items of type \StructType\Restriction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restriction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Restrictions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
