<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestaurantType StructType
 * Meta information extracted from the WSDL
 * - documentation: This may be used to uniquely identify the restaurant. | Information associated with a specific restaurant.
 * @subpackage Structs
 */
class RestaurantType extends AbstractStructBase
{
    /**
     * The MultimediaDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MultimediaDescriptions
     */
    public $MultimediaDescriptions;
    /**
     * The RelativePosition
     * Meta information extracted from the WSDL
     * - documentation: Indicates the directions to a specific restaurant.
     * - minOccurs: 0
     * @var mixed
     */
    public $RelativePosition;
    /**
     * The OperationSchedules
     * Meta information extracted from the WSDL
     * - documentation: Collection of operating times for the restaurant including detail such as season, day of week, or a combination.
     * - minOccurs: 0
     * @var mixed
     */
    public $OperationSchedules;
    /**
     * The InfoCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InfoCodes
     */
    public $InfoCodes;
    /**
     * The CuisineCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CuisineCodes
     */
    public $CuisineCodes;
    /**
     * The DescriptiveText
     * Meta information extracted from the WSDL
     * - documentation: Descriptive text that describes the feature. | Descriptive text that describes the restaurant. | Descriptive text that describes the transportation.
     * - base: xs:string
     * - maxLength: 500
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The RestaurantName
     * Meta information extracted from the WSDL
     * - documentation: The name of the restaurant at the facility.
     * - use: optional
     * @var string
     */
    public $RestaurantName;
    /**
     * The MaxSeatingCapacity
     * Meta information extracted from the WSDL
     * - documentation: The total seating capacity for this restaurant.
     * - use: optional
     * @var int
     */
    public $MaxSeatingCapacity;
    /**
     * The MaxSingleParty
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of people that can be seated as a single party in this restaurant.
     * - use: optional
     * @var int
     */
    public $MaxSingleParty;
    /**
     * The InvCode
     * Meta information extracted from the WSDL
     * - documentation: Identification code of the restaurant service or facility for inventory and booking purposes if the service is an inventoriable item.
     * - use: optional
     * @var string
     */
    public $InvCode;
    /**
     * The OfferBreakfast
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, breakfast is served.
     * - use: optional
     * @var bool
     */
    public $OfferBreakfast;
    /**
     * The OfferLunch
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, lunch is served.
     * - use: optional
     * @var bool
     */
    public $OfferLunch;
    /**
     * The OfferDinner
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, dinner is served.
     * - use: optional
     * @var bool
     */
    public $OfferDinner;
    /**
     * The OfferBrunch
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, brunch is served.
     * - use: optional
     * @var bool
     */
    public $OfferBrunch;
    /**
     * The ProximityCode
     * Meta information extracted from the WSDL
     * - documentation: Denotes whether a service is onsite, offsite or information is not available. Refer to OpenTravel Code Table Proximity (PRX).
     * - use: optional
     * @var string
     */
    public $ProximityCode;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - documentation: Used to define the display order.
     * - use: optional
     * @var int
     */
    public $Sort;
    /**
     * The ReservationReqInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, a reservation must be made to dine in the restaurant.
     * - use: optional
     * @var bool
     */
    public $ReservationReqInd;
    /**
     * The FeaturedInd
     * Meta information extracted from the WSDL
     * - documentation: Example: true | If true, this is a featured restaurant for the property.
     * @var bool
     */
    public $FeaturedInd;
    /**
     * Constructor method for RestaurantType
     * @uses RestaurantType::setMultimediaDescriptions()
     * @uses RestaurantType::setRelativePosition()
     * @uses RestaurantType::setOperationSchedules()
     * @uses RestaurantType::setInfoCodes()
     * @uses RestaurantType::setCuisineCodes()
     * @uses RestaurantType::setDescriptiveText()
     * @uses RestaurantType::setTPA_Extensions()
     * @uses RestaurantType::setRestaurantName()
     * @uses RestaurantType::setMaxSeatingCapacity()
     * @uses RestaurantType::setMaxSingleParty()
     * @uses RestaurantType::setInvCode()
     * @uses RestaurantType::setOfferBreakfast()
     * @uses RestaurantType::setOfferLunch()
     * @uses RestaurantType::setOfferDinner()
     * @uses RestaurantType::setOfferBrunch()
     * @uses RestaurantType::setProximityCode()
     * @uses RestaurantType::setSort()
     * @uses RestaurantType::setReservationReqInd()
     * @uses RestaurantType::setFeaturedInd()
     * @param \StructType\MultimediaDescriptions $multimediaDescriptions
     * @param mixed $relativePosition
     * @param mixed $operationSchedules
     * @param \StructType\InfoCodes $infoCodes
     * @param \StructType\CuisineCodes $cuisineCodes
     * @param string $descriptiveText
     * @param mixed $tPA_Extensions
     * @param string $restaurantName
     * @param int $maxSeatingCapacity
     * @param int $maxSingleParty
     * @param string $invCode
     * @param bool $offerBreakfast
     * @param bool $offerLunch
     * @param bool $offerDinner
     * @param bool $offerBrunch
     * @param string $proximityCode
     * @param int $sort
     * @param bool $reservationReqInd
     * @param bool $featuredInd
     */
    public function __construct(\StructType\MultimediaDescriptions $multimediaDescriptions = null, $relativePosition = null, $operationSchedules = null, \StructType\InfoCodes $infoCodes = null, \StructType\CuisineCodes $cuisineCodes = null, $descriptiveText = null, $tPA_Extensions = null, $restaurantName = null, $maxSeatingCapacity = null, $maxSingleParty = null, $invCode = null, $offerBreakfast = null, $offerLunch = null, $offerDinner = null, $offerBrunch = null, $proximityCode = null, $sort = null, $reservationReqInd = null, $featuredInd = null)
    {
        $this
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setRelativePosition($relativePosition)
            ->setOperationSchedules($operationSchedules)
            ->setInfoCodes($infoCodes)
            ->setCuisineCodes($cuisineCodes)
            ->setDescriptiveText($descriptiveText)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRestaurantName($restaurantName)
            ->setMaxSeatingCapacity($maxSeatingCapacity)
            ->setMaxSingleParty($maxSingleParty)
            ->setInvCode($invCode)
            ->setOfferBreakfast($offerBreakfast)
            ->setOfferLunch($offerLunch)
            ->setOfferDinner($offerDinner)
            ->setOfferBrunch($offerBrunch)
            ->setProximityCode($proximityCode)
            ->setSort($sort)
            ->setReservationReqInd($reservationReqInd)
            ->setFeaturedInd($featuredInd);
    }
    /**
     * Get MultimediaDescriptions value
     * @return \StructType\MultimediaDescriptions|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \StructType\MultimediaDescriptions $multimediaDescriptions
     * @return \StructType\RestaurantType
     */
    public function setMultimediaDescriptions(\StructType\MultimediaDescriptions $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get RelativePosition value
     * @return mixed|null
     */
    public function getRelativePosition()
    {
        return $this->RelativePosition;
    }
    /**
     * Set RelativePosition value
     * @param mixed $relativePosition
     * @return \StructType\RestaurantType
     */
    public function setRelativePosition($relativePosition = null)
    {
        $this->RelativePosition = $relativePosition;
        return $this;
    }
    /**
     * Get OperationSchedules value
     * @return mixed|null
     */
    public function getOperationSchedules()
    {
        return $this->OperationSchedules;
    }
    /**
     * Set OperationSchedules value
     * @param mixed $operationSchedules
     * @return \StructType\RestaurantType
     */
    public function setOperationSchedules($operationSchedules = null)
    {
        $this->OperationSchedules = $operationSchedules;
        return $this;
    }
    /**
     * Get InfoCodes value
     * @return \StructType\InfoCodes|null
     */
    public function getInfoCodes()
    {
        return $this->InfoCodes;
    }
    /**
     * Set InfoCodes value
     * @param \StructType\InfoCodes $infoCodes
     * @return \StructType\RestaurantType
     */
    public function setInfoCodes(\StructType\InfoCodes $infoCodes = null)
    {
        $this->InfoCodes = $infoCodes;
        return $this;
    }
    /**
     * Get CuisineCodes value
     * @return \StructType\CuisineCodes|null
     */
    public function getCuisineCodes()
    {
        return $this->CuisineCodes;
    }
    /**
     * Set CuisineCodes value
     * @param \StructType\CuisineCodes $cuisineCodes
     * @return \StructType\RestaurantType
     */
    public function setCuisineCodes(\StructType\CuisineCodes $cuisineCodes = null)
    {
        $this->CuisineCodes = $cuisineCodes;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \StructType\RestaurantType
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptiveText, true), gettype($descriptiveText)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($descriptiveText) && mb_strlen($descriptiveText) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($descriptiveText)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($descriptiveText) && mb_strlen($descriptiveText) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RestaurantType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RestaurantName value
     * @return string|null
     */
    public function getRestaurantName()
    {
        return $this->RestaurantName;
    }
    /**
     * Set RestaurantName value
     * @param string $restaurantName
     * @return \StructType\RestaurantType
     */
    public function setRestaurantName($restaurantName = null)
    {
        // validation for constraint: string
        if (!is_null($restaurantName) && !is_string($restaurantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restaurantName, true), gettype($restaurantName)), __LINE__);
        }
        $this->RestaurantName = $restaurantName;
        return $this;
    }
    /**
     * Get MaxSeatingCapacity value
     * @return int|null
     */
    public function getMaxSeatingCapacity()
    {
        return $this->MaxSeatingCapacity;
    }
    /**
     * Set MaxSeatingCapacity value
     * @param int $maxSeatingCapacity
     * @return \StructType\RestaurantType
     */
    public function setMaxSeatingCapacity($maxSeatingCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeatingCapacity) && !(is_int($maxSeatingCapacity) || ctype_digit($maxSeatingCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeatingCapacity, true), gettype($maxSeatingCapacity)), __LINE__);
        }
        $this->MaxSeatingCapacity = $maxSeatingCapacity;
        return $this;
    }
    /**
     * Get MaxSingleParty value
     * @return int|null
     */
    public function getMaxSingleParty()
    {
        return $this->MaxSingleParty;
    }
    /**
     * Set MaxSingleParty value
     * @param int $maxSingleParty
     * @return \StructType\RestaurantType
     */
    public function setMaxSingleParty($maxSingleParty = null)
    {
        // validation for constraint: int
        if (!is_null($maxSingleParty) && !(is_int($maxSingleParty) || ctype_digit($maxSingleParty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSingleParty, true), gettype($maxSingleParty)), __LINE__);
        }
        $this->MaxSingleParty = $maxSingleParty;
        return $this;
    }
    /**
     * Get InvCode value
     * @return string|null
     */
    public function getInvCode()
    {
        return $this->InvCode;
    }
    /**
     * Set InvCode value
     * @param string $invCode
     * @return \StructType\RestaurantType
     */
    public function setInvCode($invCode = null)
    {
        // validation for constraint: string
        if (!is_null($invCode) && !is_string($invCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invCode, true), gettype($invCode)), __LINE__);
        }
        $this->InvCode = $invCode;
        return $this;
    }
    /**
     * Get OfferBreakfast value
     * @return bool|null
     */
    public function getOfferBreakfast()
    {
        return $this->OfferBreakfast;
    }
    /**
     * Set OfferBreakfast value
     * @param bool $offerBreakfast
     * @return \StructType\RestaurantType
     */
    public function setOfferBreakfast($offerBreakfast = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerBreakfast) && !is_bool($offerBreakfast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerBreakfast, true), gettype($offerBreakfast)), __LINE__);
        }
        $this->OfferBreakfast = $offerBreakfast;
        return $this;
    }
    /**
     * Get OfferLunch value
     * @return bool|null
     */
    public function getOfferLunch()
    {
        return $this->OfferLunch;
    }
    /**
     * Set OfferLunch value
     * @param bool $offerLunch
     * @return \StructType\RestaurantType
     */
    public function setOfferLunch($offerLunch = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerLunch) && !is_bool($offerLunch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerLunch, true), gettype($offerLunch)), __LINE__);
        }
        $this->OfferLunch = $offerLunch;
        return $this;
    }
    /**
     * Get OfferDinner value
     * @return bool|null
     */
    public function getOfferDinner()
    {
        return $this->OfferDinner;
    }
    /**
     * Set OfferDinner value
     * @param bool $offerDinner
     * @return \StructType\RestaurantType
     */
    public function setOfferDinner($offerDinner = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerDinner) && !is_bool($offerDinner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerDinner, true), gettype($offerDinner)), __LINE__);
        }
        $this->OfferDinner = $offerDinner;
        return $this;
    }
    /**
     * Get OfferBrunch value
     * @return bool|null
     */
    public function getOfferBrunch()
    {
        return $this->OfferBrunch;
    }
    /**
     * Set OfferBrunch value
     * @param bool $offerBrunch
     * @return \StructType\RestaurantType
     */
    public function setOfferBrunch($offerBrunch = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerBrunch) && !is_bool($offerBrunch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerBrunch, true), gettype($offerBrunch)), __LINE__);
        }
        $this->OfferBrunch = $offerBrunch;
        return $this;
    }
    /**
     * Get ProximityCode value
     * @return string|null
     */
    public function getProximityCode()
    {
        return $this->ProximityCode;
    }
    /**
     * Set ProximityCode value
     * @param string $proximityCode
     * @return \StructType\RestaurantType
     */
    public function setProximityCode($proximityCode = null)
    {
        // validation for constraint: string
        if (!is_null($proximityCode) && !is_string($proximityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proximityCode, true), gettype($proximityCode)), __LINE__);
        }
        $this->ProximityCode = $proximityCode;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\RestaurantType
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get ReservationReqInd value
     * @return bool|null
     */
    public function getReservationReqInd()
    {
        return $this->ReservationReqInd;
    }
    /**
     * Set ReservationReqInd value
     * @param bool $reservationReqInd
     * @return \StructType\RestaurantType
     */
    public function setReservationReqInd($reservationReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reservationReqInd) && !is_bool($reservationReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reservationReqInd, true), gettype($reservationReqInd)), __LINE__);
        }
        $this->ReservationReqInd = $reservationReqInd;
        return $this;
    }
    /**
     * Get FeaturedInd value
     * @return bool|null
     */
    public function getFeaturedInd()
    {
        return $this->FeaturedInd;
    }
    /**
     * Set FeaturedInd value
     * @param bool $featuredInd
     * @return \StructType\RestaurantType
     */
    public function setFeaturedInd($featuredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($featuredInd) && !is_bool($featuredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($featuredInd, true), gettype($featuredInd)), __LINE__);
        }
        $this->FeaturedInd = $featuredInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestaurantType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
