<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Residency StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines where the passenger resides for fare calculation purposes.
 * @subpackage Structs
 */
class Residency extends AbstractStructBase
{
    /**
     * The StateProvCode
     * Meta information extracted from the WSDL
     * - documentation: The standard code or abbreviation for the state, province, or region.
     * - use: optional
     * @var mixed
     */
    public $StateProvCode;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: 2 character country code as defined in ISO3166.
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for Residency
     * @uses Residency::setStateProvCode()
     * @uses Residency::setCountryCode()
     * @param mixed $stateProvCode
     * @param string $countryCode
     */
    public function __construct($stateProvCode = null, $countryCode = null)
    {
        $this
            ->setStateProvCode($stateProvCode)
            ->setCountryCode($countryCode);
    }
    /**
     * Get StateProvCode value
     * @return mixed|null
     */
    public function getStateProvCode()
    {
        return $this->StateProvCode;
    }
    /**
     * Set StateProvCode value
     * @param mixed $stateProvCode
     * @return \StructType\Residency
     */
    public function setStateProvCode($stateProvCode = null)
    {
        $this->StateProvCode = $stateProvCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Residency
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Residency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
