<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationsList StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for multiple reservations. The list of reservations will be one of the following types of reservations: global, air, hotel, package tour, golf, cruise, vehicle or rail.
 * @subpackage Structs
 */
class ReservationsList extends AbstractStructBase
{
    /**
     * The AirReservation
     * Meta information extracted from the WSDL
     * - choice: AirReservation | HotelReservation | PackageReservation | GolfReservation | VehicleReservation | GlobalReservation | CruiseReservation | RailReservation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirReservation[]
     */
    public $AirReservation;
    /**
     * The HotelReservation
     * Meta information extracted from the WSDL
     * - documentation: One line in a list of hotel reservations. It may contain the reservation id, booked date, arrival and departure dates, number of nights and rooms, hotel info, guest info, and room info.
     * - choice: AirReservation | HotelReservation | PackageReservation | GolfReservation | VehicleReservation | GlobalReservation | CruiseReservation | RailReservation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelReservationType[]
     */
    public $HotelReservation;
    /**
     * The PackageReservation
     * Meta information extracted from the WSDL
     * - choice: AirReservation | HotelReservation | PackageReservation | GolfReservation | VehicleReservation | GlobalReservation | CruiseReservation | RailReservation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PackageReservation[]
     */
    public $PackageReservation;
    /**
     * The GolfReservation
     * Meta information extracted from the WSDL
     * - choice: AirReservation | HotelReservation | PackageReservation | GolfReservation | VehicleReservation | GlobalReservation | CruiseReservation | RailReservation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GolfReservation[]
     */
    public $GolfReservation;
    /**
     * The VehicleReservation
     * Meta information extracted from the WSDL
     * - choice: AirReservation | HotelReservation | PackageReservation | GolfReservation | VehicleReservation | GlobalReservation | CruiseReservation | RailReservation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VehicleReservation[]
     */
    public $VehicleReservation;
    /**
     * The GlobalReservation
     * Meta information extracted from the WSDL
     * - choice: AirReservation | HotelReservation | PackageReservation | GolfReservation | VehicleReservation | GlobalReservation | CruiseReservation | RailReservation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GlobalReservation[]
     */
    public $GlobalReservation;
    /**
     * The CruiseReservation
     * Meta information extracted from the WSDL
     * - documentation: Retrieves either a single booking or a list of bookings matching the specified criteria.
     * - choice: AirReservation | HotelReservation | PackageReservation | GolfReservation | VehicleReservation | GlobalReservation | CruiseReservation | RailReservation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CruiseReservationType[]
     */
    public $CruiseReservation;
    /**
     * The RailReservation
     * Meta information extracted from the WSDL
     * - documentation: Retrieves either a single booking or a list of bookings matching the specified criteria.
     * - choice: AirReservation | HotelReservation | PackageReservation | GolfReservation | VehicleReservation | GlobalReservation | CruiseReservation | RailReservation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RailReservationSummaryType[]
     */
    public $RailReservation;
    /**
     * Constructor method for ReservationsList
     * @uses ReservationsList::setAirReservation()
     * @uses ReservationsList::setHotelReservation()
     * @uses ReservationsList::setPackageReservation()
     * @uses ReservationsList::setGolfReservation()
     * @uses ReservationsList::setVehicleReservation()
     * @uses ReservationsList::setGlobalReservation()
     * @uses ReservationsList::setCruiseReservation()
     * @uses ReservationsList::setRailReservation()
     * @param \StructType\AirReservation[] $airReservation
     * @param \StructType\HotelReservationType[] $hotelReservation
     * @param \StructType\PackageReservation[] $packageReservation
     * @param \StructType\GolfReservation[] $golfReservation
     * @param \StructType\VehicleReservation[] $vehicleReservation
     * @param \StructType\GlobalReservation[] $globalReservation
     * @param \StructType\CruiseReservationType[] $cruiseReservation
     * @param \StructType\RailReservationSummaryType[] $railReservation
     */
    public function __construct(array $airReservation = array(), array $hotelReservation = array(), array $packageReservation = array(), array $golfReservation = array(), array $vehicleReservation = array(), array $globalReservation = array(), array $cruiseReservation = array(), array $railReservation = array())
    {
        $this
            ->setAirReservation($airReservation)
            ->setHotelReservation($hotelReservation)
            ->setPackageReservation($packageReservation)
            ->setGolfReservation($golfReservation)
            ->setVehicleReservation($vehicleReservation)
            ->setGlobalReservation($globalReservation)
            ->setCruiseReservation($cruiseReservation)
            ->setRailReservation($railReservation);
    }
    /**
     * Get AirReservation value
     * @return \StructType\AirReservation[]|null
     */
    public function getAirReservation()
    {
        return isset($this->AirReservation) ? $this->AirReservation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAirReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirReservationForArrayConstraintsFromSetAirReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationsListAirReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListAirReservationItem instanceof \StructType\AirReservation) {
                $invalidValues[] = is_object($reservationsListAirReservationItem) ? get_class($reservationsListAirReservationItem) : sprintf('%s(%s)', gettype($reservationsListAirReservationItem), var_export($reservationsListAirReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirReservation property can only contain items of type \StructType\AirReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAirReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAirReservationForChoiceConstraintsFromSetAirReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AirReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: AirReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AirReservation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\AirReservation[] $airReservation
     * @return \StructType\ReservationsList
     */
    public function setAirReservation(array $airReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($airReservationArrayErrorMessage = self::validateAirReservationForArrayConstraintsFromSetAirReservation($airReservation))) {
            throw new \InvalidArgumentException($airReservationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($airReservationChoiceErrorMessage = self::validateAirReservationForChoiceConstraintsFromSetAirReservation($airReservation))) {
            throw new \InvalidArgumentException($airReservationChoiceErrorMessage, __LINE__);
        }
        if (is_null($airReservation) || (is_array($airReservation) && empty($airReservation))) {
            unset($this->AirReservation);
        } else {
            $this->AirReservation = $airReservation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAirReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAirReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAirReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AirReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: AirReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to AirReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\AirReservation $item
     * @return \StructType\ReservationsList
     */
    public function addToAirReservation(\StructType\AirReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirReservation) {
            throw new \InvalidArgumentException(sprintf('The AirReservation property can only contain items of type \StructType\AirReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAirReservation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->AirReservation[] = $item;
        return $this;
    }
    /**
     * Get HotelReservation value
     * @return \StructType\HotelReservationType[]|null
     */
    public function getHotelReservation()
    {
        return isset($this->HotelReservation) ? $this->HotelReservation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelReservationForArrayConstraintsFromSetHotelReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationsListHotelReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListHotelReservationItem instanceof \StructType\HotelReservationType) {
                $invalidValues[] = is_object($reservationsListHotelReservationItem) ? get_class($reservationsListHotelReservationItem) : sprintf('%s(%s)', gettype($reservationsListHotelReservationItem), var_export($reservationsListHotelReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelReservation property can only contain items of type \StructType\HotelReservationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelReservationForChoiceConstraintsFromSetHotelReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelReservation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservationType[] $hotelReservation
     * @return \StructType\ReservationsList
     */
    public function setHotelReservation(array $hotelReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelReservationArrayErrorMessage = self::validateHotelReservationForArrayConstraintsFromSetHotelReservation($hotelReservation))) {
            throw new \InvalidArgumentException($hotelReservationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($hotelReservationChoiceErrorMessage = self::validateHotelReservationForChoiceConstraintsFromSetHotelReservation($hotelReservation))) {
            throw new \InvalidArgumentException($hotelReservationChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelReservation) || (is_array($hotelReservation) && empty($hotelReservation))) {
            unset($this->HotelReservation);
        } else {
            $this->HotelReservation = $hotelReservation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToHotelReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToHotelReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToHotelReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to HotelReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservationType $item
     * @return \StructType\ReservationsList
     */
    public function addToHotelReservation(\StructType\HotelReservationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelReservationType) {
            throw new \InvalidArgumentException(sprintf('The HotelReservation property can only contain items of type \StructType\HotelReservationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToHotelReservation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->HotelReservation[] = $item;
        return $this;
    }
    /**
     * Get PackageReservation value
     * @return \StructType\PackageReservation[]|null
     */
    public function getPackageReservation()
    {
        return isset($this->PackageReservation) ? $this->PackageReservation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageReservationForArrayConstraintsFromSetPackageReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationsListPackageReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListPackageReservationItem instanceof \StructType\PackageReservation) {
                $invalidValues[] = is_object($reservationsListPackageReservationItem) ? get_class($reservationsListPackageReservationItem) : sprintf('%s(%s)', gettype($reservationsListPackageReservationItem), var_export($reservationsListPackageReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageReservation property can only contain items of type \StructType\PackageReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPackageReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePackageReservationForChoiceConstraintsFromSetPackageReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PackageReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: PackageReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PackageReservation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\PackageReservation[] $packageReservation
     * @return \StructType\ReservationsList
     */
    public function setPackageReservation(array $packageReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($packageReservationArrayErrorMessage = self::validatePackageReservationForArrayConstraintsFromSetPackageReservation($packageReservation))) {
            throw new \InvalidArgumentException($packageReservationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($packageReservationChoiceErrorMessage = self::validatePackageReservationForChoiceConstraintsFromSetPackageReservation($packageReservation))) {
            throw new \InvalidArgumentException($packageReservationChoiceErrorMessage, __LINE__);
        }
        if (is_null($packageReservation) || (is_array($packageReservation) && empty($packageReservation))) {
            unset($this->PackageReservation);
        } else {
            $this->PackageReservation = $packageReservation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPackageReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPackageReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPackageReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PackageReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: PackageReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to PackageReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageReservation $item
     * @return \StructType\ReservationsList
     */
    public function addToPackageReservation(\StructType\PackageReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageReservation) {
            throw new \InvalidArgumentException(sprintf('The PackageReservation property can only contain items of type \StructType\PackageReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPackageReservation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->PackageReservation[] = $item;
        return $this;
    }
    /**
     * Get GolfReservation value
     * @return \StructType\GolfReservation[]|null
     */
    public function getGolfReservation()
    {
        return isset($this->GolfReservation) ? $this->GolfReservation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGolfReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGolfReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGolfReservationForArrayConstraintsFromSetGolfReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationsListGolfReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListGolfReservationItem instanceof \StructType\GolfReservation) {
                $invalidValues[] = is_object($reservationsListGolfReservationItem) ? get_class($reservationsListGolfReservationItem) : sprintf('%s(%s)', gettype($reservationsListGolfReservationItem), var_export($reservationsListGolfReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GolfReservation property can only contain items of type \StructType\GolfReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGolfReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGolfReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGolfReservationForChoiceConstraintsFromSetGolfReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GolfReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: GolfReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GolfReservation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\GolfReservation[] $golfReservation
     * @return \StructType\ReservationsList
     */
    public function setGolfReservation(array $golfReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($golfReservationArrayErrorMessage = self::validateGolfReservationForArrayConstraintsFromSetGolfReservation($golfReservation))) {
            throw new \InvalidArgumentException($golfReservationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($golfReservationChoiceErrorMessage = self::validateGolfReservationForChoiceConstraintsFromSetGolfReservation($golfReservation))) {
            throw new \InvalidArgumentException($golfReservationChoiceErrorMessage, __LINE__);
        }
        if (is_null($golfReservation) || (is_array($golfReservation) && empty($golfReservation))) {
            unset($this->GolfReservation);
        } else {
            $this->GolfReservation = $golfReservation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToGolfReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToGolfReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToGolfReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GolfReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: GolfReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to GolfReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\GolfReservation $item
     * @return \StructType\ReservationsList
     */
    public function addToGolfReservation(\StructType\GolfReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GolfReservation) {
            throw new \InvalidArgumentException(sprintf('The GolfReservation property can only contain items of type \StructType\GolfReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToGolfReservation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->GolfReservation[] = $item;
        return $this;
    }
    /**
     * Get VehicleReservation value
     * @return \StructType\VehicleReservation[]|null
     */
    public function getVehicleReservation()
    {
        return isset($this->VehicleReservation) ? $this->VehicleReservation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVehicleReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicleReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehicleReservationForArrayConstraintsFromSetVehicleReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationsListVehicleReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListVehicleReservationItem instanceof \StructType\VehicleReservation) {
                $invalidValues[] = is_object($reservationsListVehicleReservationItem) ? get_class($reservationsListVehicleReservationItem) : sprintf('%s(%s)', gettype($reservationsListVehicleReservationItem), var_export($reservationsListVehicleReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehicleReservation property can only contain items of type \StructType\VehicleReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setVehicleReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicleReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVehicleReservationForChoiceConstraintsFromSetVehicleReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VehicleReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: VehicleReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VehicleReservation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleReservation[] $vehicleReservation
     * @return \StructType\ReservationsList
     */
    public function setVehicleReservation(array $vehicleReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($vehicleReservationArrayErrorMessage = self::validateVehicleReservationForArrayConstraintsFromSetVehicleReservation($vehicleReservation))) {
            throw new \InvalidArgumentException($vehicleReservationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($vehicleReservationChoiceErrorMessage = self::validateVehicleReservationForChoiceConstraintsFromSetVehicleReservation($vehicleReservation))) {
            throw new \InvalidArgumentException($vehicleReservationChoiceErrorMessage, __LINE__);
        }
        if (is_null($vehicleReservation) || (is_array($vehicleReservation) && empty($vehicleReservation))) {
            unset($this->VehicleReservation);
        } else {
            $this->VehicleReservation = $vehicleReservation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToVehicleReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToVehicleReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToVehicleReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'GlobalReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VehicleReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: VehicleReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to VehicleReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleReservation $item
     * @return \StructType\ReservationsList
     */
    public function addToVehicleReservation(\StructType\VehicleReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleReservation) {
            throw new \InvalidArgumentException(sprintf('The VehicleReservation property can only contain items of type \StructType\VehicleReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToVehicleReservation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->VehicleReservation[] = $item;
        return $this;
    }
    /**
     * Get GlobalReservation value
     * @return \StructType\GlobalReservation[]|null
     */
    public function getGlobalReservation()
    {
        return isset($this->GlobalReservation) ? $this->GlobalReservation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGlobalReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGlobalReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGlobalReservationForArrayConstraintsFromSetGlobalReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationsListGlobalReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListGlobalReservationItem instanceof \StructType\GlobalReservation) {
                $invalidValues[] = is_object($reservationsListGlobalReservationItem) ? get_class($reservationsListGlobalReservationItem) : sprintf('%s(%s)', gettype($reservationsListGlobalReservationItem), var_export($reservationsListGlobalReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GlobalReservation property can only contain items of type \StructType\GlobalReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGlobalReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGlobalReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGlobalReservationForChoiceConstraintsFromSetGlobalReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GlobalReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: GlobalReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GlobalReservation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\GlobalReservation[] $globalReservation
     * @return \StructType\ReservationsList
     */
    public function setGlobalReservation(array $globalReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($globalReservationArrayErrorMessage = self::validateGlobalReservationForArrayConstraintsFromSetGlobalReservation($globalReservation))) {
            throw new \InvalidArgumentException($globalReservationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($globalReservationChoiceErrorMessage = self::validateGlobalReservationForChoiceConstraintsFromSetGlobalReservation($globalReservation))) {
            throw new \InvalidArgumentException($globalReservationChoiceErrorMessage, __LINE__);
        }
        if (is_null($globalReservation) || (is_array($globalReservation) && empty($globalReservation))) {
            unset($this->GlobalReservation);
        } else {
            $this->GlobalReservation = $globalReservation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToGlobalReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToGlobalReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToGlobalReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'CruiseReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GlobalReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: GlobalReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to GlobalReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\GlobalReservation $item
     * @return \StructType\ReservationsList
     */
    public function addToGlobalReservation(\StructType\GlobalReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GlobalReservation) {
            throw new \InvalidArgumentException(sprintf('The GlobalReservation property can only contain items of type \StructType\GlobalReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToGlobalReservation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->GlobalReservation[] = $item;
        return $this;
    }
    /**
     * Get CruiseReservation value
     * @return \StructType\CruiseReservationType[]|null
     */
    public function getCruiseReservation()
    {
        return isset($this->CruiseReservation) ? $this->CruiseReservation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCruiseReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCruiseReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCruiseReservationForArrayConstraintsFromSetCruiseReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationsListCruiseReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListCruiseReservationItem instanceof \StructType\CruiseReservationType) {
                $invalidValues[] = is_object($reservationsListCruiseReservationItem) ? get_class($reservationsListCruiseReservationItem) : sprintf('%s(%s)', gettype($reservationsListCruiseReservationItem), var_export($reservationsListCruiseReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CruiseReservation property can only contain items of type \StructType\CruiseReservationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCruiseReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCruiseReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCruiseReservationForChoiceConstraintsFromSetCruiseReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CruiseReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: CruiseReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CruiseReservation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\CruiseReservationType[] $cruiseReservation
     * @return \StructType\ReservationsList
     */
    public function setCruiseReservation(array $cruiseReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($cruiseReservationArrayErrorMessage = self::validateCruiseReservationForArrayConstraintsFromSetCruiseReservation($cruiseReservation))) {
            throw new \InvalidArgumentException($cruiseReservationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($cruiseReservationChoiceErrorMessage = self::validateCruiseReservationForChoiceConstraintsFromSetCruiseReservation($cruiseReservation))) {
            throw new \InvalidArgumentException($cruiseReservationChoiceErrorMessage, __LINE__);
        }
        if (is_null($cruiseReservation) || (is_array($cruiseReservation) && empty($cruiseReservation))) {
            unset($this->CruiseReservation);
        } else {
            $this->CruiseReservation = $cruiseReservation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToCruiseReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToCruiseReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToCruiseReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'RailReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CruiseReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: CruiseReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to CruiseReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\CruiseReservationType $item
     * @return \StructType\ReservationsList
     */
    public function addToCruiseReservation(\StructType\CruiseReservationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CruiseReservationType) {
            throw new \InvalidArgumentException(sprintf('The CruiseReservation property can only contain items of type \StructType\CruiseReservationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToCruiseReservation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->CruiseReservation[] = $item;
        return $this;
    }
    /**
     * Get RailReservation value
     * @return \StructType\RailReservationSummaryType[]|null
     */
    public function getRailReservation()
    {
        return isset($this->RailReservation) ? $this->RailReservation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRailReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRailReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRailReservationForArrayConstraintsFromSetRailReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationsListRailReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListRailReservationItem instanceof \StructType\RailReservationSummaryType) {
                $invalidValues[] = is_object($reservationsListRailReservationItem) ? get_class($reservationsListRailReservationItem) : sprintf('%s(%s)', gettype($reservationsListRailReservationItem), var_export($reservationsListRailReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RailReservation property can only contain items of type \StructType\RailReservationSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setRailReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRailReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRailReservationForChoiceConstraintsFromSetRailReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RailReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: RailReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RailReservation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\RailReservationSummaryType[] $railReservation
     * @return \StructType\ReservationsList
     */
    public function setRailReservation(array $railReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($railReservationArrayErrorMessage = self::validateRailReservationForArrayConstraintsFromSetRailReservation($railReservation))) {
            throw new \InvalidArgumentException($railReservationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($railReservationChoiceErrorMessage = self::validateRailReservationForChoiceConstraintsFromSetRailReservation($railReservation))) {
            throw new \InvalidArgumentException($railReservationChoiceErrorMessage, __LINE__);
        }
        if (is_null($railReservation) || (is_array($railReservation) && empty($railReservation))) {
            unset($this->RailReservation);
        } else {
            $this->RailReservation = $railReservation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToRailReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToRailReservation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToRailReservation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirReservation',
            'HotelReservation',
            'PackageReservation',
            'GolfReservation',
            'VehicleReservation',
            'GlobalReservation',
            'CruiseReservation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RailReservation can\'t be set as the property %s is already set. Only one property must be set among these properties: RailReservation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to RailReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\RailReservationSummaryType $item
     * @return \StructType\ReservationsList
     */
    public function addToRailReservation(\StructType\RailReservationSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RailReservationSummaryType) {
            throw new \InvalidArgumentException(sprintf('The RailReservation property can only contain items of type \StructType\RailReservationSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(AirReservation, HotelReservation, PackageReservation, GolfReservation, VehicleReservation, GlobalReservation, CruiseReservation, RailReservation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToRailReservation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->RailReservation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReservationsList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
