<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResGuestsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of ResGuest objects, identifying the guests associated with this reservation. Which guests are in which room is determined by each RoomStays ResGuestRPHs collection.
 * @subpackage Structs
 */
class ResGuestsType extends AbstractStructBase
{
    /**
     * The ResGuest
     * Meta information extracted from the WSDL
     * - documentation: The ResGuest object contains the information about a guest associated with a reservation.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $ResGuest;
    /**
     * Constructor method for ResGuestsType
     * @uses ResGuestsType::setResGuest()
     * @param mixed[] $resGuest
     */
    public function __construct(array $resGuest = array())
    {
        $this
            ->setResGuest($resGuest);
    }
    /**
     * Get ResGuest value
     * @return mixed[]|null
     */
    public function getResGuest()
    {
        return $this->ResGuest;
    }
    /**
     * This method is responsible for validating the values passed to the setResGuest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResGuest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResGuestForArrayConstraintsFromSetResGuest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resGuestsTypeResGuestItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($resGuestsTypeResGuestItem) ? get_class($resGuestsTypeResGuestItem) : sprintf('%s(%s)', gettype($resGuestsTypeResGuestItem), var_export($resGuestsTypeResGuestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResGuest property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResGuest value
     * @throws \InvalidArgumentException
     * @param mixed[] $resGuest
     * @return \StructType\ResGuestsType
     */
    public function setResGuest(array $resGuest = array())
    {
        // validation for constraint: array
        if ('' !== ($resGuestArrayErrorMessage = self::validateResGuestForArrayConstraintsFromSetResGuest($resGuest))) {
            throw new \InvalidArgumentException($resGuestArrayErrorMessage, __LINE__);
        }
        $this->ResGuest = $resGuest;
        return $this;
    }
    /**
     * Add item to ResGuest value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ResGuestsType
     */
    public function addToResGuest($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ResGuest property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResGuest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResGuestsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
