<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResGlobalInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: ResGlobalInfo is a container for various information that affects the Reservation as a whole. These include global comments, counts, reservation IDs, loyalty programs, and payment methods.
 * @subpackage Structs
 */
class ResGlobalInfo extends ResGlobalInfoType
{
    /**
     * The BasicPropertyInfo
     * Meta information extracted from the WSDL
     * - documentation: Property information for the reservation.
     * @var mixed
     */
    public $BasicPropertyInfo;
    /**
     * Constructor method for ResGlobalInfo
     * @uses ResGlobalInfo::setBasicPropertyInfo()
     * @param mixed $basicPropertyInfo
     */
    public function __construct($basicPropertyInfo = null)
    {
        $this
            ->setBasicPropertyInfo($basicPropertyInfo);
    }
    /**
     * Get BasicPropertyInfo value
     * @return mixed|null
     */
    public function getBasicPropertyInfo()
    {
        return $this->BasicPropertyInfo;
    }
    /**
     * Set BasicPropertyInfo value
     * @param mixed $basicPropertyInfo
     * @return \StructType\ResGlobalInfo
     */
    public function setBasicPropertyInfo($basicPropertyInfo = null)
    {
        $this->BasicPropertyInfo = $basicPropertyInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResGlobalInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
