<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResBookDesignations StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of ResBookDesignations.
 * @subpackage Structs
 */
class ResBookDesignations extends AbstractStructBase
{
    /**
     * The ResBookDesignation
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\ResBookDesignation[]
     */
    public $ResBookDesignation;
    /**
     * Constructor method for ResBookDesignations
     * @uses ResBookDesignations::setResBookDesignation()
     * @param \StructType\ResBookDesignation[] $resBookDesignation
     */
    public function __construct(array $resBookDesignation = array())
    {
        $this
            ->setResBookDesignation($resBookDesignation);
    }
    /**
     * Get ResBookDesignation value
     * @return \StructType\ResBookDesignation[]|null
     */
    public function getResBookDesignation()
    {
        return $this->ResBookDesignation;
    }
    /**
     * This method is responsible for validating the values passed to the setResBookDesignation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResBookDesignation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResBookDesignationForArrayConstraintsFromSetResBookDesignation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resBookDesignationsResBookDesignationItem) {
            // validation for constraint: itemType
            if (!$resBookDesignationsResBookDesignationItem instanceof \StructType\ResBookDesignation) {
                $invalidValues[] = is_object($resBookDesignationsResBookDesignationItem) ? get_class($resBookDesignationsResBookDesignationItem) : sprintf('%s(%s)', gettype($resBookDesignationsResBookDesignationItem), var_export($resBookDesignationsResBookDesignationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResBookDesignation property can only contain items of type \StructType\ResBookDesignation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResBookDesignation value
     * @throws \InvalidArgumentException
     * @param \StructType\ResBookDesignation[] $resBookDesignation
     * @return \StructType\ResBookDesignations
     */
    public function setResBookDesignation(array $resBookDesignation = array())
    {
        // validation for constraint: array
        if ('' !== ($resBookDesignationArrayErrorMessage = self::validateResBookDesignationForArrayConstraintsFromSetResBookDesignation($resBookDesignation))) {
            throw new \InvalidArgumentException($resBookDesignationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($resBookDesignation) && count($resBookDesignation) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($resBookDesignation)), __LINE__);
        }
        $this->ResBookDesignation = $resBookDesignation;
        return $this;
    }
    /**
     * Add item to ResBookDesignation value
     * @throws \InvalidArgumentException
     * @param \StructType\ResBookDesignation $item
     * @return \StructType\ResBookDesignations
     */
    public function addToResBookDesignation(\StructType\ResBookDesignation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResBookDesignation) {
            throw new \InvalidArgumentException(sprintf('The ResBookDesignation property can only contain items of type \StructType\ResBookDesignation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->ResBookDesignation) && count($this->ResBookDesignation) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->ResBookDesignation)), __LINE__);
        }
        $this->ResBookDesignation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResBookDesignations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
