<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequiredPaymentLiteType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary version of the RequiredPaymentType, initially created for the Travel Itinerary Message set.
 * @subpackage Structs
 */
class RequiredPaymentLiteType extends AbstractStructBase
{
    /**
     * The AcceptedPayments
     * Meta information extracted from the WSDL
     * - documentation: Collection of forms of payment accepted for payment.
     * - minOccurs: 0
     * @var mixed
     */
    public $AcceptedPayments;
    /**
     * The AmountPercent
     * Meta information extracted from the WSDL
     * - documentation: Payment expressed as a fixed amount, or a percentage of/or room nights.
     * - minOccurs: 0
     * @var mixed
     */
    public $AmountPercent;
    /**
     * The RetributionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var mixed
     */
    public $RetributionType;
    /**
     * Constructor method for RequiredPaymentLiteType
     * @uses RequiredPaymentLiteType::setAcceptedPayments()
     * @uses RequiredPaymentLiteType::setAmountPercent()
     * @uses RequiredPaymentLiteType::setRetributionType()
     * @param mixed $acceptedPayments
     * @param mixed $amountPercent
     * @param mixed $retributionType
     */
    public function __construct($acceptedPayments = null, $amountPercent = null, $retributionType = null)
    {
        $this
            ->setAcceptedPayments($acceptedPayments)
            ->setAmountPercent($amountPercent)
            ->setRetributionType($retributionType);
    }
    /**
     * Get AcceptedPayments value
     * @return mixed|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param mixed $acceptedPayments
     * @return \StructType\RequiredPaymentLiteType
     */
    public function setAcceptedPayments($acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return mixed|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param mixed $amountPercent
     * @return \StructType\RequiredPaymentLiteType
     */
    public function setAmountPercent($amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get RetributionType value
     * @return mixed|null
     */
    public function getRetributionType()
    {
        return $this->RetributionType;
    }
    /**
     * Set RetributionType value
     * @param mixed $retributionType
     * @return \StructType\RequiredPaymentLiteType
     */
    public function setRetributionType($retributionType = null)
    {
        $this->RetributionType = $retributionType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequiredPaymentLiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
