<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportSummaries StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for ReportSummary elements of type ParagraphType. | Collection of ReportSummary elements.
 * @subpackage Structs
 */
class ReportSummaries extends AbstractStructBase
{
    /**
     * The ReportSummary
     * Meta information extracted from the WSDL
     * - documentation: This element has text information, included with the data in the report as needed.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $ReportSummary;
    /**
     * Constructor method for ReportSummaries
     * @uses ReportSummaries::setReportSummary()
     * @param mixed[] $reportSummary
     */
    public function __construct(array $reportSummary = array())
    {
        $this
            ->setReportSummary($reportSummary);
    }
    /**
     * Get ReportSummary value
     * @return mixed[]|null
     */
    public function getReportSummary()
    {
        return $this->ReportSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setReportSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReportSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReportSummaryForArrayConstraintsFromSetReportSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reportSummariesReportSummaryItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($reportSummariesReportSummaryItem) ? get_class($reportSummariesReportSummaryItem) : sprintf('%s(%s)', gettype($reportSummariesReportSummaryItem), var_export($reportSummariesReportSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReportSummary property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReportSummary value
     * @throws \InvalidArgumentException
     * @param mixed[] $reportSummary
     * @return \StructType\ReportSummaries
     */
    public function setReportSummary(array $reportSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($reportSummaryArrayErrorMessage = self::validateReportSummaryForArrayConstraintsFromSetReportSummary($reportSummary))) {
            throw new \InvalidArgumentException($reportSummaryArrayErrorMessage, __LINE__);
        }
        $this->ReportSummary = $reportSummary;
        return $this;
    }
    /**
     * Add item to ReportSummary value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ReportSummaries
     */
    public function addToReportSummary($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ReportSummary property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReportSummary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportSummaries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
