<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelativePositions StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of directions to/from one or more locations.
 * @subpackage Structs
 */
class RelativePositions extends AbstractStructBase
{
    /**
     * The RelativePosition
     * Meta information extracted from the WSDL
     * - documentation: Where the hotel is in relation to/from a location.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $RelativePosition;
    /**
     * Constructor method for RelativePositions
     * @uses RelativePositions::setRelativePosition()
     * @param mixed[] $relativePosition
     */
    public function __construct(array $relativePosition = array())
    {
        $this
            ->setRelativePosition($relativePosition);
    }
    /**
     * Get RelativePosition value
     * @return mixed[]|null
     */
    public function getRelativePosition()
    {
        return $this->RelativePosition;
    }
    /**
     * This method is responsible for validating the values passed to the setRelativePosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelativePosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelativePositionForArrayConstraintsFromSetRelativePosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relativePositionsRelativePositionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($relativePositionsRelativePositionItem) ? get_class($relativePositionsRelativePositionItem) : sprintf('%s(%s)', gettype($relativePositionsRelativePositionItem), var_export($relativePositionsRelativePositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelativePosition property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelativePosition value
     * @throws \InvalidArgumentException
     * @param mixed[] $relativePosition
     * @return \StructType\RelativePositions
     */
    public function setRelativePosition(array $relativePosition = array())
    {
        // validation for constraint: array
        if ('' !== ($relativePositionArrayErrorMessage = self::validateRelativePositionForArrayConstraintsFromSetRelativePosition($relativePosition))) {
            throw new \InvalidArgumentException($relativePositionArrayErrorMessage, __LINE__);
        }
        $this->RelativePosition = $relativePosition;
        return $this;
    }
    /**
     * Add item to RelativePosition value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RelativePositions
     */
    public function addToRelativePosition($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RelativePosition property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelativePosition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelativePositions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
