<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recreations StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Recreation objects identifying the different types of recreation facilities available to the guest.
 * @subpackage Structs
 */
class Recreations extends AbstractStructBase
{
    /**
     * The Recreation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Recreation[]
     */
    public $Recreation;
    /**
     * The LastUpdated
     * Meta information extracted from the WSDL
     * - documentation: The date and time when Recreations was last updated.
     * - use: optional
     * @var string
     */
    public $LastUpdated;
    /**
     * Constructor method for Recreations
     * @uses Recreations::setRecreation()
     * @uses Recreations::setLastUpdated()
     * @param \StructType\Recreation[] $recreation
     * @param string $lastUpdated
     */
    public function __construct(array $recreation = array(), $lastUpdated = null)
    {
        $this
            ->setRecreation($recreation)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get Recreation value
     * @return \StructType\Recreation[]|null
     */
    public function getRecreation()
    {
        return $this->Recreation;
    }
    /**
     * This method is responsible for validating the values passed to the setRecreation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecreation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecreationForArrayConstraintsFromSetRecreation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recreationsRecreationItem) {
            // validation for constraint: itemType
            if (!$recreationsRecreationItem instanceof \StructType\Recreation) {
                $invalidValues[] = is_object($recreationsRecreationItem) ? get_class($recreationsRecreationItem) : sprintf('%s(%s)', gettype($recreationsRecreationItem), var_export($recreationsRecreationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recreation property can only contain items of type \StructType\Recreation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recreation value
     * @throws \InvalidArgumentException
     * @param \StructType\Recreation[] $recreation
     * @return \StructType\Recreations
     */
    public function setRecreation(array $recreation = array())
    {
        // validation for constraint: array
        if ('' !== ($recreationArrayErrorMessage = self::validateRecreationForArrayConstraintsFromSetRecreation($recreation))) {
            throw new \InvalidArgumentException($recreationArrayErrorMessage, __LINE__);
        }
        $this->Recreation = $recreation;
        return $this;
    }
    /**
     * Add item to Recreation value
     * @throws \InvalidArgumentException
     * @param \StructType\Recreation $item
     * @return \StructType\Recreations
     */
    public function addToRecreation(\StructType\Recreation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recreation) {
            throw new \InvalidArgumentException(sprintf('The Recreation property can only contain items of type \StructType\Recreation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recreation[] = $item;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\Recreations
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Recreations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
