<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RebateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about a suppliers participation in a rebate program, e.g. a VAT (value added tax) program.
 * @subpackage Structs
 */
class RebateType extends AbstractStructBase
{
    /**
     * The PaymentInformation
     * Meta information extracted from the WSDL
     * - documentation: Information about payments eligible for a rebate program.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PaymentInformation;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The ParticipationInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the supplier is participating in a rebate program, e.g. a VAT (value added tax) program.
     * - use: optional
     * @var bool
     */
    public $ParticipationInd;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - documentation: The name of the rebate program.
     * - use: optional
     * @var string
     */
    public $ProgramName;
    /**
     * Constructor method for RebateType
     * @uses RebateType::setPaymentInformation()
     * @uses RebateType::setTPA_Extensions()
     * @uses RebateType::setParticipationInd()
     * @uses RebateType::setProgramName()
     * @param mixed[] $paymentInformation
     * @param mixed $tPA_Extensions
     * @param bool $participationInd
     * @param string $programName
     */
    public function __construct(array $paymentInformation = array(), $tPA_Extensions = null, $participationInd = null, $programName = null)
    {
        $this
            ->setPaymentInformation($paymentInformation)
            ->setTPA_Extensions($tPA_Extensions)
            ->setParticipationInd($participationInd)
            ->setProgramName($programName);
    }
    /**
     * Get PaymentInformation value
     * @return mixed[]|null
     */
    public function getPaymentInformation()
    {
        return $this->PaymentInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentInformationForArrayConstraintsFromSetPaymentInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rebateTypePaymentInformationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($rebateTypePaymentInformationItem) ? get_class($rebateTypePaymentInformationItem) : sprintf('%s(%s)', gettype($rebateTypePaymentInformationItem), var_export($rebateTypePaymentInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentInformation property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentInformation value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentInformation
     * @return \StructType\RebateType
     */
    public function setPaymentInformation(array $paymentInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentInformationArrayErrorMessage = self::validatePaymentInformationForArrayConstraintsFromSetPaymentInformation($paymentInformation))) {
            throw new \InvalidArgumentException($paymentInformationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($paymentInformation) && count($paymentInformation) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($paymentInformation)), __LINE__);
        }
        $this->PaymentInformation = $paymentInformation;
        return $this;
    }
    /**
     * Add item to PaymentInformation value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RebateType
     */
    public function addToPaymentInformation($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PaymentInformation property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PaymentInformation) && count($this->PaymentInformation) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PaymentInformation)), __LINE__);
        }
        $this->PaymentInformation[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RebateType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ParticipationInd value
     * @return bool|null
     */
    public function getParticipationInd()
    {
        return $this->ParticipationInd;
    }
    /**
     * Set ParticipationInd value
     * @param bool $participationInd
     * @return \StructType\RebateType
     */
    public function setParticipationInd($participationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($participationInd) && !is_bool($participationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($participationInd, true), gettype($participationInd)), __LINE__);
        }
        $this->ParticipationInd = $participationInd;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\RebateType
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RebateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
