<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRanges StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of rate range information.
 * @subpackage Structs
 */
class RateRanges extends AbstractStructBase
{
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\RateRange[]
     */
    public $RateRange;
    /**
     * Constructor method for RateRanges
     * @uses RateRanges::setRateRange()
     * @param \StructType\RateRange[] $rateRange
     */
    public function __construct(array $rateRange = array())
    {
        $this
            ->setRateRange($rateRange);
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange[]|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * This method is responsible for validating the values passed to the setRateRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateRange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateRangeForArrayConstraintsFromSetRateRange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateRangesRateRangeItem) {
            // validation for constraint: itemType
            if (!$rateRangesRateRangeItem instanceof \StructType\RateRange) {
                $invalidValues[] = is_object($rateRangesRateRangeItem) ? get_class($rateRangesRateRangeItem) : sprintf('%s(%s)', gettype($rateRangesRateRangeItem), var_export($rateRangesRateRangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateRange property can only contain items of type \StructType\RateRange, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\RateRange[] $rateRange
     * @return \StructType\RateRanges
     */
    public function setRateRange(array $rateRange = array())
    {
        // validation for constraint: array
        if ('' !== ($rateRangeArrayErrorMessage = self::validateRateRangeForArrayConstraintsFromSetRateRange($rateRange))) {
            throw new \InvalidArgumentException($rateRangeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($rateRange) && count($rateRange) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($rateRange)), __LINE__);
        }
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Add item to RateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\RateRange $item
     * @return \StructType\RateRanges
     */
    public function addToRateRange(\StructType\RateRange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateRange) {
            throw new \InvalidArgumentException(sprintf('The RateRange property can only contain items of type \StructType\RateRange, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RateRange) && count($this->RateRange) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RateRange)), __LINE__);
        }
        $this->RateRange[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateRanges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
