<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanCandidates StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of requested rate plans.
 * @subpackage Structs
 */
class RatePlanCandidates extends RatePlanCandidatesType
{
    /**
     * The TaxesIncludedInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, the rates prices in the response message must include all taxes and surcharges.
     * - use: optional
     * @var bool
     */
    public $TaxesIncludedInd;
    /**
     * Constructor method for RatePlanCandidates
     * @uses RatePlanCandidates::setTaxesIncludedInd()
     * @param bool $taxesIncludedInd
     */
    public function __construct($taxesIncludedInd = null)
    {
        $this
            ->setTaxesIncludedInd($taxesIncludedInd);
    }
    /**
     * Get TaxesIncludedInd value
     * @return bool|null
     */
    public function getTaxesIncludedInd()
    {
        return $this->TaxesIncludedInd;
    }
    /**
     * Set TaxesIncludedInd value
     * @param bool $taxesIncludedInd
     * @return \StructType\RatePlanCandidates
     */
    public function setTaxesIncludedInd($taxesIncludedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxesIncludedInd) && !is_bool($taxesIncludedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxesIncludedInd, true), gettype($taxesIncludedInd)), __LINE__);
        }
        $this->TaxesIncludedInd = $taxesIncludedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlanCandidates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
