<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanCandidate StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to identify available products and rates.
 * @subpackage Structs
 */
class RatePlanCandidate extends AbstractStructBase
{
    /**
     * The HotelRefs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelRefs
     */
    public $HotelRefs;
    /**
     * The MealsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MealsIncluded
     */
    public $MealsIncluded;
    /**
     * The ArrivalPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ArrivalPolicy
     */
    public $ArrivalPolicy;
    /**
     * The RatePlanCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlanCommission
     */
    public $RatePlanCommission;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for this rate plan candidate.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The PrepaidQualifier
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PrepaidQualifier;
    /**
     * The AvailRatesOnlyInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, the response should include ONLY those rates that are available in the date range specified. If FALSE, all rates are to be returned.
     * - use: optional
     * @var bool
     */
    public $AvailRatesOnlyInd;
    /**
     * The RatePlanFilterCode
     * Meta information extracted from the WSDL
     * - documentation: Description: A string value that specifies the rate plan filter. A rate plan filter allows similar rate plans to be grouped together.
     * @var string
     */
    public $RatePlanFilterCode;
    /**
     * Constructor method for RatePlanCandidate
     * @uses RatePlanCandidate::setHotelRefs()
     * @uses RatePlanCandidate::setMealsIncluded()
     * @uses RatePlanCandidate::setArrivalPolicy()
     * @uses RatePlanCandidate::setRatePlanCommission()
     * @uses RatePlanCandidate::setRPH()
     * @uses RatePlanCandidate::setPrepaidQualifier()
     * @uses RatePlanCandidate::setAvailRatesOnlyInd()
     * @uses RatePlanCandidate::setRatePlanFilterCode()
     * @param \StructType\HotelRefs $hotelRefs
     * @param \StructType\MealsIncluded $mealsIncluded
     * @param \StructType\ArrivalPolicy $arrivalPolicy
     * @param \StructType\RatePlanCommission $ratePlanCommission
     * @param string $rPH
     * @param string $prepaidQualifier
     * @param bool $availRatesOnlyInd
     * @param string $ratePlanFilterCode
     */
    public function __construct(\StructType\HotelRefs $hotelRefs = null, \StructType\MealsIncluded $mealsIncluded = null, \StructType\ArrivalPolicy $arrivalPolicy = null, \StructType\RatePlanCommission $ratePlanCommission = null, $rPH = null, $prepaidQualifier = null, $availRatesOnlyInd = null, $ratePlanFilterCode = null)
    {
        $this
            ->setHotelRefs($hotelRefs)
            ->setMealsIncluded($mealsIncluded)
            ->setArrivalPolicy($arrivalPolicy)
            ->setRatePlanCommission($ratePlanCommission)
            ->setRPH($rPH)
            ->setPrepaidQualifier($prepaidQualifier)
            ->setAvailRatesOnlyInd($availRatesOnlyInd)
            ->setRatePlanFilterCode($ratePlanFilterCode);
    }
    /**
     * Get HotelRefs value
     * @return \StructType\HotelRefs|null
     */
    public function getHotelRefs()
    {
        return $this->HotelRefs;
    }
    /**
     * Set HotelRefs value
     * @param \StructType\HotelRefs $hotelRefs
     * @return \StructType\RatePlanCandidate
     */
    public function setHotelRefs(\StructType\HotelRefs $hotelRefs = null)
    {
        $this->HotelRefs = $hotelRefs;
        return $this;
    }
    /**
     * Get MealsIncluded value
     * @return \StructType\MealsIncluded|null
     */
    public function getMealsIncluded()
    {
        return $this->MealsIncluded;
    }
    /**
     * Set MealsIncluded value
     * @param \StructType\MealsIncluded $mealsIncluded
     * @return \StructType\RatePlanCandidate
     */
    public function setMealsIncluded(\StructType\MealsIncluded $mealsIncluded = null)
    {
        $this->MealsIncluded = $mealsIncluded;
        return $this;
    }
    /**
     * Get ArrivalPolicy value
     * @return \StructType\ArrivalPolicy|null
     */
    public function getArrivalPolicy()
    {
        return $this->ArrivalPolicy;
    }
    /**
     * Set ArrivalPolicy value
     * @param \StructType\ArrivalPolicy $arrivalPolicy
     * @return \StructType\RatePlanCandidate
     */
    public function setArrivalPolicy(\StructType\ArrivalPolicy $arrivalPolicy = null)
    {
        $this->ArrivalPolicy = $arrivalPolicy;
        return $this;
    }
    /**
     * Get RatePlanCommission value
     * @return \StructType\RatePlanCommission|null
     */
    public function getRatePlanCommission()
    {
        return $this->RatePlanCommission;
    }
    /**
     * Set RatePlanCommission value
     * @param \StructType\RatePlanCommission $ratePlanCommission
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanCommission(\StructType\RatePlanCommission $ratePlanCommission = null)
    {
        $this->RatePlanCommission = $ratePlanCommission;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\RatePlanCandidate
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PrepaidQualifier value
     * @return string|null
     */
    public function getPrepaidQualifier()
    {
        return $this->PrepaidQualifier;
    }
    /**
     * Set PrepaidQualifier value
     * @param string $prepaidQualifier
     * @return \StructType\RatePlanCandidate
     */
    public function setPrepaidQualifier($prepaidQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($prepaidQualifier) && !is_string($prepaidQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaidQualifier, true), gettype($prepaidQualifier)), __LINE__);
        }
        $this->PrepaidQualifier = $prepaidQualifier;
        return $this;
    }
    /**
     * Get AvailRatesOnlyInd value
     * @return bool|null
     */
    public function getAvailRatesOnlyInd()
    {
        return $this->AvailRatesOnlyInd;
    }
    /**
     * Set AvailRatesOnlyInd value
     * @param bool $availRatesOnlyInd
     * @return \StructType\RatePlanCandidate
     */
    public function setAvailRatesOnlyInd($availRatesOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($availRatesOnlyInd) && !is_bool($availRatesOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availRatesOnlyInd, true), gettype($availRatesOnlyInd)), __LINE__);
        }
        $this->AvailRatesOnlyInd = $availRatesOnlyInd;
        return $this;
    }
    /**
     * Get RatePlanFilterCode value
     * @return string|null
     */
    public function getRatePlanFilterCode()
    {
        return $this->RatePlanFilterCode;
    }
    /**
     * Set RatePlanFilterCode value
     * @param string $ratePlanFilterCode
     * @return \StructType\RatePlanCandidate
     */
    public function setRatePlanFilterCode($ratePlanFilterCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanFilterCode) && !is_string($ratePlanFilterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanFilterCode, true), gettype($ratePlanFilterCode)), __LINE__);
        }
        $this->RatePlanFilterCode = $ratePlanFilterCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlanCandidate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
