<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateComments StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of rate comments.
 * @subpackage Structs
 */
class RateComments extends AbstractStructBase
{
    /**
     * The RateComment
     * Meta information extracted from the WSDL
     * - maxOccurs: 15
     * @var \StructType\RateComment[]
     */
    public $RateComment;
    /**
     * Constructor method for RateComments
     * @uses RateComments::setRateComment()
     * @param \StructType\RateComment[] $rateComment
     */
    public function __construct(array $rateComment = array())
    {
        $this
            ->setRateComment($rateComment);
    }
    /**
     * Get RateComment value
     * @return \StructType\RateComment[]|null
     */
    public function getRateComment()
    {
        return $this->RateComment;
    }
    /**
     * This method is responsible for validating the values passed to the setRateComment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateComment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateCommentForArrayConstraintsFromSetRateComment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateCommentsRateCommentItem) {
            // validation for constraint: itemType
            if (!$rateCommentsRateCommentItem instanceof \StructType\RateComment) {
                $invalidValues[] = is_object($rateCommentsRateCommentItem) ? get_class($rateCommentsRateCommentItem) : sprintf('%s(%s)', gettype($rateCommentsRateCommentItem), var_export($rateCommentsRateCommentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateComment property can only contain items of type \StructType\RateComment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateComment value
     * @throws \InvalidArgumentException
     * @param \StructType\RateComment[] $rateComment
     * @return \StructType\RateComments
     */
    public function setRateComment(array $rateComment = array())
    {
        // validation for constraint: array
        if ('' !== ($rateCommentArrayErrorMessage = self::validateRateCommentForArrayConstraintsFromSetRateComment($rateComment))) {
            throw new \InvalidArgumentException($rateCommentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($rateComment) && count($rateComment) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 15', count($rateComment)), __LINE__);
        }
        $this->RateComment = $rateComment;
        return $this;
    }
    /**
     * Add item to RateComment value
     * @throws \InvalidArgumentException
     * @param \StructType\RateComment $item
     * @return \StructType\RateComments
     */
    public function addToRateComment(\StructType\RateComment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateComment) {
            throw new \InvalidArgumentException(sprintf('The RateComment property can only contain items of type \StructType\RateComment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($this->RateComment) && count($this->RateComment) >= 15) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 15', count($this->RateComment)), __LINE__);
        }
        $this->RateComment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateComments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
