<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailReservationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the information used to fully describe a rail reservation.
 * @subpackage Structs
 */
class RailReservationType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: A confirmation number by which this reservation can be uniquely identified.
     * @var mixed
     */
    public $UniqueID;
    /**
     * The Itinerary
     * @var \StructType\Itinerary
     */
    public $Itinerary;
    /**
     * The PassengerInfo
     * Meta information extracted from the WSDL
     * - documentation: Passenger information for a reservation.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PassengerInfo;
    /**
     * The PaymentRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentRules
     */
    public $PaymentRules;
    /**
     * The Fulfillment
     * Meta information extracted from the WSDL
     * - documentation: Information on the fulfillment of the ticket, that is, e.g. the party that will be issuing the ticket, or has already issued the ticket.
     * - minOccurs: 0
     * @var mixed
     */
    public $Fulfillment;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The LastHoldDate
     * Meta information extracted from the WSDL
     * - documentation: The last date a reservation will be held.
     * - use: optional
     * @var string
     */
    public $LastHoldDate;
    /**
     * Constructor method for RailReservationType
     * @uses RailReservationType::setUniqueID()
     * @uses RailReservationType::setItinerary()
     * @uses RailReservationType::setPassengerInfo()
     * @uses RailReservationType::setPaymentRules()
     * @uses RailReservationType::setFulfillment()
     * @uses RailReservationType::setTPA_Extensions()
     * @uses RailReservationType::setLastHoldDate()
     * @param mixed $uniqueID
     * @param \StructType\Itinerary $itinerary
     * @param mixed[] $passengerInfo
     * @param \StructType\PaymentRules $paymentRules
     * @param mixed $fulfillment
     * @param mixed $tPA_Extensions
     * @param string $lastHoldDate
     */
    public function __construct($uniqueID = null, \StructType\Itinerary $itinerary = null, array $passengerInfo = array(), \StructType\PaymentRules $paymentRules = null, $fulfillment = null, $tPA_Extensions = null, $lastHoldDate = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setItinerary($itinerary)
            ->setPassengerInfo($passengerInfo)
            ->setPaymentRules($paymentRules)
            ->setFulfillment($fulfillment)
            ->setTPA_Extensions($tPA_Extensions)
            ->setLastHoldDate($lastHoldDate);
    }
    /**
     * Get UniqueID value
     * @return mixed|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param mixed $uniqueID
     * @return \StructType\RailReservationType
     */
    public function setUniqueID($uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return \StructType\Itinerary|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param \StructType\Itinerary $itinerary
     * @return \StructType\RailReservationType
     */
    public function setItinerary(\StructType\Itinerary $itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get PassengerInfo value
     * @return mixed[]|null
     */
    public function getPassengerInfo()
    {
        return $this->PassengerInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerInfoForArrayConstraintsFromSetPassengerInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railReservationTypePassengerInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railReservationTypePassengerInfoItem) ? get_class($railReservationTypePassengerInfoItem) : sprintf('%s(%s)', gettype($railReservationTypePassengerInfoItem), var_export($railReservationTypePassengerInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $passengerInfo
     * @return \StructType\RailReservationType
     */
    public function setPassengerInfo(array $passengerInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerInfoArrayErrorMessage = self::validatePassengerInfoForArrayConstraintsFromSetPassengerInfo($passengerInfo))) {
            throw new \InvalidArgumentException($passengerInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($passengerInfo) && count($passengerInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($passengerInfo)), __LINE__);
        }
        $this->PassengerInfo = $passengerInfo;
        return $this;
    }
    /**
     * Add item to PassengerInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailReservationType
     */
    public function addToPassengerInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PassengerInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PassengerInfo) && count($this->PassengerInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PassengerInfo)), __LINE__);
        }
        $this->PassengerInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentRules value
     * @return \StructType\PaymentRules|null
     */
    public function getPaymentRules()
    {
        return $this->PaymentRules;
    }
    /**
     * Set PaymentRules value
     * @param \StructType\PaymentRules $paymentRules
     * @return \StructType\RailReservationType
     */
    public function setPaymentRules(\StructType\PaymentRules $paymentRules = null)
    {
        $this->PaymentRules = $paymentRules;
        return $this;
    }
    /**
     * Get Fulfillment value
     * @return mixed|null
     */
    public function getFulfillment()
    {
        return $this->Fulfillment;
    }
    /**
     * Set Fulfillment value
     * @param mixed $fulfillment
     * @return \StructType\RailReservationType
     */
    public function setFulfillment($fulfillment = null)
    {
        $this->Fulfillment = $fulfillment;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RailReservationType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get LastHoldDate value
     * @return string|null
     */
    public function getLastHoldDate()
    {
        return $this->LastHoldDate;
    }
    /**
     * Set LastHoldDate value
     * @param string $lastHoldDate
     * @return \StructType\RailReservationType
     */
    public function setLastHoldDate($lastHoldDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastHoldDate) && !is_string($lastHoldDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastHoldDate, true), gettype($lastHoldDate)), __LINE__);
        }
        $this->LastHoldDate = $lastHoldDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
