<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailPriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about rail pricing, including price details and price breakdown.
 * @subpackage Structs
 */
class RailPriceType extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Price
     */
    public $Price;
    /**
     * The PriceBreakdown
     * Meta information extracted from the WSDL
     * - documentation: Details about the rail price, including basic fare, adjustments, discounts, ancillary charges, terms and conditions, fees and taxes.
     * @var mixed
     */
    public $PriceBreakdown;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for RailPriceType
     * @uses RailPriceType::setPrice()
     * @uses RailPriceType::setPriceBreakdown()
     * @uses RailPriceType::setTPA_Extensions()
     * @param \StructType\Price $price
     * @param mixed $priceBreakdown
     * @param mixed $tPA_Extensions
     */
    public function __construct(\StructType\Price $price = null, $priceBreakdown = null, $tPA_Extensions = null)
    {
        $this
            ->setPrice($price)
            ->setPriceBreakdown($priceBreakdown)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get Price value
     * @return \StructType\Price|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\Price $price
     * @return \StructType\RailPriceType
     */
    public function setPrice(\StructType\Price $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceBreakdown value
     * @return mixed|null
     */
    public function getPriceBreakdown()
    {
        return $this->PriceBreakdown;
    }
    /**
     * Set PriceBreakdown value
     * @param mixed $priceBreakdown
     * @return \StructType\RailPriceType
     */
    public function setPriceBreakdown($priceBreakdown = null)
    {
        $this->PriceBreakdown = $priceBreakdown;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RailPriceType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailPriceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
