<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailPassengerDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Detailed information about a rail passenger, such as the person's name, contact information, travel profile, etc.
 * @subpackage Structs
 */
class RailPassengerDetailType extends AbstractStructBase
{
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - documentation: Name and document identification for a passenger.
     * @var mixed
     */
    public $Identification;
    /**
     * The ProfileRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProfileRef
     */
    public $ProfileRef;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Email[]
     */
    public $Email;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Address[]
     */
    public $Address;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Date of birth.
     * - use: optional
     * @var string
     */
    public $BirthDate;
    /**
     * Constructor method for RailPassengerDetailType
     * @uses RailPassengerDetailType::setIdentification()
     * @uses RailPassengerDetailType::setProfileRef()
     * @uses RailPassengerDetailType::setTelephone()
     * @uses RailPassengerDetailType::setEmail()
     * @uses RailPassengerDetailType::setAddress()
     * @uses RailPassengerDetailType::setCustLoyalty()
     * @uses RailPassengerDetailType::setBirthDate()
     * @param mixed $identification
     * @param \StructType\ProfileRef $profileRef
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\Email[] $email
     * @param \StructType\Address[] $address
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param string $birthDate
     */
    public function __construct($identification = null, \StructType\ProfileRef $profileRef = null, array $telephone = array(), array $email = array(), array $address = array(), array $custLoyalty = array(), $birthDate = null)
    {
        $this
            ->setIdentification($identification)
            ->setProfileRef($profileRef)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setCustLoyalty($custLoyalty)
            ->setBirthDate($birthDate);
    }
    /**
     * Get Identification value
     * @return mixed|null
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param mixed $identification
     * @return \StructType\RailPassengerDetailType
     */
    public function setIdentification($identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get ProfileRef value
     * @return \StructType\ProfileRef|null
     */
    public function getProfileRef()
    {
        return $this->ProfileRef;
    }
    /**
     * Set ProfileRef value
     * @param \StructType\ProfileRef $profileRef
     * @return \StructType\RailPassengerDetailType
     */
    public function setProfileRef(\StructType\ProfileRef $profileRef = null)
    {
        $this->ProfileRef = $profileRef;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPassengerDetailTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$railPassengerDetailTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($railPassengerDetailTypeTelephoneItem) ? get_class($railPassengerDetailTypeTelephoneItem) : sprintf('%s(%s)', gettype($railPassengerDetailTypeTelephoneItem), var_export($railPassengerDetailTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\RailPassengerDetailType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($telephone) && count($telephone) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\RailPassengerDetailType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->Telephone) && count($this->Telephone) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->Telephone)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPassengerDetailTypeEmailItem) {
            // validation for constraint: itemType
            if (!$railPassengerDetailTypeEmailItem instanceof \StructType\Email) {
                $invalidValues[] = is_object($railPassengerDetailTypeEmailItem) ? get_class($railPassengerDetailTypeEmailItem) : sprintf('%s(%s)', gettype($railPassengerDetailTypeEmailItem), var_export($railPassengerDetailTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email[] $email
     * @return \StructType\RailPassengerDetailType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($email) && count($email) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email $item
     * @return \StructType\RailPassengerDetailType
     */
    public function addToEmail(\StructType\Email $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Email) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Email) && count($this->Email) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Email)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPassengerDetailTypeAddressItem) {
            // validation for constraint: itemType
            if (!$railPassengerDetailTypeAddressItem instanceof \StructType\Address) {
                $invalidValues[] = is_object($railPassengerDetailTypeAddressItem) ? get_class($railPassengerDetailTypeAddressItem) : sprintf('%s(%s)', gettype($railPassengerDetailTypeAddressItem), var_export($railPassengerDetailTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address[] $address
     * @return \StructType\RailPassengerDetailType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($address) && count($address) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address $item
     * @return \StructType\RailPassengerDetailType
     */
    public function addToAddress(\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Address) && count($this->Address) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPassengerDetailTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$railPassengerDetailTypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($railPassengerDetailTypeCustLoyaltyItem) ? get_class($railPassengerDetailTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($railPassengerDetailTypeCustLoyaltyItem), var_export($railPassengerDetailTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\RailPassengerDetailType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($custLoyalty) && count($custLoyalty) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($custLoyalty)), __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\RailPassengerDetailType
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->CustLoyalty) && count($this->CustLoyalty) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->CustLoyalty)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\RailPassengerDetailType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailPassengerDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
