<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailPassengerCategoryDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Category of Passengers with detail information (including name, contact info, travel profile) for passengers make up of a category.
 * @subpackage Structs
 */
class RailPassengerCategoryDetailType extends RailPassengerCategoryType
{
    /**
     * The PassengerDetail
     * Meta information extracted from the WSDL
     * - documentation: Passenger details including loyalty program, personal identification and email address.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PassengerDetail;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A passenger reference.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of passengers in a specific category passenger type.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for RailPassengerCategoryDetailType
     * @uses RailPassengerCategoryDetailType::setPassengerDetail()
     * @uses RailPassengerCategoryDetailType::setRPH()
     * @uses RailPassengerCategoryDetailType::setQuantity()
     * @param mixed[] $passengerDetail
     * @param string $rPH
     * @param int $quantity
     */
    public function __construct(array $passengerDetail = array(), $rPH = null, $quantity = null)
    {
        $this
            ->setPassengerDetail($passengerDetail)
            ->setRPH($rPH)
            ->setQuantity($quantity);
    }
    /**
     * Get PassengerDetail value
     * @return mixed[]|null
     */
    public function getPassengerDetail()
    {
        return $this->PassengerDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerDetailForArrayConstraintsFromSetPassengerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPassengerCategoryDetailTypePassengerDetailItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPassengerCategoryDetailTypePassengerDetailItem) ? get_class($railPassengerCategoryDetailTypePassengerDetailItem) : sprintf('%s(%s)', gettype($railPassengerCategoryDetailTypePassengerDetailItem), var_export($railPassengerCategoryDetailTypePassengerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerDetail property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerDetail value
     * @throws \InvalidArgumentException
     * @param mixed[] $passengerDetail
     * @return \StructType\RailPassengerCategoryDetailType
     */
    public function setPassengerDetail(array $passengerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerDetailArrayErrorMessage = self::validatePassengerDetailForArrayConstraintsFromSetPassengerDetail($passengerDetail))) {
            throw new \InvalidArgumentException($passengerDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($passengerDetail) && count($passengerDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($passengerDetail)), __LINE__);
        }
        $this->PassengerDetail = $passengerDetail;
        return $this;
    }
    /**
     * Add item to PassengerDetail value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPassengerCategoryDetailType
     */
    public function addToPassengerDetail($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PassengerDetail property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PassengerDetail) && count($this->PassengerDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PassengerDetail)), __LINE__);
        }
        $this->PassengerDetail[] = $item;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\RailPassengerCategoryDetailType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\RailPassengerCategoryDetailType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailPassengerCategoryDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
