<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailOriginDestinationSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines rail journey origin and destination location, and time information for the request. Also includes the ability to specify a connection location for the search.
 * @subpackage Structs
 */
class RailOriginDestinationSummaryType extends TravelDateTimeType
{
    /**
     * The OriginLocation
     * @var \StructType\OriginLocation
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \StructType\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The ConnectionLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\ConnectionLocation[]
     */
    public $ConnectionLocation;
    /**
     * The Preferences
     * Meta information extracted from the WSDL
     * - documentation: Operator, transport, amenity and accommodation preferences.
     * - minOccurs: 0
     * @var mixed
     */
    public $Preferences;
    /**
     * Constructor method for RailOriginDestinationSummaryType
     * @uses RailOriginDestinationSummaryType::setOriginLocation()
     * @uses RailOriginDestinationSummaryType::setDestinationLocation()
     * @uses RailOriginDestinationSummaryType::setConnectionLocation()
     * @uses RailOriginDestinationSummaryType::setPreferences()
     * @param \StructType\OriginLocation $originLocation
     * @param \StructType\DestinationLocation $destinationLocation
     * @param \StructType\ConnectionLocation[] $connectionLocation
     * @param mixed $preferences
     */
    public function __construct(\StructType\OriginLocation $originLocation = null, \StructType\DestinationLocation $destinationLocation = null, array $connectionLocation = array(), $preferences = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setConnectionLocation($connectionLocation)
            ->setPreferences($preferences);
    }
    /**
     * Get OriginLocation value
     * @return \StructType\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \StructType\OriginLocation $originLocation
     * @return \StructType\RailOriginDestinationSummaryType
     */
    public function setOriginLocation(\StructType\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \StructType\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \StructType\DestinationLocation $destinationLocation
     * @return \StructType\RailOriginDestinationSummaryType
     */
    public function setDestinationLocation(\StructType\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get ConnectionLocation value
     * @return \StructType\ConnectionLocation[]|null
     */
    public function getConnectionLocation()
    {
        return $this->ConnectionLocation;
    }
    /**
     * This method is responsible for validating the values passed to the setConnectionLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConnectionLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConnectionLocationForArrayConstraintsFromSetConnectionLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railOriginDestinationSummaryTypeConnectionLocationItem) {
            // validation for constraint: itemType
            if (!$railOriginDestinationSummaryTypeConnectionLocationItem instanceof \StructType\ConnectionLocation) {
                $invalidValues[] = is_object($railOriginDestinationSummaryTypeConnectionLocationItem) ? get_class($railOriginDestinationSummaryTypeConnectionLocationItem) : sprintf('%s(%s)', gettype($railOriginDestinationSummaryTypeConnectionLocationItem), var_export($railOriginDestinationSummaryTypeConnectionLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConnectionLocation property can only contain items of type \StructType\ConnectionLocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionLocation[] $connectionLocation
     * @return \StructType\RailOriginDestinationSummaryType
     */
    public function setConnectionLocation(array $connectionLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($connectionLocationArrayErrorMessage = self::validateConnectionLocationForArrayConstraintsFromSetConnectionLocation($connectionLocation))) {
            throw new \InvalidArgumentException($connectionLocationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($connectionLocation) && count($connectionLocation) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($connectionLocation)), __LINE__);
        }
        $this->ConnectionLocation = $connectionLocation;
        return $this;
    }
    /**
     * Add item to ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionLocation $item
     * @return \StructType\RailOriginDestinationSummaryType
     */
    public function addToConnectionLocation(\StructType\ConnectionLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionLocation) {
            throw new \InvalidArgumentException(sprintf('The ConnectionLocation property can only contain items of type \StructType\ConnectionLocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ConnectionLocation) && count($this->ConnectionLocation) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ConnectionLocation)), __LINE__);
        }
        $this->ConnectionLocation[] = $item;
        return $this;
    }
    /**
     * Get Preferences value
     * @return mixed|null
     */
    public function getPreferences()
    {
        return $this->Preferences;
    }
    /**
     * Set Preferences value
     * @param mixed $preferences
     * @return \StructType\RailOriginDestinationSummaryType
     */
    public function setPreferences($preferences = null)
    {
        $this->Preferences = $preferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailOriginDestinationSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
