<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailOriginDestinationInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines rail journey origin and destination location, and time information for the request. Also includes the ability to specify a connection location for the search.
 * @subpackage Structs
 */
class RailOriginDestinationInformationType extends TravelDateTimeType
{
    /**
     * The OriginLocation
     * @var \StructType\OriginLocation
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \StructType\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The ConnectionLocations
     * Meta information extracted from the WSDL
     * - documentation: Travel Connection location and other information.
     * - minOccurs: 0
     * @var mixed
     */
    public $ConnectionLocations;
    /**
     * Constructor method for RailOriginDestinationInformationType
     * @uses RailOriginDestinationInformationType::setOriginLocation()
     * @uses RailOriginDestinationInformationType::setDestinationLocation()
     * @uses RailOriginDestinationInformationType::setConnectionLocations()
     * @param \StructType\OriginLocation $originLocation
     * @param \StructType\DestinationLocation $destinationLocation
     * @param mixed $connectionLocations
     */
    public function __construct(\StructType\OriginLocation $originLocation = null, \StructType\DestinationLocation $destinationLocation = null, $connectionLocations = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setConnectionLocations($connectionLocations);
    }
    /**
     * Get OriginLocation value
     * @return \StructType\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \StructType\OriginLocation $originLocation
     * @return \StructType\RailOriginDestinationInformationType
     */
    public function setOriginLocation(\StructType\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \StructType\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \StructType\DestinationLocation $destinationLocation
     * @return \StructType\RailOriginDestinationInformationType
     */
    public function setDestinationLocation(\StructType\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get ConnectionLocations value
     * @return mixed|null
     */
    public function getConnectionLocations()
    {
        return $this->ConnectionLocations;
    }
    /**
     * Set ConnectionLocations value
     * @param mixed $connectionLocations
     * @return \StructType\RailOriginDestinationInformationType
     */
    public function setConnectionLocations($connectionLocations = null)
    {
        $this->ConnectionLocations = $connectionLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailOriginDestinationInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
