<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailFareType StructType
 * Meta information extracted from the WSDL
 * - documentation: Rail fare and associated fare rules and terms and conditions.
 * @subpackage Structs
 */
class RailFareType extends AbstractStructBase
{
    /**
     * The BasicFare
     * @var \StructType\BasicFare
     */
    public $BasicFare;
    /**
     * The TermAndCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\TermAndCondition[]
     */
    public $TermAndCondition;
    /**
     * Constructor method for RailFareType
     * @uses RailFareType::setBasicFare()
     * @uses RailFareType::setTermAndCondition()
     * @param \StructType\BasicFare $basicFare
     * @param \StructType\TermAndCondition[] $termAndCondition
     */
    public function __construct(\StructType\BasicFare $basicFare = null, array $termAndCondition = array())
    {
        $this
            ->setBasicFare($basicFare)
            ->setTermAndCondition($termAndCondition);
    }
    /**
     * Get BasicFare value
     * @return \StructType\BasicFare|null
     */
    public function getBasicFare()
    {
        return $this->BasicFare;
    }
    /**
     * Set BasicFare value
     * @param \StructType\BasicFare $basicFare
     * @return \StructType\RailFareType
     */
    public function setBasicFare(\StructType\BasicFare $basicFare = null)
    {
        $this->BasicFare = $basicFare;
        return $this;
    }
    /**
     * Get TermAndCondition value
     * @return \StructType\TermAndCondition[]|null
     */
    public function getTermAndCondition()
    {
        return $this->TermAndCondition;
    }
    /**
     * This method is responsible for validating the values passed to the setTermAndCondition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTermAndCondition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTermAndConditionForArrayConstraintsFromSetTermAndCondition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railFareTypeTermAndConditionItem) {
            // validation for constraint: itemType
            if (!$railFareTypeTermAndConditionItem instanceof \StructType\TermAndCondition) {
                $invalidValues[] = is_object($railFareTypeTermAndConditionItem) ? get_class($railFareTypeTermAndConditionItem) : sprintf('%s(%s)', gettype($railFareTypeTermAndConditionItem), var_export($railFareTypeTermAndConditionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TermAndCondition property can only contain items of type \StructType\TermAndCondition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TermAndCondition value
     * @throws \InvalidArgumentException
     * @param \StructType\TermAndCondition[] $termAndCondition
     * @return \StructType\RailFareType
     */
    public function setTermAndCondition(array $termAndCondition = array())
    {
        // validation for constraint: array
        if ('' !== ($termAndConditionArrayErrorMessage = self::validateTermAndConditionForArrayConstraintsFromSetTermAndCondition($termAndCondition))) {
            throw new \InvalidArgumentException($termAndConditionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($termAndCondition) && count($termAndCondition) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($termAndCondition)), __LINE__);
        }
        $this->TermAndCondition = $termAndCondition;
        return $this;
    }
    /**
     * Add item to TermAndCondition value
     * @throws \InvalidArgumentException
     * @param \StructType\TermAndCondition $item
     * @return \StructType\RailFareType
     */
    public function addToTermAndCondition(\StructType\TermAndCondition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TermAndCondition) {
            throw new \InvalidArgumentException(sprintf('The TermAndCondition property can only contain items of type \StructType\TermAndCondition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TermAndCondition) && count($this->TermAndCondition) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TermAndCondition)), __LINE__);
        }
        $this->TermAndCondition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
