<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailConnectionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines connection locations and preference levels, minimum connection times and if the location is specified for stopping or changing.
 * @subpackage Structs
 */
class RailConnectionType extends AbstractStructBase
{
    /**
     * The ConnectionLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\ConnectionLocation[]
     */
    public $ConnectionLocation;
    /**
     * Constructor method for RailConnectionType
     * @uses RailConnectionType::setConnectionLocation()
     * @param \StructType\ConnectionLocation[] $connectionLocation
     */
    public function __construct(array $connectionLocation = array())
    {
        $this
            ->setConnectionLocation($connectionLocation);
    }
    /**
     * Get ConnectionLocation value
     * @return \StructType\ConnectionLocation[]|null
     */
    public function getConnectionLocation()
    {
        return $this->ConnectionLocation;
    }
    /**
     * This method is responsible for validating the values passed to the setConnectionLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConnectionLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConnectionLocationForArrayConstraintsFromSetConnectionLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railConnectionTypeConnectionLocationItem) {
            // validation for constraint: itemType
            if (!$railConnectionTypeConnectionLocationItem instanceof \StructType\ConnectionLocation) {
                $invalidValues[] = is_object($railConnectionTypeConnectionLocationItem) ? get_class($railConnectionTypeConnectionLocationItem) : sprintf('%s(%s)', gettype($railConnectionTypeConnectionLocationItem), var_export($railConnectionTypeConnectionLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConnectionLocation property can only contain items of type \StructType\ConnectionLocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionLocation[] $connectionLocation
     * @return \StructType\RailConnectionType
     */
    public function setConnectionLocation(array $connectionLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($connectionLocationArrayErrorMessage = self::validateConnectionLocationForArrayConstraintsFromSetConnectionLocation($connectionLocation))) {
            throw new \InvalidArgumentException($connectionLocationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($connectionLocation) && count($connectionLocation) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($connectionLocation)), __LINE__);
        }
        $this->ConnectionLocation = $connectionLocation;
        return $this;
    }
    /**
     * Add item to ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionLocation $item
     * @return \StructType\RailConnectionType
     */
    public function addToConnectionLocation(\StructType\ConnectionLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionLocation) {
            throw new \InvalidArgumentException(sprintf('The ConnectionLocation property can only contain items of type \StructType\ConnectionLocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->ConnectionLocation) && count($this->ConnectionLocation) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->ConnectionLocation)), __LINE__);
        }
        $this->ConnectionLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailConnectionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
