<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailAvailScheduleQueryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines rail availability and schedule search criteria, including origin-destination information and train number and network code.
 * @subpackage Structs
 */
class RailAvailScheduleQueryType extends AbstractStructBase
{
    /**
     * The OriginDestinationInformation
     * Meta information extracted from the WSDL
     * - documentation: Information on the locations between which schedules and/or availability are to be checked.
     * @var mixed
     */
    public $OriginDestinationInformation;
    /**
     * The RailSearchCriteria
     * Meta information extracted from the WSDL
     * - documentation: The rail search criteria which may be a train number/ network code combination or just a network code.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RailSearchCriteria;
    /**
     * The MaxConnections
     * Meta information extracted from the WSDL
     * - documentation: Indicates the maximum number of connections (if 0, then direct).
     * - use: optional
     * @var int
     */
    public $MaxConnections;
    /**
     * The TrainTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The type of train to include in the response. Refer to OpenTravel code list Train Type Code (TTC).
     * - use: optional
     * @var string
     */
    public $TrainTypeCode;
    /**
     * Constructor method for RailAvailScheduleQueryType
     * @uses RailAvailScheduleQueryType::setOriginDestinationInformation()
     * @uses RailAvailScheduleQueryType::setRailSearchCriteria()
     * @uses RailAvailScheduleQueryType::setMaxConnections()
     * @uses RailAvailScheduleQueryType::setTrainTypeCode()
     * @param mixed $originDestinationInformation
     * @param mixed[] $railSearchCriteria
     * @param int $maxConnections
     * @param string $trainTypeCode
     */
    public function __construct($originDestinationInformation = null, array $railSearchCriteria = array(), $maxConnections = null, $trainTypeCode = null)
    {
        $this
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setRailSearchCriteria($railSearchCriteria)
            ->setMaxConnections($maxConnections)
            ->setTrainTypeCode($trainTypeCode);
    }
    /**
     * Get OriginDestinationInformation value
     * @return mixed|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @param mixed $originDestinationInformation
     * @return \StructType\RailAvailScheduleQueryType
     */
    public function setOriginDestinationInformation($originDestinationInformation = null)
    {
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Get RailSearchCriteria value
     * @return mixed[]|null
     */
    public function getRailSearchCriteria()
    {
        return $this->RailSearchCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setRailSearchCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRailSearchCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRailSearchCriteriaForArrayConstraintsFromSetRailSearchCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railAvailScheduleQueryTypeRailSearchCriteriaItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railAvailScheduleQueryTypeRailSearchCriteriaItem) ? get_class($railAvailScheduleQueryTypeRailSearchCriteriaItem) : sprintf('%s(%s)', gettype($railAvailScheduleQueryTypeRailSearchCriteriaItem), var_export($railAvailScheduleQueryTypeRailSearchCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RailSearchCriteria property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RailSearchCriteria value
     * @throws \InvalidArgumentException
     * @param mixed[] $railSearchCriteria
     * @return \StructType\RailAvailScheduleQueryType
     */
    public function setRailSearchCriteria(array $railSearchCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($railSearchCriteriaArrayErrorMessage = self::validateRailSearchCriteriaForArrayConstraintsFromSetRailSearchCriteria($railSearchCriteria))) {
            throw new \InvalidArgumentException($railSearchCriteriaArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($railSearchCriteria) && count($railSearchCriteria) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($railSearchCriteria)), __LINE__);
        }
        $this->RailSearchCriteria = $railSearchCriteria;
        return $this;
    }
    /**
     * Add item to RailSearchCriteria value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailAvailScheduleQueryType
     */
    public function addToRailSearchCriteria($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RailSearchCriteria property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->RailSearchCriteria) && count($this->RailSearchCriteria) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->RailSearchCriteria)), __LINE__);
        }
        $this->RailSearchCriteria[] = $item;
        return $this;
    }
    /**
     * Get MaxConnections value
     * @return int|null
     */
    public function getMaxConnections()
    {
        return $this->MaxConnections;
    }
    /**
     * Set MaxConnections value
     * @param int $maxConnections
     * @return \StructType\RailAvailScheduleQueryType
     */
    public function setMaxConnections($maxConnections = null)
    {
        // validation for constraint: int
        if (!is_null($maxConnections) && !(is_int($maxConnections) || ctype_digit($maxConnections))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxConnections, true), gettype($maxConnections)), __LINE__);
        }
        $this->MaxConnections = $maxConnections;
        return $this;
    }
    /**
     * Get TrainTypeCode value
     * @return string|null
     */
    public function getTrainTypeCode()
    {
        return $this->TrainTypeCode;
    }
    /**
     * Set TrainTypeCode value
     * @param string $trainTypeCode
     * @return \StructType\RailAvailScheduleQueryType
     */
    public function setTrainTypeCode($trainTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($trainTypeCode) && !is_string($trainTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trainTypeCode, true), gettype($trainTypeCode)), __LINE__);
        }
        $this->TrainTypeCode = $trainTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailAvailScheduleQueryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
