<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailAccommDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specific traveler requested accommodation information, including class and type, and associated accommodation attributes such as seat, berth and compartment number, position, direction and adjacent seating preferences.
 * @subpackage Structs
 */
class RailAccommDetailType extends AbstractStructBase
{
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - documentation: Seat accommodation information, including the seat type and associated seat attributes, such as seat number, position and direction.
     * - choice: Seat | Berth
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var mixed
     */
    public $Seat;
    /**
     * The Berth
     * Meta information extracted from the WSDL
     * - documentation: Berth accommodation information, including berth type and associated berth attributes, such as berth number and position.
     * - choice: Seat | Berth
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var mixed
     */
    public $Berth;
    /**
     * The Class
     * Meta information extracted from the WSDL
     * - documentation: A commonly offered accommodation class, such as first class and second class.
     * - minOccurs: 0
     * @var mixed
     */
    public $Class;
    /**
     * The Compartment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Compartment
     */
    public $Compartment;
    /**
     * The Car
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Car
     */
    public $Car;
    /**
     * The Deck
     * Meta information extracted from the WSDL
     * - documentation: The deck level of the accommodation, such as Regular One Level and Lower.
     * - use: optional
     * @var string
     */
    public $Deck;
    /**
     * Constructor method for RailAccommDetailType
     * @uses RailAccommDetailType::setSeat()
     * @uses RailAccommDetailType::setBerth()
     * @uses RailAccommDetailType::setClass()
     * @uses RailAccommDetailType::setCompartment()
     * @uses RailAccommDetailType::setCar()
     * @uses RailAccommDetailType::setDeck()
     * @param mixed $seat
     * @param mixed $berth
     * @param mixed $class
     * @param \StructType\Compartment $compartment
     * @param \StructType\Car $car
     * @param string $deck
     */
    public function __construct($seat = null, $berth = null, $class = null, \StructType\Compartment $compartment = null, \StructType\Car $car = null, $deck = null)
    {
        $this
            ->setSeat($seat)
            ->setBerth($berth)
            ->setClass($class)
            ->setCompartment($compartment)
            ->setCar($car)
            ->setDeck($deck);
    }
    /**
     * Get Seat value
     * @return mixed|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeat method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeatForChoiceConstraintsFromSetSeat($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Berth',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Seat can\'t be set as the property %s is already set. Only one property must be set among these properties: Seat, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Seat value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $seat
     * @return \StructType\RailAccommDetailType
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: choice(Seat, Berth)
        if ('' !== ($seatChoiceErrorMessage = self::validateSeatForChoiceConstraintsFromSetSeat($seat))) {
            throw new \InvalidArgumentException($seatChoiceErrorMessage, __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get Berth value
     * @return mixed|null
     */
    public function getBerth()
    {
        return isset($this->Berth) ? $this->Berth : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBerth method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBerth method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBerthForChoiceConstraintsFromSetBerth($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Seat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Berth can\'t be set as the property %s is already set. Only one property must be set among these properties: Berth, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Berth value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $berth
     * @return \StructType\RailAccommDetailType
     */
    public function setBerth($berth = null)
    {
        // validation for constraint: choice(Seat, Berth)
        if ('' !== ($berthChoiceErrorMessage = self::validateBerthForChoiceConstraintsFromSetBerth($berth))) {
            throw new \InvalidArgumentException($berthChoiceErrorMessage, __LINE__);
        }
        if (is_null($berth) || (is_array($berth) && empty($berth))) {
            unset($this->Berth);
        } else {
            $this->Berth = $berth;
        }
        return $this;
    }
    /**
     * Get Class value
     * @return mixed|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param mixed $class
     * @return \StructType\RailAccommDetailType
     */
    public function setClass($class = null)
    {
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Compartment value
     * @return \StructType\Compartment|null
     */
    public function getCompartment()
    {
        return $this->Compartment;
    }
    /**
     * Set Compartment value
     * @param \StructType\Compartment $compartment
     * @return \StructType\RailAccommDetailType
     */
    public function setCompartment(\StructType\Compartment $compartment = null)
    {
        $this->Compartment = $compartment;
        return $this;
    }
    /**
     * Get Car value
     * @return \StructType\Car|null
     */
    public function getCar()
    {
        return $this->Car;
    }
    /**
     * Set Car value
     * @param \StructType\Car $car
     * @return \StructType\RailAccommDetailType
     */
    public function setCar(\StructType\Car $car = null)
    {
        $this->Car = $car;
        return $this;
    }
    /**
     * Get Deck value
     * @return string|null
     */
    public function getDeck()
    {
        return $this->Deck;
    }
    /**
     * Set Deck value
     * @uses \EnumType\DeckType::valueIsValid()
     * @uses \EnumType\DeckType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deck
     * @return \StructType\RailAccommDetailType
     */
    public function setDeck($deck = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeckType::valueIsValid($deck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeckType', is_array($deck) ? implode(', ', $deck) : var_export($deck, true), implode(', ', \EnumType\DeckType::getValidValues())), __LINE__);
        }
        $this->Deck = $deck;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailAccommDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
