<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Queues StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for queue information.
 * @subpackage Structs
 */
class Queues extends AbstractStructBase
{
    /**
     * The Queue
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\Queue[]
     */
    public $Queue;
    /**
     * Constructor method for Queues
     * @uses Queues::setQueue()
     * @param \StructType\Queue[] $queue
     */
    public function __construct(array $queue = array())
    {
        $this
            ->setQueue($queue);
    }
    /**
     * Get Queue value
     * @return \StructType\Queue[]|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * This method is responsible for validating the values passed to the setQueue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQueueForArrayConstraintsFromSetQueue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queuesQueueItem) {
            // validation for constraint: itemType
            if (!$queuesQueueItem instanceof \StructType\Queue) {
                $invalidValues[] = is_object($queuesQueueItem) ? get_class($queuesQueueItem) : sprintf('%s(%s)', gettype($queuesQueueItem), var_export($queuesQueueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Queue property can only contain items of type \StructType\Queue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Queue value
     * @throws \InvalidArgumentException
     * @param \StructType\Queue[] $queue
     * @return \StructType\Queues
     */
    public function setQueue(array $queue = array())
    {
        // validation for constraint: array
        if ('' !== ($queueArrayErrorMessage = self::validateQueueForArrayConstraintsFromSetQueue($queue))) {
            throw new \InvalidArgumentException($queueArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($queue) && count($queue) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($queue)), __LINE__);
        }
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Add item to Queue value
     * @throws \InvalidArgumentException
     * @param \StructType\Queue $item
     * @return \StructType\Queues
     */
    public function addToQueue(\StructType\Queue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Queue) {
            throw new \InvalidArgumentException(sprintf('The Queue property can only contain items of type \StructType\Queue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Queue) && count($this->Queue) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Queue)), __LINE__);
        }
        $this->Queue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Queues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
