<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Qualifiers StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax qualifier information. | Fee qualifier(s).
 * @subpackage Structs
 */
class Qualifiers extends AbstractStructBase
{
    /**
     * The ChargeUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ChargeUnit
     */
    public $ChargeUnit;
    /**
     * The EffectiveDateTime
     * Meta information extracted from the WSDL
     * - documentation: Example: 2013-01-13 | Fee starting date/ time.
     * - use: optional
     * @var string
     */
    public $EffectiveDateTime;
    /**
     * The ExpireDateTime
     * Meta information extracted from the WSDL
     * - documentation: Example: 2013-01-16 | Fee ending date/ time.
     * - use: optional
     * @var string
     */
    public $ExpireDateTime;
    /**
     * The MaxAge
     * Meta information extracted from the WSDL
     * - documentation: Example: 62 | Maximum age of applicability.
     * - use: optional
     * @var int
     */
    public $MaxAge;
    /**
     * The MinAge
     * Meta information extracted from the WSDL
     * - documentation: Example: 21 | Minimum age of applicability.
     * - use: optional
     * @var int
     */
    public $MinAge;
    /**
     * Constructor method for Qualifiers
     * @uses Qualifiers::setChargeUnit()
     * @uses Qualifiers::setEffectiveDateTime()
     * @uses Qualifiers::setExpireDateTime()
     * @uses Qualifiers::setMaxAge()
     * @uses Qualifiers::setMinAge()
     * @param \StructType\ChargeUnit $chargeUnit
     * @param string $effectiveDateTime
     * @param string $expireDateTime
     * @param int $maxAge
     * @param int $minAge
     */
    public function __construct(\StructType\ChargeUnit $chargeUnit = null, $effectiveDateTime = null, $expireDateTime = null, $maxAge = null, $minAge = null)
    {
        $this
            ->setChargeUnit($chargeUnit)
            ->setEffectiveDateTime($effectiveDateTime)
            ->setExpireDateTime($expireDateTime)
            ->setMaxAge($maxAge)
            ->setMinAge($minAge);
    }
    /**
     * Get ChargeUnit value
     * @return \StructType\ChargeUnit|null
     */
    public function getChargeUnit()
    {
        return $this->ChargeUnit;
    }
    /**
     * Set ChargeUnit value
     * @param \StructType\ChargeUnit $chargeUnit
     * @return \StructType\Qualifiers
     */
    public function setChargeUnit(\StructType\ChargeUnit $chargeUnit = null)
    {
        $this->ChargeUnit = $chargeUnit;
        return $this;
    }
    /**
     * Get EffectiveDateTime value
     * @return string|null
     */
    public function getEffectiveDateTime()
    {
        return $this->EffectiveDateTime;
    }
    /**
     * Set EffectiveDateTime value
     * @param string $effectiveDateTime
     * @return \StructType\Qualifiers
     */
    public function setEffectiveDateTime($effectiveDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDateTime) && !is_string($effectiveDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDateTime, true), gettype($effectiveDateTime)), __LINE__);
        }
        $this->EffectiveDateTime = $effectiveDateTime;
        return $this;
    }
    /**
     * Get ExpireDateTime value
     * @return string|null
     */
    public function getExpireDateTime()
    {
        return $this->ExpireDateTime;
    }
    /**
     * Set ExpireDateTime value
     * @param string $expireDateTime
     * @return \StructType\Qualifiers
     */
    public function setExpireDateTime($expireDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($expireDateTime) && !is_string($expireDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDateTime, true), gettype($expireDateTime)), __LINE__);
        }
        $this->ExpireDateTime = $expireDateTime;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\Qualifiers
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\Qualifiers
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Qualifiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
