<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Promotion StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the date range for the promotion. | A hotel package or promotion.
 * @subpackage Structs
 */
class Promotion extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description of a promotion.
     * - minOccurs: 0
     * @var mixed
     */
    public $Description;
    /**
     * The PkgOrPromotion
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PkgOrPromotion;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: A code that identifies the specific promotion or package.
     * - use: optional
     * @var string
     */
    public $PromotionCode;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: The type of the package or promotion. Refer to OpenTravel Code List Package Type (PKG).
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - documentation: The title of the package or promotion.
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The MinLOS
     * Meta information extracted from the WSDL
     * - documentation: The minimum (day) length of stay for the promotion.
     * - use: optional
     * @var int
     */
    public $MinLOS;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - documentation: Remarks regarding the promotion.
     * - use: optional
     * @var string
     */
    public $Remarks;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - documentation: The order in which the promotion should be displayed.
     * - use: optional
     * @var int
     */
    public $SortOrder;
    /**
     * Constructor method for Promotion
     * @uses Promotion::setDescription()
     * @uses Promotion::setPkgOrPromotion()
     * @uses Promotion::setPromotionCode()
     * @uses Promotion::setType()
     * @uses Promotion::setTitle()
     * @uses Promotion::setMinLOS()
     * @uses Promotion::setRemarks()
     * @uses Promotion::setSortOrder()
     * @param mixed $description
     * @param string $pkgOrPromotion
     * @param string $promotionCode
     * @param string $type
     * @param string $title
     * @param int $minLOS
     * @param string $remarks
     * @param int $sortOrder
     */
    public function __construct($description = null, $pkgOrPromotion = null, $promotionCode = null, $type = null, $title = null, $minLOS = null, $remarks = null, $sortOrder = null)
    {
        $this
            ->setDescription($description)
            ->setPkgOrPromotion($pkgOrPromotion)
            ->setPromotionCode($promotionCode)
            ->setType($type)
            ->setTitle($title)
            ->setMinLOS($minLOS)
            ->setRemarks($remarks)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get Description value
     * @return mixed|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param mixed $description
     * @return \StructType\Promotion
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PkgOrPromotion value
     * @return string|null
     */
    public function getPkgOrPromotion()
    {
        return $this->PkgOrPromotion;
    }
    /**
     * Set PkgOrPromotion value
     * @param string $pkgOrPromotion
     * @return \StructType\Promotion
     */
    public function setPkgOrPromotion($pkgOrPromotion = null)
    {
        // validation for constraint: string
        if (!is_null($pkgOrPromotion) && !is_string($pkgOrPromotion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkgOrPromotion, true), gettype($pkgOrPromotion)), __LINE__);
        }
        $this->PkgOrPromotion = $pkgOrPromotion;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\Promotion
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Promotion
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Promotion
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get MinLOS value
     * @return int|null
     */
    public function getMinLOS()
    {
        return $this->MinLOS;
    }
    /**
     * Set MinLOS value
     * @param int $minLOS
     * @return \StructType\Promotion
     */
    public function setMinLOS($minLOS = null)
    {
        // validation for constraint: int
        if (!is_null($minLOS) && !(is_int($minLOS) || ctype_digit($minLOS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minLOS, true), gettype($minLOS)), __LINE__);
        }
        $this->MinLOS = $minLOS;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\Promotion
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\Promotion
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !(is_int($sortOrder) || ctype_digit($sortOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sortOrder, true), gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Promotion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
