<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Profiles StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of profiles.
 * @subpackage Structs
 */
class Profiles extends AbstractStructBase
{
    /**
     * The Profile
     * Meta information extracted from the WSDL
     * - documentation: Profile associated with the Viewership, i.e. the information required to identify the company, agency, etc that is allowed to view the information.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $Profile;
    /**
     * Constructor method for Profiles
     * @uses Profiles::setProfile()
     * @param mixed[] $profile
     */
    public function __construct(array $profile = array())
    {
        $this
            ->setProfile($profile);
    }
    /**
     * Get Profile value
     * @return mixed[]|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * This method is responsible for validating the values passed to the setProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileForArrayConstraintsFromSetProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profilesProfileItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($profilesProfileItem) ? get_class($profilesProfileItem) : sprintf('%s(%s)', gettype($profilesProfileItem), var_export($profilesProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Profile property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Profile value
     * @throws \InvalidArgumentException
     * @param mixed[] $profile
     * @return \StructType\Profiles
     */
    public function setProfile(array $profile = array())
    {
        // validation for constraint: array
        if ('' !== ($profileArrayErrorMessage = self::validateProfileForArrayConstraintsFromSetProfile($profile))) {
            throw new \InvalidArgumentException($profileArrayErrorMessage, __LINE__);
        }
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Add item to Profile value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Profiles
     */
    public function addToProfile($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Profile property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Profile[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Profiles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
