<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Creation date time, creator ID, last modification date time and last modifier ID. | Used to specify a profile type. | Used to indicate whether information can be shared. | Root element for profile content. | Profile types associated
 * with the viewership, i.e, the types of profiles allowed to view this information. Please refer the OpenTravel Code List PRT.
 * - type: OTA_CodeType
 * - use: optional
 * @subpackage Structs
 */
class ProfileType extends AbstractStructBase
{
    /**
     * The Accesses
     * Meta information extracted from the WSDL
     * - documentation: A collection of actions taken on a record.
     * - minOccurs: 0
     * @var mixed
     */
    public $Accesses;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - documentation: Detailed customer information for this profile.
     * - minOccurs: 0
     * @var mixed
     */
    public $Customer;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\UserID[]
     */
    public $UserID;
    /**
     * The PrefCollections
     * Meta information extracted from the WSDL
     * - documentation: A collection of preference collections.
     * - minOccurs: 0
     * @var mixed
     */
    public $PrefCollections;
    /**
     * The CompanyInfo
     * Meta information extracted from the WSDL
     * - documentation: Company information related to the profile.
     * - minOccurs: 0
     * @var mixed
     */
    public $CompanyInfo;
    /**
     * The Affiliations
     * Meta information extracted from the WSDL
     * - documentation: Affiliation information related to the profile.
     * - minOccurs: 0
     * @var mixed
     */
    public $Affiliations;
    /**
     * The Agreements
     * Meta information extracted from the WSDL
     * - documentation: Agreement information related to the profile.
     * - minOccurs: 0
     * @var mixed
     */
    public $Agreements;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Comments
     */
    public $Comments;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: This is a reference placeholder, used as an index for this guest in this reservation.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the profile. Refer to OpenTravel Code List Profile Status Code (PST).
     * - use: optional
     * @var list
     */
    public $StatusCode;
    /**
     * Constructor method for ProfileType
     * @uses ProfileType::setAccesses()
     * @uses ProfileType::setCustomer()
     * @uses ProfileType::setUserID()
     * @uses ProfileType::setPrefCollections()
     * @uses ProfileType::setCompanyInfo()
     * @uses ProfileType::setAffiliations()
     * @uses ProfileType::setAgreements()
     * @uses ProfileType::setComments()
     * @uses ProfileType::setTPA_Extensions()
     * @uses ProfileType::setRPH()
     * @uses ProfileType::setStatusCode()
     * @param mixed $accesses
     * @param mixed $customer
     * @param \StructType\UserID[] $userID
     * @param mixed $prefCollections
     * @param mixed $companyInfo
     * @param mixed $affiliations
     * @param mixed $agreements
     * @param \StructType\Comments $comments
     * @param mixed $tPA_Extensions
     * @param string $rPH
     * @param list $statusCode
     */
    public function __construct($accesses = null, $customer = null, array $userID = array(), $prefCollections = null, $companyInfo = null, $affiliations = null, $agreements = null, \StructType\Comments $comments = null, $tPA_Extensions = null, $rPH = null, list $statusCode = null)
    {
        $this
            ->setAccesses($accesses)
            ->setCustomer($customer)
            ->setUserID($userID)
            ->setPrefCollections($prefCollections)
            ->setCompanyInfo($companyInfo)
            ->setAffiliations($affiliations)
            ->setAgreements($agreements)
            ->setComments($comments)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRPH($rPH)
            ->setStatusCode($statusCode);
    }
    /**
     * Get Accesses value
     * @return mixed|null
     */
    public function getAccesses()
    {
        return $this->Accesses;
    }
    /**
     * Set Accesses value
     * @param mixed $accesses
     * @return \StructType\ProfileType
     */
    public function setAccesses($accesses = null)
    {
        $this->Accesses = $accesses;
        return $this;
    }
    /**
     * Get Customer value
     * @return mixed|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param mixed $customer
     * @return \StructType\ProfileType
     */
    public function setCustomer($customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get UserID value
     * @return \StructType\UserID[]|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * This method is responsible for validating the values passed to the setUserID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserIDForArrayConstraintsFromSetUserID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileTypeUserIDItem) {
            // validation for constraint: itemType
            if (!$profileTypeUserIDItem instanceof \StructType\UserID) {
                $invalidValues[] = is_object($profileTypeUserIDItem) ? get_class($profileTypeUserIDItem) : sprintf('%s(%s)', gettype($profileTypeUserIDItem), var_export($profileTypeUserIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserID property can only contain items of type \StructType\UserID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserID value
     * @throws \InvalidArgumentException
     * @param \StructType\UserID[] $userID
     * @return \StructType\ProfileType
     */
    public function setUserID(array $userID = array())
    {
        // validation for constraint: array
        if ('' !== ($userIDArrayErrorMessage = self::validateUserIDForArrayConstraintsFromSetUserID($userID))) {
            throw new \InvalidArgumentException($userIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($userID) && count($userID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Add item to UserID value
     * @throws \InvalidArgumentException
     * @param \StructType\UserID $item
     * @return \StructType\ProfileType
     */
    public function addToUserID(\StructType\UserID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserID) {
            throw new \InvalidArgumentException(sprintf('The UserID property can only contain items of type \StructType\UserID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->UserID) && count($this->UserID) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->UserID)), __LINE__);
        }
        $this->UserID[] = $item;
        return $this;
    }
    /**
     * Get PrefCollections value
     * @return mixed|null
     */
    public function getPrefCollections()
    {
        return $this->PrefCollections;
    }
    /**
     * Set PrefCollections value
     * @param mixed $prefCollections
     * @return \StructType\ProfileType
     */
    public function setPrefCollections($prefCollections = null)
    {
        $this->PrefCollections = $prefCollections;
        return $this;
    }
    /**
     * Get CompanyInfo value
     * @return mixed|null
     */
    public function getCompanyInfo()
    {
        return $this->CompanyInfo;
    }
    /**
     * Set CompanyInfo value
     * @param mixed $companyInfo
     * @return \StructType\ProfileType
     */
    public function setCompanyInfo($companyInfo = null)
    {
        $this->CompanyInfo = $companyInfo;
        return $this;
    }
    /**
     * Get Affiliations value
     * @return mixed|null
     */
    public function getAffiliations()
    {
        return $this->Affiliations;
    }
    /**
     * Set Affiliations value
     * @param mixed $affiliations
     * @return \StructType\ProfileType
     */
    public function setAffiliations($affiliations = null)
    {
        $this->Affiliations = $affiliations;
        return $this;
    }
    /**
     * Get Agreements value
     * @return mixed|null
     */
    public function getAgreements()
    {
        return $this->Agreements;
    }
    /**
     * Set Agreements value
     * @param mixed $agreements
     * @return \StructType\ProfileType
     */
    public function setAgreements($agreements = null)
    {
        $this->Agreements = $agreements;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\Comments|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\Comments $comments
     * @return \StructType\ProfileType
     */
    public function setComments(\StructType\Comments $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\ProfileType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ProfileType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return list|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param list $statusCode
     * @return \StructType\ProfileType
     */
    public function setStatusCode(list $statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
