<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Individual offer pricing if multiple offers and/or passengers are accommodated in the offer pricing.
 * @subpackage Structs
 */
class PricingDetail extends AbstractStructBase
{
    /**
     * The TaxInfo
     * Meta information extracted from the WSDL
     * - documentation: Tax(es) that were applied to this pricing.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TaxInfo;
    /**
     * The RedemptionPoints
     * Meta information extracted from the WSDL
     * - documentation: Redemption pricing information if all or a portion of this offer may be paid using points.
     * - minOccurs: 0
     * @var mixed
     */
    public $RedemptionPoints;
    /**
     * The TravelerRPH
     * Meta information extracted from the WSDL
     * - documentation: Associated traveler.
     * - use: optional
     * @var string
     */
    public $TravelerRPH;
    /**
     * The OfferPricingRefID
     * Meta information extracted from the WSDL
     * - documentation: A reference to a set of offer pricing.
     * - use: optional
     * @var string
     */
    public $OfferPricingRefID;
    /**
     * The PreTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount charged for the ancillary product that typically does NOT include taxes.
     * - use: optional
     * @var float
     */
    public $PreTaxAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: The tax amount.
     * - use: optional
     * @var float
     */
    public $TaxAmount;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The total amount charged for the ancillary product including any applicable tax(es).
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for PricingDetail
     * @uses PricingDetail::setTaxInfo()
     * @uses PricingDetail::setRedemptionPoints()
     * @uses PricingDetail::setTravelerRPH()
     * @uses PricingDetail::setOfferPricingRefID()
     * @uses PricingDetail::setPreTaxAmount()
     * @uses PricingDetail::setTaxAmount()
     * @uses PricingDetail::setAmount()
     * @param mixed[] $taxInfo
     * @param mixed $redemptionPoints
     * @param string $travelerRPH
     * @param string $offerPricingRefID
     * @param float $preTaxAmount
     * @param float $taxAmount
     * @param float $amount
     */
    public function __construct(array $taxInfo = array(), $redemptionPoints = null, $travelerRPH = null, $offerPricingRefID = null, $preTaxAmount = null, $taxAmount = null, $amount = null)
    {
        $this
            ->setTaxInfo($taxInfo)
            ->setRedemptionPoints($redemptionPoints)
            ->setTravelerRPH($travelerRPH)
            ->setOfferPricingRefID($offerPricingRefID)
            ->setPreTaxAmount($preTaxAmount)
            ->setTaxAmount($taxAmount)
            ->setAmount($amount);
    }
    /**
     * Get TaxInfo value
     * @return mixed[]|null
     */
    public function getTaxInfo()
    {
        return $this->TaxInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxInfoForArrayConstraintsFromSetTaxInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingDetailTaxInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pricingDetailTaxInfoItem) ? get_class($pricingDetailTaxInfoItem) : sprintf('%s(%s)', gettype($pricingDetailTaxInfoItem), var_export($pricingDetailTaxInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $taxInfo
     * @return \StructType\PricingDetail
     */
    public function setTaxInfo(array $taxInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($taxInfoArrayErrorMessage = self::validateTaxInfoForArrayConstraintsFromSetTaxInfo($taxInfo))) {
            throw new \InvalidArgumentException($taxInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($taxInfo) && count($taxInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($taxInfo)), __LINE__);
        }
        $this->TaxInfo = $taxInfo;
        return $this;
    }
    /**
     * Add item to TaxInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PricingDetail
     */
    public function addToTaxInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TaxInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TaxInfo) && count($this->TaxInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TaxInfo)), __LINE__);
        }
        $this->TaxInfo[] = $item;
        return $this;
    }
    /**
     * Get RedemptionPoints value
     * @return mixed|null
     */
    public function getRedemptionPoints()
    {
        return $this->RedemptionPoints;
    }
    /**
     * Set RedemptionPoints value
     * @param mixed $redemptionPoints
     * @return \StructType\PricingDetail
     */
    public function setRedemptionPoints($redemptionPoints = null)
    {
        $this->RedemptionPoints = $redemptionPoints;
        return $this;
    }
    /**
     * Get TravelerRPH value
     * @return string|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * Set TravelerRPH value
     * @param string $travelerRPH
     * @return \StructType\PricingDetail
     */
    public function setTravelerRPH($travelerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRPH) && !is_string($travelerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerRPH, true), gettype($travelerRPH)), __LINE__);
        }
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Get OfferPricingRefID value
     * @return string|null
     */
    public function getOfferPricingRefID()
    {
        return $this->OfferPricingRefID;
    }
    /**
     * Set OfferPricingRefID value
     * @param string $offerPricingRefID
     * @return \StructType\PricingDetail
     */
    public function setOfferPricingRefID($offerPricingRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerPricingRefID) && !is_string($offerPricingRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerPricingRefID, true), gettype($offerPricingRefID)), __LINE__);
        }
        $this->OfferPricingRefID = $offerPricingRefID;
        return $this;
    }
    /**
     * Get PreTaxAmount value
     * @return float|null
     */
    public function getPreTaxAmount()
    {
        return $this->PreTaxAmount;
    }
    /**
     * Set PreTaxAmount value
     * @param float $preTaxAmount
     * @return \StructType\PricingDetail
     */
    public function setPreTaxAmount($preTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($preTaxAmount) && !(is_float($preTaxAmount) || is_numeric($preTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preTaxAmount, true), gettype($preTaxAmount)), __LINE__);
        }
        $this->PreTaxAmount = $preTaxAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\PricingDetail
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PricingDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricingDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
