<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pricing StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer pricing information, including amounts, tax(s), service family, pricing rules, pricing influencers, exchange rate and redemption amounts.
 * @subpackage Structs
 */
class Pricing extends AbstractStructBase
{
    /**
     * The PricingDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PricingDetail[]
     */
    public $PricingDetail;
    /**
     * The TaxInfo
     * Meta information extracted from the WSDL
     * - documentation: Tax(es) that were applied to this pricing.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TaxInfo;
    /**
     * The RedemptionPoints
     * Meta information extracted from the WSDL
     * - documentation: Redemption pricing information if all or a portion of this offer may be paid using points.
     * - minOccurs: 0
     * @var mixed
     */
    public $RedemptionPoints;
    /**
     * The AppliedRule
     * Meta information extracted from the WSDL
     * - documentation: Rules that applied to this pricing.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AppliedRule;
    /**
     * The PricingQualifier
     * Meta information extracted from the WSDL
     * - documentation: Additional information that influenced the pricing, including restrictions, promotions and tax exemptions.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PricingQualifier;
    /**
     * The ApplyTo
     * Meta information extracted from the WSDL
     * - documentation: References to unique ID(s) set elsewhere in this message to associate this pricing information with.
     * - minOccurs: 0
     * @var mixed
     */
    public $ApplyTo;
    /**
     * The OfferQty
     * Meta information extracted from the WSDL
     * - documentation: The total offer quantity included in this pricing, e.g. 3 seats.
     * - use: optional
     * @var int
     */
    public $OfferQty;
    /**
     * The PassengerQty
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of passengers accommodated.
     * - use: optional
     * @var int
     */
    public $PassengerQty;
    /**
     * The PreTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount charged for the ancillary product that typically does NOT include taxes.
     * - use: optional
     * @var float
     */
    public $PreTaxAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: The tax amount.
     * - use: optional
     * @var float
     */
    public $TaxAmount;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If there is no cost associated with the offer or redemption miles are being used, set this value to 0. | The total amount charged for the ancillary product including any applicable tax(es).
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The PricingCurrency
     * Meta information extracted from the WSDL
     * - documentation: http://www.opentraveldevelopersnetwork.com/Supported_ISO_Standards.php | CAD = Canadian Dollar | USD = United States Dollar | EUR = Euro | The pricing/filing currency in ISO 4217 encoding.
     * - use: optional
     * @var string
     */
    public $PricingCurrency;
    /**
     * The DecimalPlaces
     * Meta information extracted from the WSDL
     * - documentation: This is equivalent to the ISO 4217 standard "minor unit" and is typically used when the amount provided includes the minor unit of currency without a decimal point. |
     * http://www.iso.org/iso/support/faqs/faqs_widely_used_standards/widely_used_standards_other/currency_codes/currency_codes_list-1.htm | USD 8500 with "2" Decimal Places represents $85. | The number of decimal places for the display and pricing
     * currency(s).
     * - use: optional
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The BaseNUC_Amount
     * Meta information extracted from the WSDL
     * - documentation: The base neutral unit of construction amount.
     * - use: optional
     * @var float
     */
    public $BaseNUC_Amount;
    /**
     * The OfferRPH
     * Meta information extracted from the WSDL
     * - documentation: Offer pricing reference place holder.
     * - use: optional
     * @var string
     */
    public $OfferRPH;
    /**
     * The TravelerRPH
     * Meta information extracted from the WSDL
     * - documentation: Associated traveler.(s)
     * - use: optional
     * @var list
     */
    public $TravelerRPH;
    /**
     * Constructor method for Pricing
     * @uses Pricing::setPricingDetail()
     * @uses Pricing::setTaxInfo()
     * @uses Pricing::setRedemptionPoints()
     * @uses Pricing::setAppliedRule()
     * @uses Pricing::setPricingQualifier()
     * @uses Pricing::setApplyTo()
     * @uses Pricing::setOfferQty()
     * @uses Pricing::setPassengerQty()
     * @uses Pricing::setPreTaxAmount()
     * @uses Pricing::setTaxAmount()
     * @uses Pricing::setAmount()
     * @uses Pricing::setPricingCurrency()
     * @uses Pricing::setDecimalPlaces()
     * @uses Pricing::setBaseNUC_Amount()
     * @uses Pricing::setOfferRPH()
     * @uses Pricing::setTravelerRPH()
     * @param \StructType\PricingDetail[] $pricingDetail
     * @param mixed[] $taxInfo
     * @param mixed $redemptionPoints
     * @param mixed[] $appliedRule
     * @param mixed[] $pricingQualifier
     * @param mixed $applyTo
     * @param int $offerQty
     * @param int $passengerQty
     * @param float $preTaxAmount
     * @param float $taxAmount
     * @param float $amount
     * @param string $pricingCurrency
     * @param int $decimalPlaces
     * @param float $baseNUC_Amount
     * @param string $offerRPH
     * @param list $travelerRPH
     */
    public function __construct(array $pricingDetail = array(), array $taxInfo = array(), $redemptionPoints = null, array $appliedRule = array(), array $pricingQualifier = array(), $applyTo = null, $offerQty = null, $passengerQty = null, $preTaxAmount = null, $taxAmount = null, $amount = null, $pricingCurrency = null, $decimalPlaces = null, $baseNUC_Amount = null, $offerRPH = null, list $travelerRPH = null)
    {
        $this
            ->setPricingDetail($pricingDetail)
            ->setTaxInfo($taxInfo)
            ->setRedemptionPoints($redemptionPoints)
            ->setAppliedRule($appliedRule)
            ->setPricingQualifier($pricingQualifier)
            ->setApplyTo($applyTo)
            ->setOfferQty($offerQty)
            ->setPassengerQty($passengerQty)
            ->setPreTaxAmount($preTaxAmount)
            ->setTaxAmount($taxAmount)
            ->setAmount($amount)
            ->setPricingCurrency($pricingCurrency)
            ->setDecimalPlaces($decimalPlaces)
            ->setBaseNUC_Amount($baseNUC_Amount)
            ->setOfferRPH($offerRPH)
            ->setTravelerRPH($travelerRPH);
    }
    /**
     * Get PricingDetail value
     * @return \StructType\PricingDetail[]|null
     */
    public function getPricingDetail()
    {
        return $this->PricingDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPricingDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricingDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingDetailForArrayConstraintsFromSetPricingDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingPricingDetailItem) {
            // validation for constraint: itemType
            if (!$pricingPricingDetailItem instanceof \StructType\PricingDetail) {
                $invalidValues[] = is_object($pricingPricingDetailItem) ? get_class($pricingPricingDetailItem) : sprintf('%s(%s)', gettype($pricingPricingDetailItem), var_export($pricingPricingDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricingDetail property can only contain items of type \StructType\PricingDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricingDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingDetail[] $pricingDetail
     * @return \StructType\Pricing
     */
    public function setPricingDetail(array $pricingDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingDetailArrayErrorMessage = self::validatePricingDetailForArrayConstraintsFromSetPricingDetail($pricingDetail))) {
            throw new \InvalidArgumentException($pricingDetailArrayErrorMessage, __LINE__);
        }
        $this->PricingDetail = $pricingDetail;
        return $this;
    }
    /**
     * Add item to PricingDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingDetail $item
     * @return \StructType\Pricing
     */
    public function addToPricingDetail(\StructType\PricingDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PricingDetail) {
            throw new \InvalidArgumentException(sprintf('The PricingDetail property can only contain items of type \StructType\PricingDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PricingDetail[] = $item;
        return $this;
    }
    /**
     * Get TaxInfo value
     * @return mixed[]|null
     */
    public function getTaxInfo()
    {
        return $this->TaxInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxInfoForArrayConstraintsFromSetTaxInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingTaxInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pricingTaxInfoItem) ? get_class($pricingTaxInfoItem) : sprintf('%s(%s)', gettype($pricingTaxInfoItem), var_export($pricingTaxInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $taxInfo
     * @return \StructType\Pricing
     */
    public function setTaxInfo(array $taxInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($taxInfoArrayErrorMessage = self::validateTaxInfoForArrayConstraintsFromSetTaxInfo($taxInfo))) {
            throw new \InvalidArgumentException($taxInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($taxInfo) && count($taxInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($taxInfo)), __LINE__);
        }
        $this->TaxInfo = $taxInfo;
        return $this;
    }
    /**
     * Add item to TaxInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Pricing
     */
    public function addToTaxInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TaxInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TaxInfo) && count($this->TaxInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TaxInfo)), __LINE__);
        }
        $this->TaxInfo[] = $item;
        return $this;
    }
    /**
     * Get RedemptionPoints value
     * @return mixed|null
     */
    public function getRedemptionPoints()
    {
        return $this->RedemptionPoints;
    }
    /**
     * Set RedemptionPoints value
     * @param mixed $redemptionPoints
     * @return \StructType\Pricing
     */
    public function setRedemptionPoints($redemptionPoints = null)
    {
        $this->RedemptionPoints = $redemptionPoints;
        return $this;
    }
    /**
     * Get AppliedRule value
     * @return mixed[]|null
     */
    public function getAppliedRule()
    {
        return $this->AppliedRule;
    }
    /**
     * This method is responsible for validating the values passed to the setAppliedRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAppliedRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAppliedRuleForArrayConstraintsFromSetAppliedRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingAppliedRuleItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pricingAppliedRuleItem) ? get_class($pricingAppliedRuleItem) : sprintf('%s(%s)', gettype($pricingAppliedRuleItem), var_export($pricingAppliedRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AppliedRule property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AppliedRule value
     * @throws \InvalidArgumentException
     * @param mixed[] $appliedRule
     * @return \StructType\Pricing
     */
    public function setAppliedRule(array $appliedRule = array())
    {
        // validation for constraint: array
        if ('' !== ($appliedRuleArrayErrorMessage = self::validateAppliedRuleForArrayConstraintsFromSetAppliedRule($appliedRule))) {
            throw new \InvalidArgumentException($appliedRuleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($appliedRule) && count($appliedRule) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($appliedRule)), __LINE__);
        }
        $this->AppliedRule = $appliedRule;
        return $this;
    }
    /**
     * Add item to AppliedRule value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Pricing
     */
    public function addToAppliedRule($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AppliedRule property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AppliedRule) && count($this->AppliedRule) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AppliedRule)), __LINE__);
        }
        $this->AppliedRule[] = $item;
        return $this;
    }
    /**
     * Get PricingQualifier value
     * @return mixed[]|null
     */
    public function getPricingQualifier()
    {
        return $this->PricingQualifier;
    }
    /**
     * This method is responsible for validating the values passed to the setPricingQualifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricingQualifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingQualifierForArrayConstraintsFromSetPricingQualifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingPricingQualifierItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pricingPricingQualifierItem) ? get_class($pricingPricingQualifierItem) : sprintf('%s(%s)', gettype($pricingPricingQualifierItem), var_export($pricingPricingQualifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricingQualifier property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricingQualifier value
     * @throws \InvalidArgumentException
     * @param mixed[] $pricingQualifier
     * @return \StructType\Pricing
     */
    public function setPricingQualifier(array $pricingQualifier = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingQualifierArrayErrorMessage = self::validatePricingQualifierForArrayConstraintsFromSetPricingQualifier($pricingQualifier))) {
            throw new \InvalidArgumentException($pricingQualifierArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($pricingQualifier) && count($pricingQualifier) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($pricingQualifier)), __LINE__);
        }
        $this->PricingQualifier = $pricingQualifier;
        return $this;
    }
    /**
     * Add item to PricingQualifier value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Pricing
     */
    public function addToPricingQualifier($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PricingQualifier property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PricingQualifier) && count($this->PricingQualifier) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PricingQualifier)), __LINE__);
        }
        $this->PricingQualifier[] = $item;
        return $this;
    }
    /**
     * Get ApplyTo value
     * @return mixed|null
     */
    public function getApplyTo()
    {
        return $this->ApplyTo;
    }
    /**
     * Set ApplyTo value
     * @param mixed $applyTo
     * @return \StructType\Pricing
     */
    public function setApplyTo($applyTo = null)
    {
        $this->ApplyTo = $applyTo;
        return $this;
    }
    /**
     * Get OfferQty value
     * @return int|null
     */
    public function getOfferQty()
    {
        return $this->OfferQty;
    }
    /**
     * Set OfferQty value
     * @param int $offerQty
     * @return \StructType\Pricing
     */
    public function setOfferQty($offerQty = null)
    {
        // validation for constraint: int
        if (!is_null($offerQty) && !(is_int($offerQty) || ctype_digit($offerQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offerQty, true), gettype($offerQty)), __LINE__);
        }
        $this->OfferQty = $offerQty;
        return $this;
    }
    /**
     * Get PassengerQty value
     * @return int|null
     */
    public function getPassengerQty()
    {
        return $this->PassengerQty;
    }
    /**
     * Set PassengerQty value
     * @param int $passengerQty
     * @return \StructType\Pricing
     */
    public function setPassengerQty($passengerQty = null)
    {
        // validation for constraint: int
        if (!is_null($passengerQty) && !(is_int($passengerQty) || ctype_digit($passengerQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerQty, true), gettype($passengerQty)), __LINE__);
        }
        $this->PassengerQty = $passengerQty;
        return $this;
    }
    /**
     * Get PreTaxAmount value
     * @return float|null
     */
    public function getPreTaxAmount()
    {
        return $this->PreTaxAmount;
    }
    /**
     * Set PreTaxAmount value
     * @param float $preTaxAmount
     * @return \StructType\Pricing
     */
    public function setPreTaxAmount($preTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($preTaxAmount) && !(is_float($preTaxAmount) || is_numeric($preTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preTaxAmount, true), gettype($preTaxAmount)), __LINE__);
        }
        $this->PreTaxAmount = $preTaxAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\Pricing
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Pricing
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PricingCurrency value
     * @return string|null
     */
    public function getPricingCurrency()
    {
        return $this->PricingCurrency;
    }
    /**
     * Set PricingCurrency value
     * @param string $pricingCurrency
     * @return \StructType\Pricing
     */
    public function setPricingCurrency($pricingCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($pricingCurrency) && !is_string($pricingCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingCurrency, true), gettype($pricingCurrency)), __LINE__);
        }
        $this->PricingCurrency = $pricingCurrency;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\Pricing
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get BaseNUC_Amount value
     * @return float|null
     */
    public function getBaseNUC_Amount()
    {
        return $this->BaseNUC_Amount;
    }
    /**
     * Set BaseNUC_Amount value
     * @param float $baseNUC_Amount
     * @return \StructType\Pricing
     */
    public function setBaseNUC_Amount($baseNUC_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($baseNUC_Amount) && !(is_float($baseNUC_Amount) || is_numeric($baseNUC_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseNUC_Amount, true), gettype($baseNUC_Amount)), __LINE__);
        }
        $this->BaseNUC_Amount = $baseNUC_Amount;
        return $this;
    }
    /**
     * Get OfferRPH value
     * @return string|null
     */
    public function getOfferRPH()
    {
        return $this->OfferRPH;
    }
    /**
     * Set OfferRPH value
     * @param string $offerRPH
     * @return \StructType\Pricing
     */
    public function setOfferRPH($offerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($offerRPH) && !is_string($offerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerRPH, true), gettype($offerRPH)), __LINE__);
        }
        $this->OfferRPH = $offerRPH;
        return $this;
    }
    /**
     * Get TravelerRPH value
     * @return list|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * Set TravelerRPH value
     * @param list $travelerRPH
     * @return \StructType\Pricing
     */
    public function setTravelerRPH(list $travelerRPH = null)
    {
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Pricing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
