<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prices StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of room-based passenger-level prices. These will be either actual prices or supplemental charges dependent on the SupplementIndicator attribute. When these are actual prices, they may be by MealPlan (e.g., room prices on
 * HalfBoard arrangement, together with prices on Full Board).
 * @subpackage Structs
 */
class Prices extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\Price[]
     */
    public $Price;
    /**
     * The SupplementIndicator
     * Meta information extracted from the WSDL
     * - documentation: When 'true', the Amount value in each Price element is additional to the base price; when 'false', the Amount is a full passenger price.
     * - use: optional
     * @var bool
     */
    public $SupplementIndicator;
    /**
     * The MealPlanRPH
     * Meta information extracted from the WSDL
     * - documentation: Pointer to the MealPlan for which this set of RoomPrices applies - normally used when the SupplementIndicator attribute is 'False'.
     * - use: optional
     * @var string
     */
    public $MealPlanRPH;
    /**
     * Constructor method for Prices
     * @uses Prices::setPrice()
     * @uses Prices::setSupplementIndicator()
     * @uses Prices::setMealPlanRPH()
     * @param \StructType\Price[] $price
     * @param bool $supplementIndicator
     * @param string $mealPlanRPH
     */
    public function __construct(array $price = array(), $supplementIndicator = null, $mealPlanRPH = null)
    {
        $this
            ->setPrice($price)
            ->setSupplementIndicator($supplementIndicator)
            ->setMealPlanRPH($mealPlanRPH);
    }
    /**
     * Get Price value
     * @return \StructType\Price[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricesPriceItem) {
            // validation for constraint: itemType
            if (!$pricesPriceItem instanceof \StructType\Price) {
                $invalidValues[] = is_object($pricesPriceItem) ? get_class($pricesPriceItem) : sprintf('%s(%s)', gettype($pricesPriceItem), var_export($pricesPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\Price, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\Price[] $price
     * @return \StructType\Prices
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($price) && count($price) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\Price $item
     * @return \StructType\Prices
     */
    public function addToPrice(\StructType\Price $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Price) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\Price, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Price) && count($this->Price) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Price)), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get SupplementIndicator value
     * @return bool|null
     */
    public function getSupplementIndicator()
    {
        return $this->SupplementIndicator;
    }
    /**
     * Set SupplementIndicator value
     * @param bool $supplementIndicator
     * @return \StructType\Prices
     */
    public function setSupplementIndicator($supplementIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($supplementIndicator) && !is_bool($supplementIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supplementIndicator, true), gettype($supplementIndicator)), __LINE__);
        }
        $this->SupplementIndicator = $supplementIndicator;
        return $this;
    }
    /**
     * Get MealPlanRPH value
     * @return string|null
     */
    public function getMealPlanRPH()
    {
        return $this->MealPlanRPH;
    }
    /**
     * Set MealPlanRPH value
     * @param string $mealPlanRPH
     * @return \StructType\Prices
     */
    public function setMealPlanRPH($mealPlanRPH = null)
    {
        // validation for constraint: string
        if (!is_null($mealPlanRPH) && !is_string($mealPlanRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mealPlanRPH, true), gettype($mealPlanRPH)), __LINE__);
        }
        $this->MealPlanRPH = $mealPlanRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Prices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
