<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Priced StructType
 * Meta information extracted from the WSDL
 * - documentation: Priced air offers.
 * @subpackage Structs
 */
class Priced extends AirPricedOfferType
{
    /**
     * The FlightSegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: Applicable flight segment.
     * - use: optional
     * @var string
     */
    public $FlightSegmentRPH;
    /**
     * The ItineraryRPH
     * Meta information extracted from the WSDL
     * - documentation: Applicable itinerary.
     * - use: optional
     * @var string
     */
    public $ItineraryRPH;
    /**
     * The OrigDestRPH
     * Meta information extracted from the WSDL
     * - documentation: Applicable origin/ destination pair.
     * - use: optional
     * @var string
     */
    public $OrigDestRPH;
    /**
     * The TravelerRPH
     * Meta information extracted from the WSDL
     * - documentation: Applicable traveler.
     * - use: optional
     * @var string
     */
    public $TravelerRPH;
    /**
     * Constructor method for Priced
     * @uses Priced::setFlightSegmentRPH()
     * @uses Priced::setItineraryRPH()
     * @uses Priced::setOrigDestRPH()
     * @uses Priced::setTravelerRPH()
     * @param string $flightSegmentRPH
     * @param string $itineraryRPH
     * @param string $origDestRPH
     * @param string $travelerRPH
     */
    public function __construct($flightSegmentRPH = null, $itineraryRPH = null, $origDestRPH = null, $travelerRPH = null)
    {
        $this
            ->setFlightSegmentRPH($flightSegmentRPH)
            ->setItineraryRPH($itineraryRPH)
            ->setOrigDestRPH($origDestRPH)
            ->setTravelerRPH($travelerRPH);
    }
    /**
     * Get FlightSegmentRPH value
     * @return string|null
     */
    public function getFlightSegmentRPH()
    {
        return $this->FlightSegmentRPH;
    }
    /**
     * Set FlightSegmentRPH value
     * @param string $flightSegmentRPH
     * @return \StructType\Priced
     */
    public function setFlightSegmentRPH($flightSegmentRPH = null)
    {
        // validation for constraint: string
        if (!is_null($flightSegmentRPH) && !is_string($flightSegmentRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightSegmentRPH, true), gettype($flightSegmentRPH)), __LINE__);
        }
        $this->FlightSegmentRPH = $flightSegmentRPH;
        return $this;
    }
    /**
     * Get ItineraryRPH value
     * @return string|null
     */
    public function getItineraryRPH()
    {
        return $this->ItineraryRPH;
    }
    /**
     * Set ItineraryRPH value
     * @param string $itineraryRPH
     * @return \StructType\Priced
     */
    public function setItineraryRPH($itineraryRPH = null)
    {
        // validation for constraint: string
        if (!is_null($itineraryRPH) && !is_string($itineraryRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itineraryRPH, true), gettype($itineraryRPH)), __LINE__);
        }
        $this->ItineraryRPH = $itineraryRPH;
        return $this;
    }
    /**
     * Get OrigDestRPH value
     * @return string|null
     */
    public function getOrigDestRPH()
    {
        return $this->OrigDestRPH;
    }
    /**
     * Set OrigDestRPH value
     * @param string $origDestRPH
     * @return \StructType\Priced
     */
    public function setOrigDestRPH($origDestRPH = null)
    {
        // validation for constraint: string
        if (!is_null($origDestRPH) && !is_string($origDestRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origDestRPH, true), gettype($origDestRPH)), __LINE__);
        }
        $this->OrigDestRPH = $origDestRPH;
        return $this;
    }
    /**
     * Get TravelerRPH value
     * @return string|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * Set TravelerRPH value
     * @param string $travelerRPH
     * @return \StructType\Priced
     */
    public function setTravelerRPH($travelerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRPH) && !is_string($travelerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerRPH, true), gettype($travelerRPH)), __LINE__);
        }
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Priced
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
