<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceRequestInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to describe a price request. | Identify pricing source, if negotiated fares are requested and if it is a reprice request.
 * @subpackage Structs
 */
class PriceRequestInformationType extends AbstractStructBase
{
    /**
     * The NegotiatedFareCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NegotiatedFareCode[]
     */
    public $NegotiatedFareCode;
    /**
     * The RebookOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\RebookOption[]
     */
    public $RebookOption;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of cabin (i.e., first, business, economy) requested.
     * - use: optional
     * @var string
     */
    public $CabinType;
    /**
     * The TicketingCountry
     * Meta information extracted from the WSDL
     * - documentation: The ISO country code where the ticket will be issued.
     * - use: optional
     * @var string
     */
    public $TicketingCountry;
    /**
     * The OverrideAirlineCode
     * Meta information extracted from the WSDL
     * - documentation: The airline which should be used to override the system selected pricing airline.
     * - use: optional
     * @var string
     */
    public $OverrideAirlineCode;
    /**
     * Constructor method for PriceRequestInformationType
     * @uses PriceRequestInformationType::setNegotiatedFareCode()
     * @uses PriceRequestInformationType::setRebookOption()
     * @uses PriceRequestInformationType::setTPA_Extensions()
     * @uses PriceRequestInformationType::setCabinType()
     * @uses PriceRequestInformationType::setTicketingCountry()
     * @uses PriceRequestInformationType::setOverrideAirlineCode()
     * @param \StructType\NegotiatedFareCode[] $negotiatedFareCode
     * @param \StructType\RebookOption[] $rebookOption
     * @param mixed $tPA_Extensions
     * @param string $cabinType
     * @param string $ticketingCountry
     * @param string $overrideAirlineCode
     */
    public function __construct(array $negotiatedFareCode = array(), array $rebookOption = array(), $tPA_Extensions = null, $cabinType = null, $ticketingCountry = null, $overrideAirlineCode = null)
    {
        $this
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->setRebookOption($rebookOption)
            ->setTPA_Extensions($tPA_Extensions)
            ->setCabinType($cabinType)
            ->setTicketingCountry($ticketingCountry)
            ->setOverrideAirlineCode($overrideAirlineCode);
    }
    /**
     * Get NegotiatedFareCode value
     * @return \StructType\NegotiatedFareCode[]|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * This method is responsible for validating the values passed to the setNegotiatedFareCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNegotiatedFareCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNegotiatedFareCodeForArrayConstraintsFromSetNegotiatedFareCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceRequestInformationTypeNegotiatedFareCodeItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationTypeNegotiatedFareCodeItem instanceof \StructType\NegotiatedFareCode) {
                $invalidValues[] = is_object($priceRequestInformationTypeNegotiatedFareCodeItem) ? get_class($priceRequestInformationTypeNegotiatedFareCodeItem) : sprintf('%s(%s)', gettype($priceRequestInformationTypeNegotiatedFareCodeItem), var_export($priceRequestInformationTypeNegotiatedFareCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NegotiatedFareCode property can only contain items of type \StructType\NegotiatedFareCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NegotiatedFareCode value
     * @throws \InvalidArgumentException
     * @param \StructType\NegotiatedFareCode[] $negotiatedFareCode
     * @return \StructType\PriceRequestInformationType
     */
    public function setNegotiatedFareCode(array $negotiatedFareCode = array())
    {
        // validation for constraint: array
        if ('' !== ($negotiatedFareCodeArrayErrorMessage = self::validateNegotiatedFareCodeForArrayConstraintsFromSetNegotiatedFareCode($negotiatedFareCode))) {
            throw new \InvalidArgumentException($negotiatedFareCodeArrayErrorMessage, __LINE__);
        }
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Add item to NegotiatedFareCode value
     * @throws \InvalidArgumentException
     * @param \StructType\NegotiatedFareCode $item
     * @return \StructType\PriceRequestInformationType
     */
    public function addToNegotiatedFareCode(\StructType\NegotiatedFareCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NegotiatedFareCode) {
            throw new \InvalidArgumentException(sprintf('The NegotiatedFareCode property can only contain items of type \StructType\NegotiatedFareCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NegotiatedFareCode[] = $item;
        return $this;
    }
    /**
     * Get RebookOption value
     * @return \StructType\RebookOption[]|null
     */
    public function getRebookOption()
    {
        return $this->RebookOption;
    }
    /**
     * This method is responsible for validating the values passed to the setRebookOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRebookOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRebookOptionForArrayConstraintsFromSetRebookOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceRequestInformationTypeRebookOptionItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationTypeRebookOptionItem instanceof \StructType\RebookOption) {
                $invalidValues[] = is_object($priceRequestInformationTypeRebookOptionItem) ? get_class($priceRequestInformationTypeRebookOptionItem) : sprintf('%s(%s)', gettype($priceRequestInformationTypeRebookOptionItem), var_export($priceRequestInformationTypeRebookOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RebookOption property can only contain items of type \StructType\RebookOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RebookOption value
     * @throws \InvalidArgumentException
     * @param \StructType\RebookOption[] $rebookOption
     * @return \StructType\PriceRequestInformationType
     */
    public function setRebookOption(array $rebookOption = array())
    {
        // validation for constraint: array
        if ('' !== ($rebookOptionArrayErrorMessage = self::validateRebookOptionForArrayConstraintsFromSetRebookOption($rebookOption))) {
            throw new \InvalidArgumentException($rebookOptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($rebookOption) && count($rebookOption) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($rebookOption)), __LINE__);
        }
        $this->RebookOption = $rebookOption;
        return $this;
    }
    /**
     * Add item to RebookOption value
     * @throws \InvalidArgumentException
     * @param \StructType\RebookOption $item
     * @return \StructType\PriceRequestInformationType
     */
    public function addToRebookOption(\StructType\RebookOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RebookOption) {
            throw new \InvalidArgumentException(sprintf('The RebookOption property can only contain items of type \StructType\RebookOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RebookOption) && count($this->RebookOption) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RebookOption)), __LINE__);
        }
        $this->RebookOption[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\PriceRequestInformationType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get CabinType value
     * @return string|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \StructType\PriceRequestInformationType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($cabinType) ? implode(', ', $cabinType) : var_export($cabinType, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get TicketingCountry value
     * @return string|null
     */
    public function getTicketingCountry()
    {
        return $this->TicketingCountry;
    }
    /**
     * Set TicketingCountry value
     * @param string $ticketingCountry
     * @return \StructType\PriceRequestInformationType
     */
    public function setTicketingCountry($ticketingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingCountry) && !is_string($ticketingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingCountry, true), gettype($ticketingCountry)), __LINE__);
        }
        $this->TicketingCountry = $ticketingCountry;
        return $this;
    }
    /**
     * Get OverrideAirlineCode value
     * @return string|null
     */
    public function getOverrideAirlineCode()
    {
        return $this->OverrideAirlineCode;
    }
    /**
     * Set OverrideAirlineCode value
     * @param string $overrideAirlineCode
     * @return \StructType\PriceRequestInformationType
     */
    public function setOverrideAirlineCode($overrideAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($overrideAirlineCode) && !is_string($overrideAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideAirlineCode, true), gettype($overrideAirlineCode)), __LINE__);
        }
        $this->OverrideAirlineCode = $overrideAirlineCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceRequestInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
