<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of price info. | Collection of price infos.
 * @subpackage Structs
 */
class PriceInfos extends AbstractStructBase
{
    /**
     * The PriceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\PriceInfo[]
     */
    public $PriceInfo;
    /**
     * Constructor method for PriceInfos
     * @uses PriceInfos::setPriceInfo()
     * @param \StructType\PriceInfo[] $priceInfo
     */
    public function __construct(array $priceInfo = array())
    {
        $this
            ->setPriceInfo($priceInfo);
    }
    /**
     * Get PriceInfo value
     * @return \StructType\PriceInfo[]|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceInfoForArrayConstraintsFromSetPriceInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceInfosPriceInfoItem) {
            // validation for constraint: itemType
            if (!$priceInfosPriceInfoItem instanceof \StructType\PriceInfo) {
                $invalidValues[] = is_object($priceInfosPriceInfoItem) ? get_class($priceInfosPriceInfoItem) : sprintf('%s(%s)', gettype($priceInfosPriceInfoItem), var_export($priceInfosPriceInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceInfo property can only contain items of type \StructType\PriceInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PriceInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceInfo[] $priceInfo
     * @return \StructType\PriceInfos
     */
    public function setPriceInfo(array $priceInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($priceInfoArrayErrorMessage = self::validatePriceInfoForArrayConstraintsFromSetPriceInfo($priceInfo))) {
            throw new \InvalidArgumentException($priceInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($priceInfo) && count($priceInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($priceInfo)), __LINE__);
        }
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Add item to PriceInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceInfo $item
     * @return \StructType\PriceInfos
     */
    public function addToPriceInfo(\StructType\PriceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceInfo) {
            throw new \InvalidArgumentException(sprintf('The PriceInfo property can only contain items of type \StructType\PriceInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PriceInfo) && count($this->PriceInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PriceInfo)), __LINE__);
        }
        $this->PriceInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
