<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrefCollection StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of data between parties. | Aggregation of customer travel needs.
 * @subpackage Structs
 */
class PrefCollection extends AbstractStructBase
{
    /**
     * The CommonPref
     * Meta information extracted from the WSDL
     * - documentation: Supplier-independent preferences.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $CommonPref;
    /**
     * The VehicleRentalPref
     * Meta information extracted from the WSDL
     * - documentation: A set of preferences for vehicle rental.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $VehicleRentalPref;
    /**
     * The AirlinePref
     * Meta information extracted from the WSDL
     * - documentation: A set of preferences for air travel.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AirlinePref;
    /**
     * The HotelPref
     * Meta information extracted from the WSDL
     * - documentation: A set of preferences for hotel stay.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $HotelPref;
    /**
     * The RailPref
     * Meta information extracted from the WSDL
     * - documentation: A set of preferences for rail travel
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RailPref;
    /**
     * The OtherSrvcPref
     * Meta information extracted from the WSDL
     * - documentation: A set of preferences for other services.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $OtherSrvcPref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The TravelPurpose
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Travel Purpose (TVP).
     * - use: optional
     * @var string
     */
    public $TravelPurpose;
    /**
     * Constructor method for PrefCollection
     * @uses PrefCollection::setCommonPref()
     * @uses PrefCollection::setVehicleRentalPref()
     * @uses PrefCollection::setAirlinePref()
     * @uses PrefCollection::setHotelPref()
     * @uses PrefCollection::setRailPref()
     * @uses PrefCollection::setOtherSrvcPref()
     * @uses PrefCollection::setTPA_Extensions()
     * @uses PrefCollection::setTravelPurpose()
     * @param mixed[] $commonPref
     * @param mixed[] $vehicleRentalPref
     * @param mixed[] $airlinePref
     * @param mixed[] $hotelPref
     * @param mixed[] $railPref
     * @param mixed[] $otherSrvcPref
     * @param mixed $tPA_Extensions
     * @param string $travelPurpose
     */
    public function __construct(array $commonPref = array(), array $vehicleRentalPref = array(), array $airlinePref = array(), array $hotelPref = array(), array $railPref = array(), array $otherSrvcPref = array(), $tPA_Extensions = null, $travelPurpose = null)
    {
        $this
            ->setCommonPref($commonPref)
            ->setVehicleRentalPref($vehicleRentalPref)
            ->setAirlinePref($airlinePref)
            ->setHotelPref($hotelPref)
            ->setRailPref($railPref)
            ->setOtherSrvcPref($otherSrvcPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTravelPurpose($travelPurpose);
    }
    /**
     * Get CommonPref value
     * @return mixed[]|null
     */
    public function getCommonPref()
    {
        return $this->CommonPref;
    }
    /**
     * This method is responsible for validating the values passed to the setCommonPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommonPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommonPrefForArrayConstraintsFromSetCommonPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prefCollectionCommonPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($prefCollectionCommonPrefItem) ? get_class($prefCollectionCommonPrefItem) : sprintf('%s(%s)', gettype($prefCollectionCommonPrefItem), var_export($prefCollectionCommonPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommonPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommonPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $commonPref
     * @return \StructType\PrefCollection
     */
    public function setCommonPref(array $commonPref = array())
    {
        // validation for constraint: array
        if ('' !== ($commonPrefArrayErrorMessage = self::validateCommonPrefForArrayConstraintsFromSetCommonPref($commonPref))) {
            throw new \InvalidArgumentException($commonPrefArrayErrorMessage, __LINE__);
        }
        $this->CommonPref = $commonPref;
        return $this;
    }
    /**
     * Add item to CommonPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PrefCollection
     */
    public function addToCommonPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The CommonPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommonPref[] = $item;
        return $this;
    }
    /**
     * Get VehicleRentalPref value
     * @return mixed[]|null
     */
    public function getVehicleRentalPref()
    {
        return $this->VehicleRentalPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVehicleRentalPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicleRentalPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehicleRentalPrefForArrayConstraintsFromSetVehicleRentalPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prefCollectionVehicleRentalPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($prefCollectionVehicleRentalPrefItem) ? get_class($prefCollectionVehicleRentalPrefItem) : sprintf('%s(%s)', gettype($prefCollectionVehicleRentalPrefItem), var_export($prefCollectionVehicleRentalPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehicleRentalPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehicleRentalPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $vehicleRentalPref
     * @return \StructType\PrefCollection
     */
    public function setVehicleRentalPref(array $vehicleRentalPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vehicleRentalPrefArrayErrorMessage = self::validateVehicleRentalPrefForArrayConstraintsFromSetVehicleRentalPref($vehicleRentalPref))) {
            throw new \InvalidArgumentException($vehicleRentalPrefArrayErrorMessage, __LINE__);
        }
        $this->VehicleRentalPref = $vehicleRentalPref;
        return $this;
    }
    /**
     * Add item to VehicleRentalPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PrefCollection
     */
    public function addToVehicleRentalPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The VehicleRentalPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VehicleRentalPref[] = $item;
        return $this;
    }
    /**
     * Get AirlinePref value
     * @return mixed[]|null
     */
    public function getAirlinePref()
    {
        return $this->AirlinePref;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlinePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlinePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlinePrefForArrayConstraintsFromSetAirlinePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prefCollectionAirlinePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($prefCollectionAirlinePrefItem) ? get_class($prefCollectionAirlinePrefItem) : sprintf('%s(%s)', gettype($prefCollectionAirlinePrefItem), var_export($prefCollectionAirlinePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlinePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlinePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $airlinePref
     * @return \StructType\PrefCollection
     */
    public function setAirlinePref(array $airlinePref = array())
    {
        // validation for constraint: array
        if ('' !== ($airlinePrefArrayErrorMessage = self::validateAirlinePrefForArrayConstraintsFromSetAirlinePref($airlinePref))) {
            throw new \InvalidArgumentException($airlinePrefArrayErrorMessage, __LINE__);
        }
        $this->AirlinePref = $airlinePref;
        return $this;
    }
    /**
     * Add item to AirlinePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PrefCollection
     */
    public function addToAirlinePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AirlinePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlinePref[] = $item;
        return $this;
    }
    /**
     * Get HotelPref value
     * @return mixed[]|null
     */
    public function getHotelPref()
    {
        return $this->HotelPref;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelPrefForArrayConstraintsFromSetHotelPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prefCollectionHotelPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($prefCollectionHotelPrefItem) ? get_class($prefCollectionHotelPrefItem) : sprintf('%s(%s)', gettype($prefCollectionHotelPrefItem), var_export($prefCollectionHotelPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $hotelPref
     * @return \StructType\PrefCollection
     */
    public function setHotelPref(array $hotelPref = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelPrefArrayErrorMessage = self::validateHotelPrefForArrayConstraintsFromSetHotelPref($hotelPref))) {
            throw new \InvalidArgumentException($hotelPrefArrayErrorMessage, __LINE__);
        }
        $this->HotelPref = $hotelPref;
        return $this;
    }
    /**
     * Add item to HotelPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PrefCollection
     */
    public function addToHotelPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The HotelPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelPref[] = $item;
        return $this;
    }
    /**
     * Get RailPref value
     * @return mixed[]|null
     */
    public function getRailPref()
    {
        return $this->RailPref;
    }
    /**
     * This method is responsible for validating the values passed to the setRailPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRailPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRailPrefForArrayConstraintsFromSetRailPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prefCollectionRailPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($prefCollectionRailPrefItem) ? get_class($prefCollectionRailPrefItem) : sprintf('%s(%s)', gettype($prefCollectionRailPrefItem), var_export($prefCollectionRailPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RailPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RailPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $railPref
     * @return \StructType\PrefCollection
     */
    public function setRailPref(array $railPref = array())
    {
        // validation for constraint: array
        if ('' !== ($railPrefArrayErrorMessage = self::validateRailPrefForArrayConstraintsFromSetRailPref($railPref))) {
            throw new \InvalidArgumentException($railPrefArrayErrorMessage, __LINE__);
        }
        $this->RailPref = $railPref;
        return $this;
    }
    /**
     * Add item to RailPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PrefCollection
     */
    public function addToRailPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RailPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RailPref[] = $item;
        return $this;
    }
    /**
     * Get OtherSrvcPref value
     * @return mixed[]|null
     */
    public function getOtherSrvcPref()
    {
        return $this->OtherSrvcPref;
    }
    /**
     * This method is responsible for validating the values passed to the setOtherSrvcPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherSrvcPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherSrvcPrefForArrayConstraintsFromSetOtherSrvcPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prefCollectionOtherSrvcPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($prefCollectionOtherSrvcPrefItem) ? get_class($prefCollectionOtherSrvcPrefItem) : sprintf('%s(%s)', gettype($prefCollectionOtherSrvcPrefItem), var_export($prefCollectionOtherSrvcPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OtherSrvcPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OtherSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $otherSrvcPref
     * @return \StructType\PrefCollection
     */
    public function setOtherSrvcPref(array $otherSrvcPref = array())
    {
        // validation for constraint: array
        if ('' !== ($otherSrvcPrefArrayErrorMessage = self::validateOtherSrvcPrefForArrayConstraintsFromSetOtherSrvcPref($otherSrvcPref))) {
            throw new \InvalidArgumentException($otherSrvcPrefArrayErrorMessage, __LINE__);
        }
        $this->OtherSrvcPref = $otherSrvcPref;
        return $this;
    }
    /**
     * Add item to OtherSrvcPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PrefCollection
     */
    public function addToOtherSrvcPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OtherSrvcPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OtherSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\PrefCollection
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \StructType\PrefCollection
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelPurpose, true), gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrefCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
